package com.bringspring.system.external.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.context.SpringContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

import java.io.IOException;
import java.nio.charset.Charset;

import static com.bringspring.common.constant.CacheConsts.JSSDKUTIL_CACHE;

/**
 * JS-SDK 工具类
 * 企业内部开发 客户端API
 */
public class JSSDKUtil {

    // 获取access_token,请求URL
    private final static String ACCESS_TOKEN_URL_FULL = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=@corpid" +
            "&corpsecret=@corpsecret";
    // 设置access_token缓存key
    private final static String ACCESS_TOKEN_KEY = "js_sdk_access_token";
    // 获取企业的jsapi_ticket,请求URL
    private final static String JSAPI_TICKET_URL_FULL = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?" +
            "access_token=@accessToken";
    // 设置jsapi_ticket缓存key
    private final static String JSAPI_TICKET_KEY = "js_sdk_jsapi_ticket";
    // 企业号Id
    private static String CORP_ID = "wwc0366cea7d993696";

    public static void setCorpId(String corpId) {
        CORP_ID = corpId;
    }

    // 凭证密钥
    private static String CORP_SECRET = "d4z8cZVI4G2EhWOUy9hGY-6R4oIzN93WLyxgvkb2MxY";

    public static void setCorpSecret(String corpSecret) {
        CORP_SECRET = corpSecret;
    }

    private static CacheUtil cacheUtil = SpringContext.getBean(CacheUtil.class);

    /**
     * 获取AccessToken
     */
    public static String getAccessToken() {
        Object string = cacheUtil.query(ACCESS_TOKEN_KEY);
        String result = ObjectUtil.isNotEmpty(string) ? string.toString() : "";
        if (StringUtils.isEmpty(result)) {
            result = httpGetAccessToken(CORP_ID, CORP_SECRET);
        }
        return result;
    }

    /**
     * 获取AccessToken
     * 凭证的有效时间（秒）7200
     */
    public static String httpGetAccessToken(String corpid, String corpsecret) {
        String result = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            /**
             * 1.实例化HttpClient对象
             */
            /**
             * 2.定义远程访问的url地址
             */
            String tokenURL = ACCESS_TOKEN_URL_FULL.replace("@corpid", corpid).replace("@corpsecret", corpsecret);
            /**
             * 3.定义请求类型的对象
             */
            HttpGet httpGet = new HttpGet(tokenURL);
            /**
             * 4.发起http请求，获取响应结果
             */
            try (CloseableHttpResponse httpResponse = httpClient.execute(httpGet)) {
                /**
                 * 5.对返回值结果进行校验，获取真实的数据信息
                 */
                //404：找不到页面，406：参数异常，500：后端服务器异常，504：超时，502：访问网址不存在
                int status = httpResponse.getCode();
                if (status == 200) {
                    //获取响应结果：
                    HttpEntity entity = httpResponse.getEntity();
                    try {
                        result = EntityUtils.toString(entity);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    // 将数据转换成json
                    JSONObject jasonObject = JSONObject.parseObject(result);
                    result = (String) jasonObject.get("access_token");

                    // 放入redis缓存
                    if (ObjectUtil.isNotEmpty(cacheUtil)) {
                        cacheUtil.insert(JSSDKUTIL_CACHE, ACCESS_TOKEN_KEY, result, RedisUtil.CAHCEHOUR * 2);
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 获取 JsapiTicket
     * 凭证的有效时间（秒）7200
     */
    public static String getJsapiTicket() {
        Object string = cacheUtil.query(JSAPI_TICKET_KEY);
        String result = ObjectUtil.isNotEmpty(string) ? string.toString() : "";
        if (StringUtils.isEmpty(result)) {
            String accessToken = getAccessToken();
            result = httpGetJsapiTicket(accessToken);
        }
        return result;
    }

    /**
     * 获取 JsapiTicket
     * 凭证的有效时间（秒）7200
     */
    public static String httpGetJsapiTicket(String accessToken) {
        String result = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault()) {
            /**
             * 1.实例化HttpClient对象
             */
            /**
             * 2.定义远程访问的url地址
             */
            String ticketURL = JSAPI_TICKET_URL_FULL.replace("@accessToken", accessToken);
            /**
             * 3.定义请求类型的对象
             */
            HttpGet httpGet = new HttpGet(ticketURL);
            /**
             * 4.发起http请求，获取响应结果
             */
            try (CloseableHttpResponse httpResponse = httpClient.execute(httpGet)) {
                /**
                 * 5.对返回值结果进行校验，获取真实的数据信息
                 */
                //404：找不到页面，406：参数异常，500：后端服务器异常，504：超时，502：访问网址不存在
                int status = httpResponse.getCode();
                if (status == 200) {
                    //获取响应结果：
                    HttpEntity entity = httpResponse.getEntity();
                    try {
                        result = EntityUtils.toString(entity);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    // 将数据转换成json
                    JSONObject jasonObject = JSONObject.parseObject(result);
                    result = (String) jasonObject.get("ticket");//获取结果中的 ticket

                    // 放入redis缓存
                    if (ObjectUtil.isNotEmpty(cacheUtil)) {
                        cacheUtil.insert(JSSDKUTIL_CACHE, JSAPI_TICKET_KEY, result, RedisUtil.CAHCEHOUR * 2);
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 通过SHA1加密方式 获取signature及其他参数信息
     *
     * @param hrefUrl url（当前网页的URL， 不包含#及其后面部分）
     * @return
     */
    public static JSONObject getSignAndOtherData(String hrefUrl) {
        JSONObject jsonMap = new JSONObject();
        try {
            String url = hrefUrl;
            Long timestamp = System.currentTimeMillis();// 时间戳
            String nonceStr = RandomUtil.randomString(16); // 生成签名的随机串
            String signature = "";//签名
            String jsapiTicket = getJsapiTicket();
            if (StringUtils.isNotEmpty(jsapiTicket)) {
                String signatureSha = "jsapi_ticket=@ticket&noncestr=@noncestr&timestamp=@timestamp&url=@url";
                signatureSha = signatureSha.replace("@ticket", jsapiTicket).replace("@noncestr", nonceStr)
                        .replace("@timestamp", timestamp.toString()).replace("@url", url);
                signature = DigestUtils.sha1Hex(signatureSha.getBytes(Charset.forName("UTF-8")));
            }

            jsonMap.put("appId", CORP_ID);
            jsonMap.put("timestamp", timestamp);
            jsonMap.put("nonceStr", nonceStr);
            jsonMap.put("signature", signature);

        } catch (Exception e) {
            e.printStackTrace();
        }
        return jsonMap;
    }


    public static void main(String[] args) {
//        String accessToken = JSSDKUtil.httpGetAccessToken(CORP_ID, CORP_SECRET);
//        System.out.println("accessToken:" + accessToken);
//        String jsapiTicket = JSSDKUtil.httpGetJsapiTicket(accessToken);
//        System.out.println(jsapiTicket);

        JSONObject signAndOtherData = JSSDKUtil.getSignAndOtherData("http://192.168.1.164:8080/");
        System.out.println(signAndOtherData);
    }
}