package com.bringspring.system.message.model.message;

import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 消息模型
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/20 11:44
 */
@Data
public class SentMessageForm {

    /**
     * 接收人员用户ID组
     */
    private List<String> toUserIds;

    /**
     * 消息模板Id
     */
    private String templateId;
    /**
     * 消息业务类型（用于判断消息跳转）
     */
    private Integer type;

    /**
     * 标题
     */
    private String title;
    /**
     * 内容
     */
    private String content;
    /**
     * 站内信BodyText,携带业务数据
     */
    private Map<String, String> bodyText;

    /**
     * 参数
     */
    private Map<String, String> parameterMap;

    private String url;

    private String messageTime;

    private String creatorUser;

    private String templateJson;

    private String pcUrl; // ""  null  “”

    private String appUrl;  // null  ""   ""

    private String termType; // 1:支持appUrl  2:支持pcUrl  3:支持appUrl和pcUrl

    private String termTypeDesc;  //描述: 请用手机端打开链接


}
