package com.bringspring.system.msgcenter.enums;

/**
 * mc_task_msg_receive表 deleteMark 字段枚举类
 *
 * @版本： V1.0.0
 * @日期： 2021/4/23 17:45
 */
public enum DeleteMarkEnum {
    /**
     * 默认状态-未忽略（有效未删除）
     */
    NON_DELETE(0, "未忽略"),
    /**
     * 发送失败-忽略失败（无效已删除）
     */
    DELETE(1, "已忽略");

    private Integer code;
    private String lable;

    DeleteMarkEnum(Integer code, String lable) {
        this.code = code;
        this.lable = lable;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getLable() {
        return lable;
    }

    public void setLable(String lable) {
        this.lable = lable;
    }

    /**
     * 根据状态code获取枚举值
     *
     * @return
     */
    public static DeleteMarkEnum getByCode(Integer code) {
        for (DeleteMarkEnum v : DeleteMarkEnum.values()) {
            if (v.getCode().equals(code)) {
                return v;
            }
        }
        return null;
    }
}
