package com.bringspring.system.msgcenter.service.strategy.factory;

import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Component
@Slf4j
public class MessageChannelStrategyFactory {
    private Map<String, AbstractMessageChannelStrategy> strategies;

    @Autowired
    public MessageChannelStrategyFactory(List<AbstractMessageChannelStrategy> strategyList) {
        strategies = strategyList.stream().collect(
                Collectors.toMap(s -> s.getChannelType().getCode(), Function.identity(),
                        (existing, replacement) -> {
                            log.warn("重复的渠道类型: {}", existing.getChannelType());
                            return existing;
                        })
        );
    }

    public AbstractMessageChannelStrategy getStrategy(String channelType) {
        return strategies.get(channelType);
    }
}
