package com.bringspring.system.permission.model.user.page;

import com.bringspring.common.base.Pagination;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.List;

/**
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class PaginationUser extends Pagination {

    @Schema(description = "用户ID", example = "1")
    private String organizeId;

    @Schema(description = "组织Id集合")
    private List<String> organizeIds;

    @Schema(description = "组织标识")
    private String organizeFlag;

    /** 地址 */
    @Schema(description = "地址")
    private List<String> address;

    /**
     * 已授权用户
     */
    @Schema(description = "已授权用户")
    private String alreadyAuthorize;

    /**
     * 已授权用户类型(销售: Area,实施：ExecuteArea,售后，工程 AfterArea)
     */
    @Schema(description = "已授权用户类型")
    private String alreadyAuthorizeType = "Area";

    @Schema(description = "角色ID", example = "1")
    private String roleId;

    @Schema(description = "菜单ID", example = "1")
    private String menuId;
    @Schema(description = "审核状态", example = "1")
    private String audit;

    @Schema(description = "关键字", example = "1")
    private String keyword;

    /**
     *  部门
     */
    @Schema(description = "部门集合")
    private List<String> departmentList;

}
