package com.bringspring.system.permission.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.system.permission.entity.BasePositionRelationEntity;
import com.bringspring.system.permission.mapper.BasePositionRelationMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationPagination;
import com.bringspring.system.permission.model.basepositionrelation.BasePositionRelationUpForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartSelectorListVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.BasePositionRelationService;
import com.github.pagehelper.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 岗位关系
 * <p>
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-04-16
 */
@Service
public class BasePositionRelationServiceImpl extends ServiceImpl<BasePositionRelationMapper,
        BasePositionRelationEntity> implements BasePositionRelationService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;


    @Override
    public List<BasePositionRelationEntity> getList(BasePositionRelationPagination basePositionRelationPagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int basePositionRelationNum = 0;
        QueryWrapper<BasePositionRelationEntity> basePositionRelationQueryWrapper = new QueryWrapper<>();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader("jsbos-origin").equals("pc");
        if (isPc && pcPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object basePositionRelationObj =
                        authorizeService.getCondition(new AuthorizeConditionModel(basePositionRelationQueryWrapper,
                                basePositionRelationPagination.getMenuId(), "basePositionRelation"));
                if (ObjectUtil.isEmpty(basePositionRelationObj)) {
                    return new ArrayList<>();
                } else {
                    basePositionRelationQueryWrapper =
                            (QueryWrapper<BasePositionRelationEntity>) basePositionRelationObj;
                    basePositionRelationNum++;
                }
            }
        }
        if (!isPc && appPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object basePositionRelationObj =
                        authorizeService.getCondition(new AuthorizeConditionModel(basePositionRelationQueryWrapper,
                                basePositionRelationPagination.getMenuId(), "basePositionRelation"));
                if (ObjectUtil.isEmpty(basePositionRelationObj)) {
                    return new ArrayList<>();
                } else {
                    basePositionRelationQueryWrapper =
                            (QueryWrapper<BasePositionRelationEntity>) basePositionRelationObj;
                    basePositionRelationNum++;
                }


            }
        }
        if (ObjectUtil.isNotEmpty(basePositionRelationPagination.getSelectorDepart())) {
            List<OrganizeDepartSelectorListVO> returnList = new ArrayList<>();
            treeToList(basePositionRelationPagination.getSelectorDepart(), returnList);
            List<String> positionIdList =
                    returnList.stream().filter(v -> "position".equals(v.getType())).map(v -> v.getId()).distinct().collect(Collectors.toList());
            if (!ObjectUtil.isEmpty(positionIdList)) {
                basePositionRelationQueryWrapper.lambda().in(BasePositionRelationEntity::getPositionId, positionIdList);
            }
        }


        if (StringUtil.isNotEmpty(basePositionRelationPagination.getObjectType())) {
            basePositionRelationNum++;
            basePositionRelationQueryWrapper.lambda().like(BasePositionRelationEntity::getObjectType,
                    basePositionRelationPagination.getObjectType());
        }

        if (StringUtil.isNotEmpty(basePositionRelationPagination.getObjectId())) {
            basePositionRelationNum++;
            basePositionRelationQueryWrapper.lambda().like(BasePositionRelationEntity::getObjectId,
                    basePositionRelationPagination.getObjectId());
        }
        basePositionRelationQueryWrapper.orderByAsc("positionId");
        if (AllIdList.size() > 0) {
            basePositionRelationQueryWrapper.lambda().in(BasePositionRelationEntity::getId, AllIdList);
        }
        //排序
        if (StringUtil.isEmpty(basePositionRelationPagination.getSidx())) {
            basePositionRelationQueryWrapper.lambda().orderByDesc(BasePositionRelationEntity::getId);
        } else {
            try {
                String sidx = basePositionRelationPagination.getSidx();
                BasePositionRelationEntity basePositionRelationEntity = new BasePositionRelationEntity();
                Field declaredField = basePositionRelationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basePositionRelationQueryWrapper =
                        "asc".equals(basePositionRelationPagination.getSort().toLowerCase()) ?
                                basePositionRelationQueryWrapper.orderByAsc(value) :
                                basePositionRelationQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<BasePositionRelationEntity> page = new Page<>(basePositionRelationPagination.getCurrentPage(),
                    basePositionRelationPagination.getPageSize());
            IPage<BasePositionRelationEntity> userIPage = this.page(page, basePositionRelationQueryWrapper);
            return basePositionRelationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<BasePositionRelationEntity> list = new ArrayList();
            return basePositionRelationPagination.setData(list, list.size());
        }
    }

    @Override
    public List<BasePositionRelationEntity> getTypeList(BasePositionRelationPagination basePositionRelationPagination
            , String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int basePositionRelationNum = 0;
        QueryWrapper<BasePositionRelationEntity> basePositionRelationQueryWrapper = new QueryWrapper<>();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader("jsbos-origin").equals("pc");
        if (isPc && pcPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object basePositionRelationObj =
                        authorizeService.getCondition(new AuthorizeConditionModel(basePositionRelationQueryWrapper,
                                basePositionRelationPagination.getMenuId(), "basePositionRelation"));
                if (ObjectUtil.isEmpty(basePositionRelationObj)) {
                    return new ArrayList<>();
                } else {
                    basePositionRelationQueryWrapper =
                            (QueryWrapper<BasePositionRelationEntity>) basePositionRelationObj;
                    basePositionRelationNum++;
                }
            }
        }
        if (!isPc && appPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object basePositionRelationObj =
                        authorizeService.getCondition(new AuthorizeConditionModel(basePositionRelationQueryWrapper,
                                basePositionRelationPagination.getMenuId(), "basePositionRelation"));
                if (ObjectUtil.isEmpty(basePositionRelationObj)) {
                    return new ArrayList<>();
                } else {
                    basePositionRelationQueryWrapper =
                            (QueryWrapper<BasePositionRelationEntity>) basePositionRelationObj;
                    basePositionRelationNum++;
                }


            }
        }
        if (StringUtil.isNotEmpty(basePositionRelationPagination.getPositionId())) {
            basePositionRelationNum++;
            basePositionRelationQueryWrapper.lambda().like(BasePositionRelationEntity::getPositionId,
                    basePositionRelationPagination.getPositionId());
        }

        if (StringUtil.isNotEmpty(basePositionRelationPagination.getObjectType())) {
            basePositionRelationNum++;
            basePositionRelationQueryWrapper.lambda().like(BasePositionRelationEntity::getObjectType,
                    basePositionRelationPagination.getObjectType());
        }

        if (StringUtil.isNotEmpty(basePositionRelationPagination.getObjectId())) {
            basePositionRelationNum++;
            basePositionRelationQueryWrapper.lambda().like(BasePositionRelationEntity::getObjectId,
                    basePositionRelationPagination.getObjectId());
        }

        if (AllIdList.size() > 0) {
            basePositionRelationQueryWrapper.lambda().in(BasePositionRelationEntity::getId, AllIdList);
        }
        //排序
        if (StringUtil.isEmpty(basePositionRelationPagination.getSidx())) {
            basePositionRelationQueryWrapper.lambda().orderByDesc(BasePositionRelationEntity::getId);
        } else {
            try {
                String sidx = basePositionRelationPagination.getSidx();
                BasePositionRelationEntity basePositionRelationEntity = new BasePositionRelationEntity();
                Field declaredField = basePositionRelationEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                basePositionRelationQueryWrapper =
                        "asc".equals(basePositionRelationPagination.getSort().toLowerCase()) ?
                                basePositionRelationQueryWrapper.orderByAsc(value) :
                                basePositionRelationQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<BasePositionRelationEntity> page = new Page<>(basePositionRelationPagination.getCurrentPage(),
                        basePositionRelationPagination.getPageSize());
                IPage<BasePositionRelationEntity> userIPage = this.page(page, basePositionRelationQueryWrapper);
                return basePositionRelationPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<BasePositionRelationEntity> list = new ArrayList();
                return basePositionRelationPagination.setData(list, list.size());
            }
        } else {
            return this.list(basePositionRelationQueryWrapper);
        }
    }

    @Override
    public BasePositionRelationEntity getInfo(String id) {
        QueryWrapper<BasePositionRelationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(BasePositionRelationEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public List<BasePositionRelationEntity> infoByPosition(String id) {
        QueryWrapper<BasePositionRelationEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(BasePositionRelationEntity::getPositionId, id);
        return this.list(queryWrapper);
    }

    @Override
    public void create(BasePositionRelationEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, BasePositionRelationEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public void delete(BasePositionRelationEntity entity) {
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

    @Override
    public void deleteByPosition(BasePositionRelationUpForm basePositionRelationUpForm) {
        if (basePositionRelationUpForm != null) {
            QueryWrapper<BasePositionRelationEntity> remove = new QueryWrapper<>();
            // 查询组织关系表集合
            remove.lambda().eq(BasePositionRelationEntity::getObjectType, basePositionRelationUpForm.getObjectType()).eq(BasePositionRelationEntity::getPositionId, basePositionRelationUpForm.getPositionId());
            this.remove(remove);
        }
    }

    @Override
    public List<BasePositionRelationEntity> getListByTypeAndPosId(String objectType, String orgId) {
        QueryWrapper<BasePositionRelationEntity> query = new QueryWrapper<>();
        // 查询组织关系表集合
        query.lambda().eq(BasePositionRelationEntity::getObjectType, objectType).eq(BasePositionRelationEntity::getPositionId, orgId);
        query.lambda().orderByDesc(BasePositionRelationEntity::getCreatorTime);
        return this.list(query);
    }

    @Override
    public List<BasePositionRelationEntity> getListByTypeAndPosId(String objectType, List<String> orgId) {
        QueryWrapper<BasePositionRelationEntity> query = new QueryWrapper<>();
        // 查询组织关系表集合
        query.lambda().eq(BasePositionRelationEntity::getObjectType, objectType).in(BasePositionRelationEntity::getPositionId, orgId);
        query.lambda().orderByDesc(BasePositionRelationEntity::getCreatorTime);
        return this.list(query);
    }

    public void treeToList(OrganizeDepartSelectorListVO selectorOrg, List<OrganizeDepartSelectorListVO> returnList) {
        returnList.add(selectorOrg);
        if (!ObjectUtil.isEmpty(selectorOrg.getChildren())) {
            selectorOrg.getChildren().stream().forEach(v -> {
                treeToList(v, returnList);
            });
        } else {
            return;
        }
    }
}