package com.bringspring.system.permission.service.strategy;

import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.enums.AuthorizeConditionEnum;
import com.bringspring.common.util.enums.SearchMethodEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;

/**
 * This class is used to search for the current user's id in the database.
 */
@Component
public class ContentStringOrganizeId extends FieldContentTextStrategy {

    @Autowired
    private UserProvider userProvider;

    public ContentStringOrganizeId() {
        super();
        this.order = 30;
        this.conditionOptions = new ArrayList<>();
        conditionOptions.add(new HashMap<String, Object>() {{
            put("value", AuthorizeConditionEnum.ORGANIZE.getCondition());
            put("label", AuthorizeConditionEnum.ORGANIZE.getMessage());
        }});
        this.symbolOptions = SearchMethodEnum.getSymbolOptionsBase();
    }

    @Override
    public Object convertFieldContent(String fieldContent, String symbol) {
        String orgId = userProvider.get().getOrganizeId();
        if (StringUtils.isNotEmpty(userProvider.get().getDepartmentId())) {
            orgId = userProvider.get().getDepartmentId();
        }
        return orgId;
    }
}
