package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 邮件接收
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月26日 上午9:18
 */
@Data
@TableName("ext_email_receive")
public class EmailReceiveEntity {
    /**
     * 邮件接收主键
     */
    @TableId("ID")
    private String id;

    /**
     * 类型
     */
    @TableField("TYPE")
    private Integer type;

    /**
     * 邮箱账户
     */
    @TableField(value = "EMAIL_ACCOUNT", fill = FieldFill.INSERT)
    private String mAccount;

    /**
     * F_MID
     */
    @TableField("EMAIL_ID")
    private String mId;

    /**
     * 发件人
     */
    @TableField("SENDER")
    private String sender;

    /**
     * 发件人名称
     */
    @TableField("SENDER_NAME")
    private String senderName;

    /**
     * 主题
     */
    @TableField("SUBJECT")
    private String subject;

    /**
     * 正文
     */
    @TableField("BODY_TEXT")
    private String bodyText;

    /**
     * 附件
     */
    @TableField("ATTACHMENT")
    private String attachment;

    /**
     * 阅读
     */
    @TableField("IS_READ")
    private Integer isRead;

    /**
     * F_Date
     */
    @TableField("DATE")
    private Date fdate;

    /**
     * 星标
     */
    @TableField("STARRED")
    private Integer starred;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 排序码
     */
    @TableField("SORT_CODE")
    private Long sortCode;

    /**
     * 有效标志
     */
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;

    /**
     * 删除标志
     */
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /**
     * 删除时间
     */
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /**
     * 删除用户
     */
    @TableField("DELETE_USER_ID")
    private String deleteUserId;
}
