package com.bringspring.system.base.model.dblink;

import com.bringspring.common.database.model.entity.DbLinkEntity;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Map;

/**
 * 页面显示对象
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class DbLinkInfoVO extends DbLinkBaseForm {

    /**
     * 获取连接页面显示对象
     * @param entity 连接实体对象
     * @return 返回显示对象
     * @throws DataException ignore
     */
    public DbLinkInfoVO getDbLinkInfoVO(DbLinkEntity entity) throws DataException {
        DbLinkInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, DbLinkInfoVO.class);
//        vo.setPassword(DesUtil.aesOrDecode(vo.getPassword(), true, true));
        vo.setDbName(XSSEscape.escape(entity.getDbName()));
        vo.setTableSpace(XSSEscape.escape(entity.getDbTableSpace()));
        vo.setOracleExtend(entity.getOracleExtend() != null && entity.getOracleExtend() == 1);
        if(StringUtils.isNotEmpty(entity.getOracleParam())){
            Map<String, Object> oracleParam = JsonUtil.stringToMap(entity.getOracleParam());
            if(oracleParam.size() > 0){
                vo.setOracleLinkType(oracleParam.get(DbOracle.ORACLE_LINK_TYPE) != null ? oracleParam.get(DbOracle.ORACLE_LINK_TYPE).toString() : null);
                vo.setOracleRole(oracleParam.get(DbOracle.ORACLE_ROLE) != null ? oracleParam.get(DbOracle.ORACLE_ROLE).toString() : null);
                vo.setOracleService(oracleParam.get(DbOracle.ORACLE_SERVICE) != null ? oracleParam.get(DbOracle.ORACLE_SERVICE).toString() : null);
                vo.setOracleExtend(true);
            }
        }
        return vo;
    }

    @Schema(description = "主键")
    private String id;

}
