package com.bringspring.system.base.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.common.base.Pagination;
import com.bringspring.system.base.entity.DbBackupEntity;

import java.util.List;

/**
 * 数据备份
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
public interface DbBackupService extends IService<DbBackupEntity> {

    /**
     * 列表
     *
     * @param pagination 条件
     * @return ignore
     */
    List<DbBackupEntity> getList(Pagination pagination);

    /**
     * 信息
     *
     * @param id 主键值
     * @return ignore
     */
    DbBackupEntity getInfo(String id);

    /**
     * 删除
     *
     * @param entity 实体对象
     */
    void delete(DbBackupEntity entity);

    /**
     * 创建
     *
     * @param entity 实体对象
     */
    void create(DbBackupEntity entity);

}
