package com.bringspring.system.base.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.mapper.MessageTemplateMapper;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.message.model.message.SentMessageForm;
import com.bringspring.system.message.util.SentMessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URLDecoder;
import java.util.*;

/**
 * 消息模板
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021年12月8日17:40:37
 */
@Service
public class MessageTemplateServiceImpl extends ServiceImpl<MessageTemplateMapper, MessageTemplateEntity> implements MessageTemplateService {

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private SentMessageUtil sentMessageUtil;


    @Autowired
    private SysConfigService sysConfigService;

    @Override
    public List<MessageTemplateEntity> getSelector(Pagination pagination) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(pagination.getKeyword())) {
            try {
                String decode = URLDecoder.decode(pagination.getKeyword(), "UTF-8");
                queryWrapper.lambda().and(t -> t.like(MessageTemplateEntity::getFullName, decode).or().like(MessageTemplateEntity::getTitle, pagination.getKeyword()).or().like(MessageTemplateEntity::getEnCode, pagination.getKeyword()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnabledMark, 1);
        queryWrapper.lambda().orderByDesc(MessageTemplateEntity::getCreatorTime);
        Page<MessageTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<MessageTemplateEntity> userPage = this.page(page, queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<MessageTemplateEntity> getList(Pagination pagination) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper<>();
        if (!StringUtils.isEmpty(pagination.getKeyword())) {
            try {
                String decode = URLDecoder.decode(pagination.getKeyword(), "UTF-8");
                queryWrapper.lambda().and(t -> t.like(MessageTemplateEntity::getFullName, decode).or().like(MessageTemplateEntity::getTitle, pagination.getKeyword()).or().like(MessageTemplateEntity::getEnCode, pagination.getKeyword()));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        queryWrapper.lambda().orderByDesc(MessageTemplateEntity::getCreatorTime);
        Page<MessageTemplateEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
        IPage<MessageTemplateEntity> userPage = this.page(page, queryWrapper);
        return pagination.setData(userPage.getRecords(), page.getTotal());
    }


    @Override
    public MessageTemplateEntity getInfo(String id) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(MessageTemplateEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(MessageTemplateEntity entity) {
        entity.setId(RandomUtil.uuId());
        entity.setCreatorUserId(userProvider.get().getUserId());
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, MessageTemplateEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(new Date());
        entity.setLastModifyUserId(userProvider.get().getUserId());
        return this.updateById(entity);
    }

    @Override
    public void delete(MessageTemplateEntity entity) {
        this.removeById(entity.getId());
    }

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(MessageTemplateEntity::getFullName, fullName);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(MessageTemplateEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, enCode);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(MessageTemplateEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public void testSendMessage(SentMessageForm messageTemplateCrForm) throws Exception {

//        SentMessageForm sentMessageForm = new SentMessageForm();
//        sentMessageForm.setToUserIds(userId);
//        sentMessageForm.setType(3);
//        sentMessageForm.setTemplateId(messageTemplateCrForm.getTemplateId());
//        sentMessageForm.setTitle(messageTemplateCrForm.getTitle());
//        sentMessageForm.setContent(messageTemplateCrForm.getContent());
//        sentMessageForm.setBodyText(new HashMap<>());
        List<String> userId = new ArrayList<>();
//        JSONObject.parseObject(messageTemplateCrForm.getTemplateJson());
        UserInfo userInfo = userProvider.get();
        userId.add(userInfo.getUserId());
        messageTemplateCrForm.setToUserIds(userId);
        messageTemplateCrForm.setType(3);
        messageTemplateCrForm.setBodyText(new HashMap<>());
        Map<String, String> parameterMap = new HashMap<>();
        Map map = JSONObject.parseObject(messageTemplateCrForm.getTemplateJson());
        parameterMap.putAll(map);
        //移动端跳转路径
        parameterMap.put("AppUrl", sysConfigService.getConfigByKeyName("qyhMobileUrl").getKeyValue());
        messageTemplateCrForm.setParameterMap(parameterMap);
        sentMessageUtil.sendMessage(messageTemplateCrForm);
    }


    @Override
    public MessageTemplateEntity getMessageTemplateByEncode(String encode) {
        QueryWrapper<MessageTemplateEntity> queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, encode);
        return this.getOne(queryWrapper);
    }
}




