package com.bringspring.system.external.config.single;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.base.systemconfig.QyChatModel;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import com.google.common.collect.Maps;
import lombok.val;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.api.impl.WxCpServiceImpl;
import me.chanjar.weixin.cp.config.impl.WxCpDefaultConfigImpl;
import me.chanjar.weixin.cp.message.WxCpMessageRouter;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 单实例配置
 *
 * @author <a href="https://github.com/binarywang">Binary Wang</a>
 */
//@Component
public class WxCpConfiguration {
    private Map<Integer, WxCpMessageRouter> routers = Maps.newHashMap();
    private Map<Integer, WxCpService> cpServices = Maps.newHashMap();

    @Autowired
    private SysConfigService sysConfigService;

    @Autowired
    public WxCpConfiguration() {
    }

    public Map<Integer, WxCpMessageRouter> getRouters() {
        return routers;
    }

    public WxCpService getCpService(Integer agentId) {
        WxCpService wxCpService = cpServices.get(agentId);
        if (ObjectUtil.isEmpty(wxCpService)) {
            initServices();
            wxCpService = cpServices.get(agentId);
        }
        return wxCpService;
    }

    public void initServices() {
        try {
            QyChatModel qyChatInfo = sysConfigService.getQyChatInfo();
            if (ObjectUtil.isNotEmpty(qyChatInfo)) {
                List<QyChatModel> listModel = new ArrayList<>();
                listModel.add(qyChatInfo);
                cpServices = listModel.stream().map(a -> {
                    Integer agentId = Integer.valueOf(a.getQyhAgentId());
                    val configStorage = new WxCpDefaultConfigImpl();
                    configStorage.setCorpId(a.getQyhCorpId());
                    configStorage.setAgentId(agentId);
                    configStorage.setCorpSecret(a.getQyhAgentSecret());
                    configStorage.setToken(a.getToken());
                    configStorage.setAesKey(a.getEncodingAESKey());

                    val service = new WxCpServiceImpl();
                    service.setWxCpConfigStorage(configStorage);
                    routers.put(agentId, this.newRouter(service));

                    return service;
                }).collect(Collectors.toMap(service -> service.getWxCpConfigStorage().getAgentId(), a -> a));
            }
        } catch (BaseException e) {
            e.printStackTrace();
        }

    }

    private WxCpMessageRouter newRouter(WxCpService wxCpService) {
        final val newRouter = new WxCpMessageRouter(wxCpService);

        return newRouter;
    }

}
