package com.bringspring.system.external.controller;

import cn.hutool.core.map.MapUtil;
import com.bringspring.common.annotation.NotCheckLogin;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.system.external.config.mutil.WxMpConfiguration;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;

import static com.bringspring.common.constant.CacheConsts.ONE_WEEK_CACHE;

@Slf4j
@Tag(name = "微信公众号")
@RestController
@RequestMapping("wxMp")
public class WxMpController {

    @Autowired
    private WxMpConfiguration wxMpConfiguration;
    @Autowired
    private CacheUtil cacheUtil;

    @NotCheckLogin
    @GetMapping("loginByCode")
    public ActionResult loginByCode(String code) {
        WxMpService wxMpService = wxMpConfiguration.getWxMpService("wx08d904a944bfaa20");
        WxOAuth2AccessToken wxOAuth2AccessToken = null;
        try {
            wxOAuth2AccessToken = wxMpService.getOAuth2Service().getAccessToken(code);
        } catch (WxErrorException e) {
            e.printStackTrace();
            return ActionResult.fail(e.getMessage());
        }
        WxOAuth2UserInfo wxMpUser = null;
        try {
            wxMpUser = wxMpService.getOAuth2Service().getUserInfo(wxOAuth2AccessToken, null);
        } catch (WxErrorException e) {
            e.printStackTrace();
            return ActionResult.fail(e.getMessage());
        }
        String openid = wxMpUser.getOpenid();
        cacheUtil.insert(ONE_WEEK_CACHE, openid, wxMpUser, RedisUtil.CAHCEWEEK);
        HashMap<Object, Object> map = MapUtil.newHashMap();
        map.put("openid", openid);
        return ActionResult.success(map);
    }

}
