package com.bringspring.system.external.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.emoji.EmojiUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.service.WxCpLinkedCorpService;
import com.bringspring.system.external.util.ValidateCommonUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdConsts;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import lombok.extern.slf4j.Slf4j;
import me.chanjar.weixin.cp.api.WxCpService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.*;

import static com.bringspring.system.external.constant.WxCpSysConfigConsts.TARGET_CHAR;

@Slf4j
@Component
public class WxCpLinkedCorpServiceImpl implements WxCpLinkedCorpService {

    @Autowired
    private ValidateCommonUtil validateCommonUtil;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;

    @Override
    public UserEntity registerSysAccount(MyWxCpLinkedCorpUser qyuser, WxCpService wxCpService) {
        UserEntity userEntity = null; // 系统用户
        if (ObjectUtil.isNotEmpty(qyuser)) {
            String corpId = wxCpService.getWxCpConfigStorage().getCorpId();
            String userCorpId = qyuser.getCorpId();
            String userId = qyuser.getUserId();
            String thirdObjid = userCorpId + TARGET_CHAR + userId;
            String mobile = qyuser.getMobile();
            String email = qyuser.getEmail();
            // 初始化系统数据
            validateCommonUtil.initData();
            userEntity = userService.getUserEntity(userId, mobile, email);
            if (ObjectUtil.isEmpty(userEntity)) {
                // 系统用户不存在,新增注册账户
                List<PositionEntity> positionBatch = new ArrayList<>();
                Map<String, PositionEntity> savePositionMap = new HashMap<>();

                userEntity = new UserEntity();
                userEntity.setId(RandomUtil.uuId());
                userEntity.setAccount(userId);

                SynThirdInfoEntity synThirdInfoEntity =
                        validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);

                synThirdInfoEntity.setCropId(corpId);
                synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                // 设置同步状态值
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setDescription("互联企业用户，扫码或自动登录绑定注册账户。");

                // 姓名
                if (StringUtils.isNotEmpty(qyuser.getName())) {
                    // 去掉除汉字以外的字符
                    String name = StringUtils.stringFilter(EmojiUtil.removeAllEmojis(qyuser.getName()));
                    userEntity.setRealName(name);
                }
                // 手机
                if (StringUtils.isNotEmpty(mobile)) {
                    userEntity.setMobilePhone(mobile);
                }
                // 电话
                if (StringUtils.isNotEmpty(qyuser.getTelephone())) {
                    userEntity.setTelePhone(qyuser.getTelephone());
                }
                // 邮箱
                if (StringUtils.isNotEmpty(email)) {
                    userEntity.setEmail(email);
                }

                // 部门和岗位设置
                validateCommonUtil.setDeptAndPosition(qyuser, userEntity);
                // 工号
                userEntity.setCode(validateCommonUtil.getCode(qyuser));

                // 角色默认
                userEntity.setRoleId(validateCommonUtil.getDefaultRoleId());
                // 头像默认  微信企业没传
                userEntity.setHeadIcon("/api/file/Image/userAvatar/001.png");
                // 性别默认 （1:男；3:女；3:保密）
                userEntity.setGender(3);
                // 有效标志默认
                userEntity.setEnabledMark(1);
                // 秘钥默认
                userEntity.setSecretkey(RandomUtil.uuId());
                // 是否管理员默认 0:否；1:是
                userEntity.setIsAdministrator(0);
                // 账户密码默认
                userEntity.setPassword(userService.getDefaultPassword(userEntity.getSecretkey()));

                // 岗位名称转换positionId
                validateCommonUtil.convertPosition(savePositionMap, userEntity);

                // 检查该 HashMap 是否含有元素
                if (!savePositionMap.isEmpty()) {
                    Iterator<String> iterator = savePositionMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        String key = iterator.next();
                        positionBatch.add(savePositionMap.get(key));
                    }
                }

                // 将新增用户信息持久化
                // UserRelationEntity组织 岗位 角色
                userService.saveOrUpdateCommon(userEntity.getId(), userEntity);
                // PositionEntity岗位管理
                positionService.saveOrUpdateBatch(positionBatch);
                // UserEntity员工管理
                userService.save(userEntity);
                // SynThirdInfoEntity第三方同步记录
                synThirdInfoService.save(synThirdInfoEntity);
            } else {
                SynThirdInfoEntity synThirdInfoEntity =
                        validateCommonUtil.newSynThirdInfoForWxUser(thirdObjid);
                synThirdInfoEntity.setCropId(corpId);
                synThirdInfoEntity.setSystemObjectId(userEntity.getId());
                // 设置同步状态值
                synThirdInfoEntity.setSynState(SynThirdConsts.SYN_STATE_OK);
                synThirdInfoEntity.setDescription("互联企业用户，扫码或自动登录绑定已有账户。");
                // SynThirdInfoEntity第三方同步记录
                synThirdInfoService.save(synThirdInfoEntity);
            }
        }
        return userEntity;
    }

}
