package com.bringspring.system.message.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 第三方工具的公司-部门-用户同步表模型
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:06
 */
@Data
@TableName("base_sync_third_info")
public class SynThirdInfoEntity implements Serializable {

    /**
     * 主键
     */
    @TableId("ID")
    private String id;

    @TableField("CROP_ID")
    private String cropId;


    /**
     * 第三方类型(1:企业微信;2:钉钉)
     */
    @TableField("THIRD_TYPE")
    private Integer thirdType;

    /**
     * 数据类型(1:组织(公司与部门);2:用户)
     */
    @TableField("DATA_TYPE")
    private Integer dataType;

    /**
     * 本地对象ID(公司ID、部门ID、用户ID)
     */
    @TableField("SYSTEM_OBJECT_ID")
    private String systemObjectId;

    /**
     * 第三方对象ID(公司ID、部门ID、用户ID)
     */
    @TableField("THIRD_OBJECT_ID")
    private String thirdObjectId;

    /**
     * 同步状态(0:未同步;1:同步成功;2:同步失败)
     */
    @TableField("SYN_STATE")
    private Integer synState;

    /**
     * 描述
     */
    @TableField("DESCRIPTION")
    private String description;

    /**
     * 创建时间
     */
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    /**
     * 创建用户
     */
    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

    /**
     * 修改用户
     */
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.INSERT_UPDATE)
    private String lastModifyUserId;

    /**
     * 修改时间
     */
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.INSERT_UPDATE)
    @JSONField(name = "LastModifyTime")
    private Date lastModifyTime;

}
