package com.bringspring.system.message.service.impl;


import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.message.entity.MessageReceiveEntity;
import com.bringspring.system.message.mapper.MessagereceiveMapper;
import com.bringspring.system.message.service.MessagereceiveService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 消息接收 服务实现类
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class MessagereceiveServiceImpl extends ServiceImpl<MessagereceiveMapper, MessageReceiveEntity> implements MessagereceiveService {

    @Autowired
    private UserProvider userProvider;

    @Override
    public MessageReceiveEntity getOneByMessageId(String messageId) {
        UserInfo userInfo = userProvider.get();

        QueryWrapper<MessageReceiveEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.lambda().eq(MessageReceiveEntity::getMessageId, messageId).eq(MessageReceiveEntity::getUserId, userInfo.getUserId());
        MessageReceiveEntity one = this.getOne(queryWrapper);
        return one;
    }
}
