package com.bringspring.system.msgcenter.mapper;


import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 业务场景消息接收记录表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-14
 */
public interface McTaskMsgReceiveMapper extends BaseMapper<McTaskMsgReceiveEntity> {

    /**
     * 按状态分类统计
     *
     * @return
     */
    List<Map<String, Object>> selectGroupByEnabledMark(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 按渠道分类统计
     *
     * @return
     */
    List<Map<String, Object>> selectGroupByChannelType(@Param(Constants.WRAPPER) Wrapper ew);

    /**
     * 按发送时间分类统计
     *
     * @return
     */
    List<Map<String, Object>> selectGroupBySendTime(@Param(Constants.WRAPPER) Wrapper ew);
}
