package com.bringspring.system.msgcenter.service.chain;

import cn.hutool.core.collection.CollectionUtil;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.EnabledMarkEnum;
import com.bringspring.system.msgcenter.enums.MsgCenterCode;
import com.bringspring.system.msgcenter.service.context.FilterResult;
import com.bringspring.system.msgcenter.service.context.SendMessageContext;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 黑名单过滤器
 * 此处节点针对消息中心：配置的黑名单，分离不发送消息(即接收人是否在黑名单中)的接收人记录。
 * 注意：此处的黑名单是指系统用户级的黑名单，所以使用的sysUserId字段。
 */
@Component
public class BlacklistFilter implements FilterProcessor {
    @Override
    public FilterResult process(SendMessageContext context) {
        /**
         * 先分离黑名单和非黑名单。
         * 注意：责任链头节点context.getReceiveList()中包含所有接收人记录
         */
        Map<Boolean, List<McTaskMsgReceiveEntity>> partitioned =
                BlacklistUtil.receiveListPartitioned(context.getReceiveList());

        List<McTaskMsgReceiveEntity> invalidList = partitioned.get(true);
        if (CollectionUtil.isNotEmpty(invalidList)) {
            // 分离有效和无效记录，并标注原因
            invalidList.stream().forEach(e -> {
                e.setEnabledMark(EnabledMarkEnum.FAIL.getCode());
                e.setDescription(MsgCenterCode.BLACKLIST_USER.getDesc() + ":" + e.getSysUserId());
            });
        }

        // 过滤黑名单
        return new FilterResult(partitioned.get(false), invalidList);

    }
}
