package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.util.*;
import com.bringspring.system.msgcenter.constant.Constants.Uniqueness;
import com.bringspring.system.msgcenter.entity.McBusinessEntity;
import com.bringspring.system.msgcenter.entity.McBusinessKeywordEntity;
import com.bringspring.system.msgcenter.mapper.McBusinessMapper;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessCrForm;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessInfoVO;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessPagination;
import com.bringspring.system.msgcenter.model.mcbusiness.McBusinessUpForm;
import com.bringspring.system.msgcenter.model.mcbusinesskeyword.McBusinessKeywordModel;
import com.bringspring.system.msgcenter.service.McBusinessKeywordService;
import com.bringspring.system.msgcenter.service.McBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 消息业务场景信息
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-06
 */
@Service
public class McBusinessServiceImpl extends ServiceImpl<McBusinessMapper, McBusinessEntity> implements McBusinessService {

    @Autowired
    private UserProvider userProvider;

    @Autowired
    private McBusinessKeywordService mcBusinessKeywordService;


    @Override
    public List<McBusinessEntity> getList(McBusinessPagination pagination) {
        List<String> AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<McBusinessEntity> queryWrapper = new QueryWrapper<>();

        // 分类
        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCategory, pagination.getCategory());
        }

        // 关键字查询
        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
            queryWrapper.lambda().like(McBusinessEntity::getFullName, pagination.getKeyword())
                    .or().like(McBusinessEntity::getEnCode, pagination.getKeyword());
        }

        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            queryWrapper.lambda().like(McBusinessEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            queryWrapper.lambda().like(McBusinessEntity::getEnCode, pagination.getEnCode());
        }

        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> CreatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));

            queryWrapper.lambda().ge(McBusinessEntity::getCreatorTime, new Date(fir))
                    .le(McBusinessEntity::getCreatorTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " 23:59" +
                            ":59"));

        }

        if (StringUtils.isNotEmpty(pagination.getDeleteMark())) {
            queryWrapper.lambda().eq(McBusinessEntity::getDeleteMark, pagination.getDeleteMark());
        }

        if (StringUtils.isNotEmpty(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCompanyId, JsonUtil.getObjectToString(pagination.getCompanyId()));
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McBusinessEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McBusinessEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McBusinessEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McBusinessEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<McBusinessEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McBusinessEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }

    @Override
    public List<McBusinessEntity> getTypeList(McBusinessPagination pagination, String dataType) {
        List<String> AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper<McBusinessEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getCategory())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCategory, pagination.getCategory());
        }

        if (StringUtils.isNotEmpty(pagination.getFullName())) {
            queryWrapper.lambda().like(McBusinessEntity::getFullName, pagination.getFullName());
        }

        if (StringUtils.isNotEmpty(pagination.getEnCode())) {
            queryWrapper.lambda().like(McBusinessEntity::getEnCode, pagination.getEnCode());
        }

        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> CreatorTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(CreatorTimeList.get(0));
            Long sec = Long.valueOf(CreatorTimeList.get(1));

            queryWrapper.lambda().ge(McBusinessEntity::getCreatorTime, new Date(fir))
                    .le(McBusinessEntity::getCreatorTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " 23:59" +
                            ":59"));

        }

        if (StringUtils.isNotEmpty(pagination.getDeleteMark())) {
            queryWrapper.lambda().eq(McBusinessEntity::getDeleteMark, pagination.getDeleteMark());
        }

        if (StringUtils.isNotEmpty(pagination.getCompanyId())) {
            queryWrapper.lambda().eq(McBusinessEntity::getCompanyId, JsonUtil.getObjectToString(pagination.getCompanyId()));
        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McBusinessEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McBusinessEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                Field declaredField = McBusinessEntity.class.getDeclaredField(sidx);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McBusinessEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<McBusinessEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McBusinessEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public McBusinessEntity getInfo(String id) {
        QueryWrapper<McBusinessEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McBusinessEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public McBusinessInfoVO getInfoByEnCode(String enCode) {
        QueryWrapper<McBusinessEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McBusinessEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McBusinessEntity one = this.getOne(queryWrapper);
        McBusinessInfoVO infoVO = JsonUtil.getJsonToBean(one, McBusinessInfoVO.class);
        if (ObjectUtil.isNotNull(infoVO)) {
            //子表数据转换
            List<McBusinessKeywordEntity> keywordList = this.getMcBusinessKeywordList(infoVO.getEnCode());
            List<McBusinessKeywordModel> keywordModelList = JsonUtil.getJsonToList(keywordList, McBusinessKeywordModel.class);
            infoVO.setKeywordList(keywordModelList);
        }
        return infoVO;
    }

    @Override
    @DSTransactional
    public void create(McBusinessCrForm mcBusinessCrForm) {
        McBusinessEntity entity = JsonUtil.getJsonToBean(mcBusinessCrForm, McBusinessEntity.class);
        String mainId = RandomUtil.uuId();
        entity.setId(mainId);
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        this.save(entity);

        // 子表数据插入
        List<McBusinessKeywordEntity> keywordList =
                JsonUtil.getJsonToList(mcBusinessCrForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(entity.getEnCode());
            mcBusinessKeywordService.save(entitys);
        }
    }

    @Override
    @DSTransactional
    public boolean update(String id, McBusinessUpForm mcBusinessUpForm) {
        McBusinessEntity entity = JsonUtil.getJsonToBean(mcBusinessUpForm, McBusinessEntity.class);
        entity.setId(id);

        // 子表数据删除重新插入
        QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, entity.getEnCode());
        mcBusinessKeywordService.remove(queryWrapper);

        List<McBusinessKeywordEntity> keywordList =
                JsonUtil.getJsonToList(mcBusinessUpForm.getKeywordList(), McBusinessKeywordEntity.class);
        for (McBusinessKeywordEntity entitys : keywordList) {
            entitys.setId(RandomUtil.uuId());
            entitys.setBusinessCode(entity.getEnCode());
            mcBusinessKeywordService.save(entitys);
        }
        entity.setDeleteMark(DeleteMarkEnum.NOT_DELETE.getCode());
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McBusinessEntity entity) {
        if (ObjectUtil.isNotNull(entity)) {
            this.removeById(entity.getId());

            // 子表
            QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, entity.getEnCode());
            mcBusinessKeywordService.remove(queryWrapper);
        }
    }

    //子表方法
    @Override
    public List<McBusinessKeywordEntity> getMcBusinessKeywordList(String enCode) {
        QueryWrapper<McBusinessKeywordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McBusinessKeywordEntity::getBusinessCode, enCode);
        return mcBusinessKeywordService.list(queryWrapper);
    }

    /**
     * queryWrapper.eq(McBusinessEntity::getDeleteMark, DeleteMarkEnum.NOT_DELETE.getCode());
     * @param enCode
     * @param id
     * @return
     */
    @Override
    public boolean checkEnCodeUnique(String enCode, String id) {
        LambdaQueryWrapper<McBusinessEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McBusinessEntity::getEnCode, enCode);
        queryWrapper.last("limit 1");
        McBusinessEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }

    /**
     * queryWrapper.eq(McBusinessEntity::getDeleteMark, DeleteMarkEnum.NOT_DELETE.getCode());
     * @param fullName
     * @param id
     * @return
     */
    @Override
    public boolean checkFullNameUnique(String fullName, String id) {
        LambdaQueryWrapper<McBusinessEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(McBusinessEntity::getFullName, fullName);
        queryWrapper.last("limit 1");
        McBusinessEntity entity = this.getOne(queryWrapper);
        if (ObjectUtil.isNotNull(entity) && (StringUtils.isEmpty(id) || !entity.getId().equals(id))) {
            // 存在code编码,返回false
            return Uniqueness.NOT_UNIQUE;
        }
        return Uniqueness.UNIQUE;
    }
}