package com.bringspring.system.msgcenter.service.strategy.impl;

import com.bringspring.common.util.RandomUtil;
import com.bringspring.system.msgcenter.constant.Constants.ReadStatus;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 站内信策略
 */
@Component
public class SystemStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.SYS_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());

        String sysKey = channelType + msgTemplateId;
        // 消息内容
        McTaskMsgContentEntity sysContent;
        if (!contentMap.containsKey(sysKey)) {
            sysContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(sysKey, sysContent); // 渠道模板应用消息内容
        } else {
            sysContent = contentMap.get(sysKey);
        }

        // 消息接收人
        if (!receiveMap.containsKey(sysKey) && !"4".equals(taskMsg.getToType())) {
            List<McTaskMsgReceiveEntity> sysReceiveList = new ArrayList<>();
            List<UserEntity> receiveUsers = userService.getUserByIds(new ArrayList<>(userSet));
            // 接收人
            receiveUsers.stream().forEach(s -> {
                McTaskMsgReceiveEntity receiveEntity = new McTaskMsgReceiveEntity();
                receiveEntity.setId(RandomUtil.uuId());
                receiveEntity.setMsgId(taskMsgId);
                // 发送配置模板id
                receiveEntity.setTemplateId(templateId);
                receiveEntity.setMsgTemplateId(msgTemplateId);
                receiveEntity.setMsgAccountId(msgAccountId);
                receiveEntity.setContentId(sysContent.getId());
                // 站内信
                receiveEntity.setChannelType(channelType);
                // 下发渠道接收人：base_user主键id
                receiveEntity.setReceiveUserId(s.getId());
                // 冗余字段 接收人系统用户表id
                receiveEntity.setSysUserId(s.getId());
                receiveEntity.setEnabledMark(0); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                receiveEntity.setIsRead(ReadStatus.UNREAD.getCode()); // 是否阅读，0否、1是
                receiveEntity.setDescription(null);
                sysReceiveList.add(receiveEntity);
            });
            receiveMap.put(sysKey, sysReceiveList);
        }
    }

}