package com.bringspring.system.msgcenter.service.strategy.impl;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.msgcenter.entity.*;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.context.TaskMsgReceiveMetadata;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.bringspring.system.message.util.SynThirdConsts.DATA_TYPE_USER;
import static com.bringspring.system.message.util.SynThirdConsts.THIRD_TYPE_QY;

/**
 * 不同渠道的策略类继承抽象基类，复用公共方法，并实现自身逻辑
 * 企业微信消息策略
 */
@Component
public class WxQyWechatStrategy extends AbstractMessageChannelStrategy {
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private UserService userService;

    @Override
    public ChannelTypeEnum getChannelType() {
        return ChannelTypeEnum.QY_MSG;
    }

    @Override
    public void processMessage(McTaskMsgEntity taskMsg,
                               McMsgSendTemplateModel sendTemplate,
                               Map<String, McTaskMsgContentEntity> contentMap,
                               Map<String, List<McTaskMsgReceiveEntity>> receiveMap,
                               Set<String> userSet) {
        String taskMsgId = taskMsg.getId();

        // 具体实现钉钉渠道的逻辑（原switch-case中的代码迁移至此）
        String templateId = sendTemplate.getId(); // 发送配置消息模板
        String channelType = sendTemplate.getMessageType(); // 消息渠道
        String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
        String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

        // 授权应用
        McMsgAccountEntity account = mcMsgAccountService.getInfo(sendTemplate.getAccountConfigId());
        // 消息模板
        McMsgTemplateEntity msgTemplate = mcMsgTemplateService.getInfo(sendTemplate.getTemplateId());


        String qyContentKey = channelType + msgTemplateId + msgAccountId;
        String qyReceiveKey = channelType + msgTemplateId;
        // 消息内容
        McTaskMsgContentEntity qyContent;
        if (!contentMap.containsKey(qyContentKey)) {
            qyContent = this.getTaskMsgContent(templateId, channelType, taskMsg, msgTemplate, account);
            contentMap.put(qyContentKey, qyContent); // 渠道模板应用消息内容
        } else {
            qyContent = contentMap.get(qyContentKey);
        }

        if ("4".equals(taskMsg.getToType())) {
            // 非系统用户，第三方唯一标识直接发送
            receiveMap.computeIfAbsent(qyContentKey, k ->
                    packNonSystemReceive(userSet, taskMsgId, templateId, channelType, msgTemplateId, msgAccountId, qyContent.getId())
            );
        } else {
            List<UserEntity> receiveUsers = userService.getUserByIds(new ArrayList<>(userSet));
            // 是否互联企业配置
            String isLinkedCorp = ObjectUtil.isEmpty(account) ? null : account.getProgramState();
            String qyCrop = ObjectUtil.isEmpty(account) ? null : account.getEnterpriseId();
            // 企业微信 企业微信用户关联base_sync_third_info获取
            List<SynThirdInfoEntity> qyThirdList =
                    synThirdInfoService.getThirdInfoList(THIRD_TYPE_QY, DATA_TYPE_USER, qyCrop, userSet,
                            Boolean.parseBoolean(isLinkedCorp));
            List<McTaskMsgReceiveEntity> receiveList = null;
            if (receiveMap.containsKey(qyReceiveKey)) {
                receiveList = receiveMap.get(qyReceiveKey);
            }
            TaskMsgReceiveMetadata metadata = TaskMsgReceiveMetadata.builder()
                    .taskMsgId(taskMsgId)
                    .templateId(templateId)
                    .channelType(channelType)
                    .msgTemplateId(msgTemplateId)
                    .msgAccountId(msgAccountId)
                    .contentId(qyContent.getId())
                    .build();
            List<McTaskMsgReceiveEntity> qyReceiveList =
                    packThirdReceive(receiveUsers, qyThirdList, metadata, receiveList);
            receiveMap.put(qyReceiveKey, qyReceiveList);
        }
    }
}
