package com.bringspring.system.msgcenter.util;


import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MsgScheduleTaskUtils {
    Logger logger = LoggerFactory.getLogger(MsgScheduleTaskUtils.class);
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;

    /**
     * 自动重发
     * 未成功发送的渠道消息，自动尝试重发
     */
    @JsbosTask(fullName = "定时重发未成功发出渠道消息", description = "未成功发送的渠道消息-自动尝试重发")
    public void autoAgainSendMessageTask() throws Exception {
        logger.info("定时重发渠道消息");
        mcTaskMsgReceiveService.autoAgainSendMessage();
    }
}
