package com.bringspring.system.permission.aop;

import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.system.permission.constant.PermissionConstant;
import com.bringspring.system.permission.model.organize.OrganizeCrForm;
import com.bringspring.system.permission.model.organize.OrganizeDepartCrForm;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.util.PermissionAspectUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 组织分级管理
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/15 17:12
 */
@Slf4j
@Aspect
@Component
public class PermissionOrgAspect implements PermissionAdminBase{

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;

    /**
     * 分级管理切点
     */
    @Pointcut("@annotation(com.bringspring.common.annotation.OrganizePermission)")
    public void pointcut() {
    }

    /**
     * 分级管理切点
     *
     * @param pjp
     * @return
     * @throws Throwable
     */
    @Around("pointcut()")
    public Object around(ProceedingJoinPoint pjp) throws Throwable {
        return PermissionAdminBase.permissionCommon(pjp, userProvider, this);
    }

    @Override
    public Boolean detailPermission(ProceedingJoinPoint pjp, String operatorUserId, String methodName) {
        switch (methodName){
            case PermissionConstant.METHOD_CREATE:
                            return PermissionAspectUtil.getPermitByOrgIds(
                                    // 操作目标对象表单对象
                                    ((OrganizeCrForm)pjp.getArgs()[0]).getParentId(),
                                    operatorUserId,
                                    PermissionConstant.METHOD_CREATE);
            case PermissionConstant.METHOD_CREATE_DEPARTMENT:
                            return PermissionAspectUtil.getPermitByOrgIds(
                                    // 操作目标对象表单对象
                                    ((OrganizeDepartCrForm)pjp.getArgs()[0]).getParentId(),
                                    operatorUserId,
                                    PermissionConstant.METHOD_CREATE);
            case PermissionConstant.METHOD_UPDATE:
            case PermissionConstant.METHOD_UPDATE_DEPARTMENT:
                            return PermissionAspectUtil.getPermitByOrgIds(
                                    // 操作目标对象ID
                                    pjp.getArgs()[0].toString(),
                                    operatorUserId,
                                    PermissionConstant.METHOD_UPDATE);
            case PermissionConstant.METHOD_DELETE:
            case PermissionConstant.METHOD_DELETE_DEPARTMENT:
                            return PermissionAspectUtil.getPermitByOrgIds(
                                    // 操作目标对象ID
                                    pjp.getArgs()[0].toString(),
                                    operatorUserId,
                                    PermissionConstant.METHOD_DELETE);
            default:
                return false;
        }
    }
}
