package com.bringspring.system.permission.model.position;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2021/3/12 15:31
 */
@Data
public class PositionCrForm {
    @NotBlank(message = "必填")
    @Schema(description = "岗位编码")
    private String enCode;
    @NotBlank(message = "必填")
    @Schema(description = "所属部门(id)")
    private String organizeId;
    @NotNull(message = "必填")
    @Schema(description = "岗位状态")
    private Integer enabledMark;
    @NotBlank(message = "必填")
    @Schema(description = "岗位名称")
    private String fullName;

    @Schema(description = "岗位描述")
    private String description;
    @NotNull(message = "必填")
    @Schema(description = "岗位类型(id)")
    private Integer type;
    @Schema(description = "排序")
    private Long sortCode;

    @Schema(description = "角色")
    private List<String> roleIdList;

}
