package com.bringspring.system.scheduletask.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;

/**
 * 定时任务记录
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Data
@TableName("BASE_TIMETASK_LOG")
public class TimeTaskLogEntity {
    /**
     * 执行任务主键
     */
    @TableId("ID")
    private String id;

    /**
     * 定时任务主键
     */
    @TableField("TASK_ID")
    private String taskId;

    /**
     * 执行时间
     */
    @TableField("RUN_TIME")
    private Date runTime;

    /**
     * 执行结果
     */
    @TableField("RUN_RESULT")
    private Integer runResult;

    /**
     * 执行说明
     */
    @TableField("DESCRIPTION")
    private String description;
}
