/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.fileinfo.DataFileExport;
import com.bringspring.system.base.entity.BillRuleEntity;
import com.bringspring.system.base.model.billrule.BillRuleCrForm;
import com.bringspring.system.base.model.billrule.BillRuleInfoVO;
import com.bringspring.system.base.model.billrule.BillRuleListVO;
import com.bringspring.system.base.model.billrule.BillRuleUpForm;
import com.bringspring.system.base.service.BillRuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u5355\u636e\u89c4\u5219")
@RestController
@RequestMapping(value={"/api/system/BillRule"})
public class BillRuleController {
    @Autowired
    private DataFileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private BillRuleService billRuleService;
    @Autowired
    private UserService userService;

    @Operation(summary="\u83b7\u53d6\u5355\u636e\u89c4\u5219\u5217\u8868(\u5e26\u5206\u9875)")
    @GetMapping
    public ActionResult<PageListVO<BillRuleListVO>> list(Pagination pagination) {
        List<BillRuleEntity> list = this.billRuleService.getList(pagination);
        ArrayList listVO = new ArrayList();
        list.forEach(entity -> {
            BillRuleListVO vo = (BillRuleListVO)JsonUtil.getJsonToBean((Object)entity, BillRuleListVO.class);
            UserEntity userEntity = this.userService.getInfo(entity.getCreatorUserId());
            if (userEntity != null) {
                vo.setCreatorUserId(userEntity.getRealName());
            }
            listVO.add(vo);
        });
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(listVO, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u5355\u636e\u89c4\u5219\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult selectList() {
        List<BillRuleEntity> list = this.billRuleService.getList();
        List vo = JsonUtil.getJsonToList(list, BillRuleListVO.class);
        ListVO listVO = new ListVO();
        listVO.setList(vo);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u66f4\u65b0\u5355\u636e\u89c4\u5219\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult update(@PathVariable(value="id") String id) {
        BillRuleEntity entity = this.billRuleService.getInfo(id);
        if (entity != null) {
            if ("1".equals(String.valueOf(entity.getEnabledMark()))) {
                entity.setEnabledMark(0);
            } else {
                entity.setEnabledMark(1);
            }
            this.billRuleService.update(entity.getId(), entity);
            return ActionResult.success((String)MsgCode.SU004.get());
        }
        return ActionResult.fail((String)MsgCode.FA002.get());
    }

    @Operation(summary="\u83b7\u53d6\u5355\u636e\u89c4\u5219\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<BillRuleInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        BillRuleEntity entity = this.billRuleService.getInfo(id);
        BillRuleInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, BillRuleInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u5355\u636e\u6d41\u6c34\u53f7(\u5de5\u4f5c\u6d41\u8c03\u7528)")
    @GetMapping(value={"/BillNumber/{enCode}"})
    public ActionResult getBillNumber(@PathVariable(value="enCode") String enCode) throws DataException {
        String data = this.billRuleService.getBillNumber(enCode, false);
        return ActionResult.success((String)"\u83b7\u53d6\u6210\u529f", (Object)data);
    }

    @Operation(summary="\u6dfb\u52a0\u5355\u636e\u89c4\u5219")
    @PostMapping
    public ActionResult create(@RequestBody @Valid BillRuleCrForm billRuleCrForm) {
        BillRuleEntity entity = (BillRuleEntity)JsonUtil.getJsonToBean((Object)billRuleCrForm, BillRuleEntity.class);
        if (this.billRuleService.isExistByFullName(entity.getFullName(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.billRuleService.isExistByEnCode(entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        this.billRuleService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u4fee\u6539\u5355\u636e\u89c4\u5219")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody BillRuleUpForm billRuleUpForm) {
        BillRuleEntity entity = (BillRuleEntity)JsonUtil.getJsonToBean((Object)billRuleUpForm, BillRuleEntity.class);
        if (this.billRuleService.isExistByFullName(entity.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST001.get());
        }
        if (this.billRuleService.isExistByEnCode(entity.getFullName(), id)) {
            return ActionResult.fail((String)MsgCode.EXIST002.get());
        }
        boolean flag = this.billRuleService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u5355\u636e\u89c4\u5219")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        BillRuleEntity entity = this.billRuleService.getInfo(id);
        if (entity != null) {
            if (StringUtils.isNotEmpty((String)entity.getOutputNumber())) {
                return ActionResult.fail((String)"\u5355\u636e\u5df2\u7ecf\u88ab\u4f7f\u7528,\u4e0d\u5141\u8bb8\u88ab\u5220\u9664");
            }
            this.billRuleService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u5bfc\u51fa")
    @GetMapping(value={"/{id}/Action/Export"})
    public ActionResult export(@PathVariable(value="id") String id) {
        BillRuleEntity entity = this.billRuleService.getInfo(id);
        DownloadVO downloadVO = this.fileExport.exportFile((Object)entity, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.SYSTEM_BILLRULE.getTableName());
        return ActionResult.success((Object)downloadVO);
    }

    @Operation(summary="\u5bfc\u5165")
    @PostMapping(value={"/Action/Import"}, consumes={"multipart/form-data"})
    public ActionResult importData(@RequestPart(value="file") MultipartFile multipartFile) throws DataException {
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.SYSTEM_BILLRULE.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        BillRuleEntity entity = (BillRuleEntity)JsonUtil.getJsonToBean((String)fileContent, BillRuleEntity.class);
        return this.billRuleService.ImportData(entity);
    }
}

