/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.model.BurialPoint.VisitVO;
import com.bringspring.system.base.model.logs.ErrorLogVO;
import com.bringspring.system.base.model.logs.HandleLogVO;
import com.bringspring.system.base.model.logs.LogDelForm;
import com.bringspring.system.base.model.logs.LoginLogVO;
import com.bringspring.system.base.model.logs.LoginUserStatistics;
import com.bringspring.system.base.model.logs.LoginUserStatisticsQuery;
import com.bringspring.system.base.model.logs.PaginationLogModel;
import com.bringspring.system.base.model.logs.RequestLogVO;
import com.bringspring.system.base.service.LogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u7cfb\u7edf\u65e5\u5fd7")
@RestController
@RequestMapping(value={"/api/system/Log"})
public class LogController {
    @Autowired
    private LogService logService;

    @Operation(summary="\u83b7\u53d6\u7cfb\u7edf\u65e5\u5fd7\u5217\u8868")
    @GetMapping(value={"/{category}"})
    public ActionResult getInfoList(@PathVariable(value="category") String category, PaginationLogModel paginationTime) {
        if (StringUtils.isEmpty((String)category) || !StringUtils.isNumeric((CharSequence)category)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25");
        }
        List<LogEntity> list = this.logService.getList(Integer.parseInt(category), paginationTime);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationTime), PaginationVO.class);
        int i = Integer.parseInt(category);
        switch (i) {
            case 1: {
                List loginLogVOList = JsonUtil.getJsonToList(list, LoginLogVO.class);
                return ActionResult.page((List)loginLogVOList, (PaginationVO)paginationVO);
            }
            case 3: {
                List handleLogVOList = JsonUtil.getJsonToList(list, HandleLogVO.class);
                for (int j = 0; j < handleLogVOList.size(); ++j) {
                    ((HandleLogVO)handleLogVOList.get(j)).setJson(list.get(j).getJsons());
                }
                return ActionResult.page((List)handleLogVOList, (PaginationVO)paginationVO);
            }
            case 4: {
                List errorLogVOList = JsonUtil.getJsonToList(list, ErrorLogVO.class);
                for (int j = 0; j < errorLogVOList.size(); ++j) {
                    ((ErrorLogVO)errorLogVOList.get(j)).setJson(list.get(j).getJsons());
                }
                return ActionResult.page((List)errorLogVOList, (PaginationVO)paginationVO);
            }
            case 5: {
                List requestLogVOList = JsonUtil.getJsonToList(list, RequestLogVO.class);
                return ActionResult.page((List)requestLogVOList, (PaginationVO)paginationVO);
            }
        }
        return ActionResult.fail((String)"\u83b7\u53d6\u5931\u8d25");
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u65e5\u5fd7")
    @DeleteMapping
    public ActionResult delete(@RequestBody LogDelForm logDelForm) {
        boolean flag = this.logService.delete(logDelForm.getIds());
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA003.get());
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @Operation(summary="\u4e00\u952e\u6e05\u7a7a\u64cd\u4f5c\u65e5\u5fd7")
    @DeleteMapping(value={"/{type}"})
    public ActionResult deleteHandelLog(@PathVariable(value="type") String type) {
        this.logService.deleteHandleLog(type);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u83b7\u53d6\u83dc\u5355\u540d")
    @GetMapping(value={"/ModuleName"})
    public ActionResult<List<Map<String, String>>> moduleName() {
        ArrayList<HashedMap> list = new ArrayList<HashedMap>(16);
        Set<String> set = this.logService.queryList();
        for (String moduleName : set) {
            HashedMap map = new HashedMap(1);
            map.put("moduleName", moduleName);
            list.add(map);
        }
        return ActionResult.success(list);
    }

    @Operation(summary="\u6839\u636e\u8bf7\u6c42\u65e5\u5fd7\u7edf\u8ba1\u8fd130\u5206\u949f\u5185\uff0c\u6bcf\u5206\u949f\u4e0a\uff0c\u8bbf\u95ee\u8bf7\u6c42\u6240\u5c5e\u7528\u6237\u7684\u7528\u6237\u6570\u91cf")
    @GetMapping(value={"/countUserGroupByCreatorTime/{category}"})
    public ActionResult countUserGroupByCreatorTime(@PathVariable(value="category") String category, PaginationLogModel logModel) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.logService.selectUserGroupByCreatorTime(category, logModel);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u6839\u636e\u8bf7\u6c42\u65e5\u5fd7\u7edf\u8ba1\u8fd130\u5206\u949f\u5185\uff0c\u6bcf\u5206\u949f\u4e0a\uff0c\u8bbf\u95ee\u8bf7\u6c42\u6240\u5c5e\u6a21\u5757\u7684\u6a21\u5757\u6570\u91cf")
    @GetMapping(value={"/countModuleGroupByCreatorTime/{category}"})
    public ActionResult countModuleGroupByCreatorTime(@PathVariable(value="category") String category, PaginationLogModel logModel) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.logService.selectModuleGroupByCreatorTime(category, logModel);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u6839\u636e\u8bf7\u6c42\u65e5\u5fd7\u7edf\u8ba1\u8fd130\u5206\u949f\u5185\uff0c\u6bcf\u5206\u949f\u4e0a\uff0c\u8bbf\u95ee\u8bf7\u6c42\u6570\u91cf")
    @GetMapping(value={"/countRequestGroupByCreatorTime/{category}"})
    public ActionResult countRequestGroupByCreatorTime(@PathVariable(value="category") String category, PaginationLogModel logModel) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.logService.selectGroupByCreatorTime(category, logModel);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u6839\u636e\u8bf7\u6c42\u65e5\u5fd7\u7edf\u8ba1\u8fd130\u5206\u949f\u5185\uff0c\u6bcf\u5206\u949f\u4e0a\uff0c\u6df7\u5408\u6570\u636e")
    @GetMapping(value={"/countMixedGroupByCreatorTime/{category}"})
    public ActionResult countMixedGroupByCreatorTime(@PathVariable(value="category") String category, PaginationLogModel logModel) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.logService.selectMixedGroupByCreatorTime(category, logModel);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u6839\u636e\u8bf7\u6c42\u65e5\u5fd7\u7edf\u8ba1\u8fd130\u5206\u949f\u5185\uff0c\u529f\u80fd\u6a21\u5757\u7684\u8bf7\u6c42\u91cf")
    @GetMapping(value={"/countGroupByModule/{category}"})
    public ActionResult countGroupByModule(@PathVariable(value="category") String category, PaginationLogModel logModel) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> data = this.logService.selectGroupByModule(category, logModel);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u7528\u6237\u8bbf\u95ee\u529f\u80fd\u6b21\u6570")
    @PostMapping(value={"/userVisit"})
    public ActionResult userVisit(@RequestBody VisitVO visitVO) {
        ActionResult result = new ActionResult();
        List<VisitVO> data = this.logService.userVisit(visitVO);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        PageListVO vo = new PageListVO();
        vo.setList(data);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitVO), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u529f\u80fd\u8bbf\u95ee\u6b21\u6570")
    @PostMapping(value={"/functionVisit"})
    public ActionResult functionVisit(@RequestBody VisitVO visitVO) {
        ActionResult result = new ActionResult();
        List<VisitVO> data = this.logService.functionVisit(visitVO);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        PageListVO vo = new PageListVO();
        vo.setList(data);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)visitVO), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u7528\u6237\u8bbf\u95ee\u603b\u6b21\u6570")
    @PostMapping(value={"/functionUserVisit"})
    public ActionResult functionUserVisit(@RequestBody VisitVO visitVO) {
        ActionResult result = new ActionResult();
        List<VisitVO> data = this.logService.functionUserVisit(visitVO);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u6d3b\u8dc3\u7528\u6237\u6570")
    @PostMapping(value={"/functionUserCountVisit"})
    public ActionResult functionUserCountVisit(@RequestBody VisitVO visitVO) {
        ActionResult result = new ActionResult();
        List<VisitVO> data = this.logService.functionUserCountVisit(visitVO);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u4f7f\u7528\u8fc7\u7684\u529f\u80fd\u5217\u8868")
    @PostMapping(value={"/functionList"})
    public ActionResult functionList(@RequestBody VisitVO visitVO) {
        ActionResult result = new ActionResult();
        List<VisitVO> data = this.logService.functionList(visitVO);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @Operation(summary="\u767b\u5f55\u7528\u6237\u6570\u636e\u7edf\u8ba1")
    @PostMapping(value={"/loginUserStatistics"})
    public ActionResult loginUserStatistics(@RequestBody LoginUserStatisticsQuery loginUserStatisticsQuery) {
        ActionResult result = new ActionResult();
        LoginUserStatistics loginUserStatistics = this.logService.loginUserStatistics(loginUserStatisticsQuery);
        result.setData((Object)loginUserStatistics);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }
}

