/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.FormAllModel;
import com.bringspring.common.model.FormColumnModel;
import com.bringspring.common.model.FormColumnTableModel;
import com.bringspring.common.model.FormEnum;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.FormDataModel;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.ReflectionUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.model.form.FormBatchForm;
import com.bringspring.system.base.model.form.ModuleFormCrForm;
import com.bringspring.system.base.model.form.ModuleFormInfoVO;
import com.bringspring.system.base.model.form.ModuleFormListVO;
import com.bringspring.system.base.model.form.ModuleFormUpForm;
import com.bringspring.system.base.model.module.PropertyJsonModel;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u8868\u5355\u6743\u9650")
@RestController
@RequestMapping(value={"/api/system/ModuleForm"})
public class ModuleFormController {
    @Autowired
    private ModuleFormService moduleFormService;
    @Autowired
    private ModuleService moduleService;

    @Operation(summary="\u83b7\u53d6\u8868\u5355\u6743\u9650\u5217\u8868")
    @GetMapping(value={"/{moduleId}/Fields"})
    public ActionResult getList(@PathVariable(value="moduleId") String moduleId, Pagination pagination) {
        List<ModuleFormEntity> list = this.moduleFormService.getList(moduleId, pagination);
        List voList = JsonUtil.getJsonToList(list, ModuleFormListVO.class);
        voList.stream().forEach(t -> {
            if (StringUtils.isNotEmpty((String)t.getEnCode())) {
                t.setEnCode(StringUtils.isNotEmpty((String)t.getEnCode()) ? t.getEnCode().replace("jsbos_" + t.getBindTable() + "_jsbos_", "") : "");
            }
        });
        ListVO vo = new ListVO();
        vo.setList(voList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83dc\u5355\u6570\u636e\u6743\u9650")
    @GetMapping(value={"/{moduleId}/FieldList"})
    public ActionResult fieldList(@PathVariable(value="moduleId") String moduleId) {
        Object bean;
        Object method;
        Map map;
        ArrayList<HashedMap> list = new ArrayList<HashedMap>();
        ModuleEntity entity = this.moduleService.getInfo(moduleId);
        PropertyJsonModel model = (PropertyJsonModel)JsonUtil.getJsonToBean((String)entity.getPropertyJson(), PropertyJsonModel.class);
        if (model == null) {
            model = new PropertyJsonModel();
        }
        if ((map = JsonUtil.entityToMap((Object)(method = ReflectionUtil.invokeMethod((Object)(bean = SpringContext.getBean((String)"visualdevServiceImpl")), (String)"getInfo", (Class[])new Class[]{String.class}, (Object[])new Object[]{model.getModuleId()})))) != null && map.containsKey("formData")) {
            FormDataModel formDataModel = (FormDataModel)JsonUtil.getJsonToBean((String)String.valueOf(map.get("formData")), FormDataModel.class);
            List fieLdsModelList = JsonUtil.getJsonToList((String)formDataModel.getFields(), FieLdsModel.class);
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setList(fieLdsModelList);
            recursionForm.setTableModelList(JsonUtil.getJsonToList((String)String.valueOf(map.get("tables")), TableModel.class));
            ArrayList formAllModel = new ArrayList();
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            for (FormAllModel allModel : formAllModel) {
                HashedMap map1;
                FieLdsModel fieLdsModel;
                FormColumnModel formColumnModel;
                if (FormEnum.table.getMessage().equals(allModel.getKeyName())) {
                    FormColumnTableModel childList = allModel.getChildList();
                    HashedMap map12 = new HashedMap();
                    map12.put("field", childList.getTableModel());
                    map12.put("fieldName", childList.getLabel());
                    list.add(map12);
                    continue;
                }
                if (FormEnum.mast.getMessage().equals(allModel.getKeyName())) {
                    formColumnModel = allModel.getFormColumnModel();
                    fieLdsModel = formColumnModel.getFieLdsModel();
                    if (!StringUtils.isNotEmpty((String)fieLdsModel.getVModel())) continue;
                    map1 = new HashedMap();
                    map1.put("field", fieLdsModel.getVModel());
                    map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                    list.add(map1);
                    continue;
                }
                if (!FormEnum.mastTable.getMessage().equals(allModel.getKeyName()) || !StringUtils.isNotEmpty((String)(fieLdsModel = (formColumnModel = allModel.getFormMastTableModel()).getMastTable().getFieLdsModel()).getVModel())) continue;
                map1 = new HashedMap();
                map1.put("field", fieLdsModel.getVModel());
                map1.put("fieldName", fieLdsModel.getConfig().getLabel());
                list.add(map1);
            }
        }
        return ActionResult.success(list);
    }

    @Operation(summary="\u83b7\u53d6\u8868\u5355\u6743\u9650\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<ModuleFormInfoVO> info(@PathVariable(value="id") String id) throws DataException {
        ModuleFormEntity entity = this.moduleFormService.getInfo(id);
        ModuleEntity moduleEntity = this.moduleService.getInfo(entity.getModuleId());
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            entity.setEnCode(entity.getEnCode().replace("jsbos_" + entity.getBindTable() + "_jsbos_", ""));
        }
        ModuleFormInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, ModuleFormInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u65b0\u5efa\u8868\u5355\u6743\u9650")
    @PostMapping
    public ActionResult create(@RequestBody @Valid ModuleFormCrForm moduleFormCrForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(moduleFormCrForm.getModuleId());
        ModuleFormEntity entity = (ModuleFormEntity)JsonUtil.getJsonToBean((Object)moduleFormCrForm, ModuleFormEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (this.moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), entity.getId())) {
            return ActionResult.fail((String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        this.moduleFormService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u66f4\u65b0\u8868\u5355\u6743\u9650")
    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ModuleFormUpForm moduleFormUpForm) {
        ModuleEntity moduleEntity = this.moduleService.getInfo(moduleFormUpForm.getModuleId());
        ModuleFormEntity entity = (ModuleFormEntity)JsonUtil.getJsonToBean((Object)moduleFormUpForm, ModuleFormEntity.class);
        if (moduleEntity != null && moduleEntity.getType() == 2 && entity.getFieldRule() == 1 && StringUtils.isNotEmpty((String)entity.getBindTable())) {
            String enCode = "jsbos_" + entity.getBindTable() + "_jsbos_" + entity.getEnCode();
            entity.setEnCode(enCode);
        }
        if (this.moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), id)) {
            return ActionResult.fail((String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d");
        }
        boolean flag = this.moduleFormService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u8868\u5355\u6743\u9650")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        ModuleFormEntity entity = this.moduleFormService.getInfo(id);
        if (entity != null) {
            this.moduleFormService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u6279\u91cf\u65b0\u5efa\u8868\u5355\u6743\u9650")
    @PostMapping(value={"/Actions/Batch"})
    public ActionResult batchCreate(@RequestBody @Valid FormBatchForm formBatchForm) {
        List<ModuleFormEntity> entitys = formBatchForm.getFormJson() != null ? JsonUtil.getJsonToList((Object)formBatchForm.getFormJson(), ModuleFormEntity.class) : new ArrayList();
        ArrayList<String> name = new ArrayList<String>();
        for (ModuleFormEntity entity : entitys) {
            entity.setModuleId(formBatchForm.getModuleId());
            if (this.moduleFormService.isExistByEnCode(entity.getModuleId(), entity.getEnCode(), null)) {
                return ActionResult.fail((String)MsgCode.EXIST002.get());
            }
            if (name.contains(entity.getEnCode())) {
                return ActionResult.fail((String)MsgCode.EXIST002.get());
            }
            name.add(entity.getEnCode());
        }
        this.moduleFormService.create(entitys);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u66f4\u65b0\u8868\u5355\u6743\u9650\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    public ActionResult upState(@PathVariable(value="id") String id) {
        ModuleFormEntity entity;
        entity.setEnabledMark("1".equals(String.valueOf((entity = this.moduleFormService.getInfo(id)).getEnabledMark())) ? 0 : 1);
        boolean flag = this.moduleFormService.update(id, entity);
        if (!flag) {
            return ActionResult.success((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }
}

