/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.Page;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.base.model.online.BatchOnlineModel;
import com.bringspring.system.base.service.UserOnlineService;
import com.bringspring.system.message.model.UserOnlineModel;
import com.bringspring.system.message.model.UserOnlineVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5728\u7ebf\u7528\u6237")
@RestController
@RequestMapping(value={"/api/system/OnlineUser"})
public class UserOnlineController {
    @Autowired
    private UserOnlineService userOnlineService;

    @Operation(summary="\u83b7\u53d6\u5728\u7ebf\u7528\u6237\u5217\u8868")
    @GetMapping
    public ActionResult list(Page page) {
        List<UserOnlineModel> data = this.userOnlineService.getList(page);
        List vo = JsonUtil.getJsonToList(data, UserOnlineVO.class);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5f3a\u5236\u4e0b\u7ebf")
    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        this.userOnlineService.delete(id);
        return ActionResult.success((String)MsgCode.SU005.get());
    }

    @Operation(summary="\u6279\u91cf\u4e0b\u7ebf\u7528\u6237")
    @DeleteMapping
    public ActionResult clear(@RequestBody BatchOnlineModel model) {
        for (String id : model.getIds()) {
            this.userOnlineService.delete(id);
        }
        return ActionResult.success((String)MsgCode.SU005.get());
    }
}

