/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.mapper.ModuleColumnMapper;
import com.bringspring.system.base.service.ModuleColumnService;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleColumnServiceImpl
extends ServiceImpl<ModuleColumnMapper, ModuleColumnEntity>
implements ModuleColumnService {
    @Autowired
    private UserProvider userProvider;

    @Override
    public List<ModuleColumnEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleColumnEntity::getSortCode)).orderByDesc(ModuleColumnEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleColumnEntity> getEnabledMarkList(String enabledMark) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleColumnEntity::getEnabledMark, (Object)enabledMark);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleColumnEntity::getSortCode)).orderByDesc(ModuleColumnEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleColumnEntity> getList(String moduleId, Pagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ModuleColumnEntity::getEnCode, (Object)pagination.getKeyword())).or()).like(ModuleColumnEntity::getFullName, (Object)pagination.getKeyword()));
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleColumnEntity::getSortCode)).orderByDesc(ModuleColumnEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleColumnEntity> getList(String moduleId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)moduleId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleColumnEntity::getSortCode)).orderByDesc(ModuleColumnEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ModuleColumnEntity> getListByBindTable(String bindTable) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleColumnEntity::getBindTable, (Object)bindTable);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ModuleColumnEntity::getSortCode)).orderByDesc(ModuleColumnEntity::getCreatorTime);
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public ModuleColumnEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ModuleColumnEntity::getId, (Object)id);
        return (ModuleColumnEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public boolean isExistByFullName(String moduleId, String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleColumnEntity::getFullName, (Object)fullName)).eq(ModuleColumnEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleColumnEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String moduleId, String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleColumnEntity::getEnCode, (Object)enCode)).eq(ModuleColumnEntity::getModuleId, (Object)moduleId);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ModuleColumnEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public void create(ModuleColumnEntity entity) {
        if (entity.getId() == null) {
            entity.setSortCode(entity.getSortCode());
            entity.setId(RandomUtil.uuId());
        }
        this.save(entity);
    }

    @Override
    @DSTransactional
    public void create(List<ModuleColumnEntity> entitys) {
        Long sortCode = RandomUtil.parses();
        String userId = this.userProvider.get().getUserId();
        for (ModuleColumnEntity entity : entitys) {
            entity.setId(RandomUtil.uuId());
            Long l = sortCode;
            sortCode = sortCode + 1L;
            entity.setSortCode(l);
            entity.setEnabledMark("1".equals(String.valueOf(entity.getEnabledMark())) ? 0 : 1);
            entity.setCreatorUserId(userId);
            this.save(entity);
        }
    }

    @Override
    public boolean update(String id, ModuleColumnEntity entity) {
        entity.setId(id);
        entity.setLastModifyTime(DateUtil.getNowDate());
        return this.updateById(entity);
    }

    @Override
    public void delete(ModuleColumnEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        ModuleColumnEntity upEntity = (ModuleColumnEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)upEntity.getModuleId())).eq(ModuleColumnEntity::getBindTable, (Object)upEntity.getBindTable())).lt(ModuleColumnEntity::getSortCode, (Object)upSortCode)).orderByDesc(ModuleColumnEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((ModuleColumnEntity)downEntity.get(0)).getSortCode());
            ((ModuleColumnEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById((ModuleColumnEntity)downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        ModuleColumnEntity downEntity = (ModuleColumnEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().eq(ModuleColumnEntity::getModuleId, (Object)downEntity.getModuleId())).eq(ModuleColumnEntity::getBindTable, (Object)downEntity.getBindTable())).gt(ModuleColumnEntity::getSortCode, (Object)upSortCode)).orderByAsc(ModuleColumnEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((ModuleColumnEntity)upEntity.get(0)).getSortCode());
            ((ModuleColumnEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById((ModuleColumnEntity)upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }
}

