/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.Page;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.mapper.ProvinceMapper;
import com.bringspring.system.base.model.province.ProvinceListQuery;
import com.bringspring.system.base.service.ProvinceService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ProvinceServiceImpl
extends ServiceImpl<ProvinceMapper, ProvinceEntity>
implements ProvinceService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ProvinceService provinceService;

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getFullName, (Object)fullName);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ProvinceEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getEnCode, (Object)enCode);
        if (!StringUtils.isEmpty((String)id)) {
            queryWrapper.lambda().ne(ProvinceEntity::getId, (Object)id);
        }
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public List<ProvinceEntity> getListByParentId(String parentId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getParentId, (Object)parentId);
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getListByCityLevel(String cityLevel) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getCityLevel, (Object)cityLevel);
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getListByNodeId(String parentId, Page page) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (Objects.nonNull(page) && StringUtils.isNotEmpty((String)page.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ProvinceEntity::getFullName, (Object)page.getKeyword())).or()).like(ProvinceEntity::getEnCode, (Object)page.getKeyword()));
        }
        queryWrapper.lambda().eq(ProvinceEntity::getParentId, (Object)parentId);
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode)).orderByDesc(ProvinceEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(ProvinceEntity::getLastModifyTime);
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getListAll(ProvinceListQuery query) {
        QueryWrapper queryWrapper = new QueryWrapper();
        String keyword = query.getKeyword();
        if (StringUtils.isNotEmpty((String)keyword)) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(ProvinceEntity::getFullName, (Object)keyword)).or()).like(ProvinceEntity::getEnCode, (Object)keyword)).or()).like(ProvinceEntity::getQuickQuery, (Object)keyword));
        }
        if (StringUtils.isNotEmpty((String)query.getEnCode())) {
            queryWrapper.lambda().like(ProvinceEntity::getEnCode, (Object)query.getEnCode());
        }
        if (StringUtils.isNotEmpty((String)query.getFullName())) {
            queryWrapper.lambda().like(ProvinceEntity::getFullName, (Object)query.getFullName());
        }
        if (StringUtils.isNotEmpty((String)query.getQuickQuery())) {
            queryWrapper.lambda().like(ProvinceEntity::getQuickQuery, (Object)query.getQuickQuery());
        }
        if (StringUtils.isNotEmpty((String)query.getParentId())) {
            queryWrapper.lambda().eq(ProvinceEntity::getParentId, (Object)query.getParentId());
        }
        if (StringUtils.isNotEmpty((String)query.getType())) {
            queryWrapper.lambda().eq(ProvinceEntity::getType, (Object)query.getType());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode)).orderByAsc(ProvinceEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getAllList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByDesc(ProvinceEntity::getSortCode)).orderByAsc(ProvinceEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getAllProList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().select(new SFunction[]{ProvinceEntity::getId, ProvinceEntity::getFullName});
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getProList(List<String> ProIdList) {
        if (ProIdList.size() > 0) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().select(new SFunction[]{ProvinceEntity::getId, ProvinceEntity::getFullName}).in(ProvinceEntity::getId, ProIdList);
            return this.list((Wrapper)queryWrapper);
        }
        return new ArrayList<ProvinceEntity>();
    }

    @Override
    public ProvinceEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ProvinceEntity::getId, (Object)id);
        return (ProvinceEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void delete(ProvinceEntity entity) {
        this.removeById((Serializable)((Object)entity.getId()));
    }

    @Override
    public void create(ProvinceEntity entity) {
        entity.setId(RandomUtil.uuId());
        if ("-1".equals(entity.getParentId())) {
            entity.setParentIdTree(entity.getId());
        } else {
            entity.setParentIdTree(entity.getParentIdTree() + "," + entity.getId());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProvinceEntity entity) {
        entity.setId(id);
        if ("-1".equals(entity.getParentId())) {
            entity.setParentIdTree(entity.getId());
        } else {
            entity.setParentIdTree(entity.getParentIdTree() + "," + entity.getId());
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        ProvinceEntity upEntity = (ProvinceEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = upEntity.getSortCode() == null ? 0L : upEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().lt(ProvinceEntity::getSortCode, (Object)upSortCode)).eq(ProvinceEntity::getParentId, (Object)upEntity.getParentId())).orderByDesc(ProvinceEntity::getSortCode);
        List downEntity = this.list((Wrapper)queryWrapper);
        if (downEntity.size() > 0) {
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(((ProvinceEntity)downEntity.get(0)).getSortCode());
            ((ProvinceEntity)downEntity.get(0)).setSortCode(temp);
            this.updateById((ProvinceEntity)downEntity.get(0));
            this.updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        ProvinceEntity downEntity = (ProvinceEntity)this.getById((Serializable)((Object)id));
        Long upSortCode = downEntity.getSortCode() == null ? 0L : downEntity.getSortCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.lambda().gt(ProvinceEntity::getSortCode, (Object)upSortCode)).eq(ProvinceEntity::getParentId, (Object)downEntity.getParentId())).orderByAsc(ProvinceEntity::getSortCode);
        List upEntity = this.list((Wrapper)queryWrapper);
        if (upEntity.size() > 0) {
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(((ProvinceEntity)upEntity.get(0)).getSortCode());
            ((ProvinceEntity)upEntity.get(0)).setSortCode(temp);
            this.updateById((ProvinceEntity)upEntity.get(0));
            this.updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<ProvinceEntity> infoList(List<String> lists) {
        List<ProvinceEntity> list = new ArrayList<ProvinceEntity>();
        if (!ObjectUtils.isEmpty(lists)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(ProvinceEntity::getId, lists);
            list = this.list((Wrapper)queryWrapper);
        }
        return list;
    }

    @Override
    public String getAreaIds(String strs) {
        QueryWrapper provinceQueryWrapper = new QueryWrapper();
        String[] str = strs.split("/");
        ArrayList<String> list1 = new ArrayList<String>();
        String id = "";
        String collect = "";
        List list2 = new ArrayList();
        for (int i = 0; i < str.length; ++i) {
            list2 = i == 0 ? this.provinceService.list((Wrapper)Wrappers.lambdaQuery().eq(ProvinceEntity::getFullName, (Object)str[i])) : this.provinceService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(ProvinceEntity::getFullName, (Object)str[i])).eq(ProvinceEntity::getParentId, (Object)id));
            ProvinceEntity provinceEntity = (ProvinceEntity)list2.get(0);
            id = provinceEntity.getId();
            collect = list2.stream().map(ProvinceEntity::getId).collect(Collectors.joining());
            list1.add(collect);
        }
        Object result = list1.stream().map(s -> "\"" + s + "\"").collect(Collectors.joining(", "));
        result = "[" + (String)result + "]";
        return result;
    }
}

