/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.base.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.MailAccount;
import com.bringspring.common.base.systemconfig.QyChatModel;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.EmailConfigEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.mapper.SysConfigMapper;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.Pop3Util;
import com.bringspring.system.base.util.SmtpUtil;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.config.mutil.DingTalkConfiguration;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.util.BlacklistUtil;
import com.bringspring.system.msgcenter.util.SensitiveWordUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysConfigServiceImpl
extends ServiceImpl<SysConfigMapper, SysConfigEntity>
implements SysConfigService {
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private Pop3Util pop3Util;
    @Autowired
    private WxCpConfiguration wxCpConfiguration;
    @Autowired
    private DingTalkConfiguration dingTalkConfiguration;
    @Autowired
    private SensitiveWordUtil sensitiveWordUtil;
    @Autowired
    private BlacklistUtil blacklistUtil;
    @Autowired
    private McMsgAccountService mcMsgAccountService;

    @Override
    public List<SysConfigEntity> getList() {
        List list = new ArrayList();
        String cacheKey = this.cacheKeyUtil.getSystemInfo();
        if (this.cacheUtil.exists("foreverCacheSpace", cacheKey)) {
            Object systeminfo = this.cacheUtil.query("foreverCacheSpace", cacheKey);
            list = ObjectUtil.isNotEmpty((Object)systeminfo) && systeminfo instanceof String ? JsonUtil.getJsonToList((String)String.valueOf(systeminfo), SysConfigEntity.class) : (List)systeminfo;
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            list = this.list((Wrapper)queryWrapper);
            this.cacheUtil.insert("foreverCacheSpace", cacheKey, (Object)JsonUtil.getObjectToString(list));
        }
        return list;
    }

    @Override
    public Map<String, String> getConfigsByCategory(String category) throws BaseException {
        if (StringUtils.isEmpty((String)category)) {
            throw new BaseException("\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SysConfigEntity> list = this.getList();
        list = list.stream().filter(config -> config.getCategory().equals(category)).collect(Collectors.toList());
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        for (SysConfigEntity entity : list) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        return objModel;
    }

    @Override
    public String getSystemAddress(String terminal) throws BaseException {
        if ("pc".equals(terminal)) {
            String sysComputerUrl = this.getConfigByKeyName("sysComputerUrl").getKeyValue();
            int index = sysComputerUrl.indexOf(35);
            if (index != -1) {
                sysComputerUrl = sysComputerUrl.substring(0, index);
            }
            return sysComputerUrl;
        }
        String sysMobileUrl = this.getConfigByKeyName("sysMobileUrl").getKeyValue();
        int index = sysMobileUrl.indexOf(35);
        if (index != -1) {
            sysMobileUrl = sysMobileUrl.substring(0, index);
        }
        return sysMobileUrl;
    }

    @Override
    public SysConfigEntity getConfigByKeyName(String keyName) throws BaseException {
        List<SysConfigEntity> list = this.getList();
        SysConfigEntity configEntity = list.stream().filter(config -> StringUtils.isNotEmpty((String)config.getKeyName()) && config.getKeyName().equals(keyName)).findFirst().orElse(null);
        return configEntity;
    }

    @Override
    public List<QyChatModel> getQyChatModelList() throws BaseException {
        ArrayList<QyChatModel> resultList = new ArrayList<QyChatModel>();
        SysConfigEntity weComInfo = this.getConfigByKeyName("weCom");
        if (ObjectUtil.isNotEmpty((Object)weComInfo) && StringUtils.isNotEmpty((String)weComInfo.getKeyValue())) {
            String keyValue = weComInfo.getKeyValue();
            List listModel = JsonUtil.getJsonToList((String)keyValue, WeComModel.class);
            CopyOptions options = CopyOptions.create().setIgnoreProperties(new String[]{"qyhCorpSecret", "qyhAgentSecret", "token", "encodingAESKey"});
            if (CollectionUtil.isNotEmpty((Collection)listModel)) {
                String pcUrl = this.getConfigByKeyName("sysComputerUrl").getKeyValue();
                String appUrl = this.getConfigByKeyName("sysMobileUrl").getKeyValue();
                List accountIds = listModel.stream().map(item -> item.getAccountConfigId()).collect(Collectors.toList());
                List mcMsgAccountEntities = this.mcMsgAccountService.listByIds(accountIds);
                listModel.forEach(item -> {
                    WeComModel weComModel = new WeComModel();
                    BeanUtil.copyProperties((Object)item, (Object)((Object)weComModel), (CopyOptions)options);
                    mcMsgAccountEntities.stream().filter(mc -> mc.getId().equals(item.getAccountConfigId())).findFirst().ifPresent(mc -> {
                        weComModel.setQyhCorpId(mc.getEnterpriseId());
                        weComModel.setQyhAgentId(mc.getAgentId());
                        weComModel.setQyhComputerUrl(pcUrl);
                        weComModel.setQyhMobileUrl(appUrl);
                    });
                    resultList.add(weComModel);
                });
            }
        }
        return resultList;
    }

    @Override
    public BaseSystemInfo getSysInfo() {
        HashMap<String, String> objModel = new HashMap<String, String>(16);
        List<SysConfigEntity> list = this.getList();
        for (SysConfigEntity entity : list) {
            objModel.put(entity.getKeyName(), entity.getKeyValue());
        }
        BaseSystemInfo baseSystemInfo = (BaseSystemInfo)JsonUtil.getJsonToBean(objModel, BaseSystemInfo.class);
        return baseSystemInfo;
    }

    @Override
    public QyChatModel getQyChatInfo() throws BaseException {
        Map<String, String> qyhConfig = this.getConfigsByCategory("QYHConfig");
        QyChatModel qyChatModel = (QyChatModel)JsonUtil.getJsonToBean(qyhConfig, QyChatModel.class);
        return qyChatModel;
    }

    @Override
    @DSTransactional
    public void saveBatch(List<SysConfigEntity> entitys, String category) throws BaseException {
        if (StringUtils.isNotEmpty((String)category)) {
            String cacheKey = this.cacheKeyUtil.getSystemInfo();
            this.cacheUtil.remove("foreverCacheSpace", cacheKey);
            this.deleteByCategory(category);
            for (SysConfigEntity entity : entitys) {
                entity.setCategory(category);
                ((SysConfigMapper)this.baseMapper).insert(entity);
            }
        } else {
            throw new BaseException("\u7a7a\u5206\u7c7b\u4e0d\u5141\u8bb8\u4fdd\u5b58");
        }
        this.getList();
        if ("WeComConfig".equals(category)) {
            this.wxCpConfiguration.initServices();
        }
        if ("DingComConfig".equals(category)) {
            this.dingTalkConfiguration.initModels();
        }
        if ("McConfig".equals(category)) {
            this.sensitiveWordUtil.run(null);
            this.blacklistUtil.run(null);
        }
    }

    @Override
    @DSTransactional
    public void create(SysConfigEntity sysConfigEntity) {
        this.deleteByKeyName(sysConfigEntity.getKeyName());
        sysConfigEntity.setId(RandomUtil.uuId());
        ((SysConfigMapper)this.baseMapper).insert(sysConfigEntity);
        String cacheKey = this.cacheKeyUtil.getSystemInfo();
        this.cacheUtil.remove("foreverCacheSpace", cacheKey);
        this.getList();
    }

    @Override
    public void deleteByCategory(String category) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SysConfigEntity::getCategory, (Object)category);
        ((SysConfigMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public void deleteByKeyName(String keyName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(SysConfigEntity::getKeyName, (Object)keyName);
        ((SysConfigMapper)this.baseMapper).delete((Wrapper)queryWrapper);
    }

    @Override
    public String checkMainLogin(EmailConfigEntity configEntity) {
        MailAccount mailAccount = new MailAccount();
        mailAccount.setAccount(configEntity.getAccount());
        mailAccount.setPassword(configEntity.getPassword());
        mailAccount.setPop3Host(configEntity.getPop3Host());
        mailAccount.setPop3Port(configEntity.getPop3Port().intValue());
        mailAccount.setSmtpHost(configEntity.getSmtpHost());
        mailAccount.setSmtpPort(configEntity.getSmtpPort().intValue());
        if ("1".equals(String.valueOf(configEntity.getEmailSsl()))) {
            mailAccount.setSsl(Boolean.valueOf(true));
        } else {
            mailAccount.setSsl(Boolean.valueOf(false));
        }
        if (mailAccount.getSmtpHost() != null) {
            return SmtpUtil.checkConnected(mailAccount);
        }
        if (mailAccount.getPop3Host() != null) {
            return this.pop3Util.checkConnected(mailAccount);
        }
        return "false";
    }

    @Override
    public List<SysConfigEntity> getConfigListByCategory(String category) throws BaseException {
        if (StringUtils.isEmpty((String)category)) {
            throw new BaseException("\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SysConfigEntity> list = this.getList();
        list = list.stream().filter(config -> config.getCategory().equals(category)).collect(Collectors.toList());
        return list;
    }
}

