/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.external.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.model.dingding.DingDeptModel;
import com.bringspring.system.base.model.dingding.DingUserIdModel;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.external.config.mutil.DingTalkConfiguration;
import com.bringspring.system.external.listener.DIngTalkStream;
import com.bringspring.system.external.util.DingTalkSynUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.OraganizeListVO;
import com.bringspring.system.message.service.SynThirdDingTalkService;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.message.util.SynThirdTotal;
import com.bringspring.system.msgcenter.model.message.MyDingTalkModel;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.model.organize.OrganizeModel;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiUserListidRequest;
import com.dingtalk.api.request.OapiV2UserGetRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiUserListidResponse;
import com.dingtalk.api.response.OapiV2UserGetResponse;
import com.taobao.api.TaobaoRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u963f\u91cc\u9489\u9489\u901a\u8baf\u5f55\u4fe1\u606f\u540c\u6b65")
@RestController
@RequestMapping(value={"/api/external/dingTalk/{corpId}/{appId}"})
public class DingTalkSynThirdController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DingTalkSynThirdController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private SynThirdDingTalkService synThirdDingTalkService;
    @Autowired
    private DingTalkConfiguration dingTalkConfiguration;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private DIngTalkStream dIngTalkStream;

    @Operation(summary="\u672c\u5730\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllOrganizeSysToDing"})
    public ActionResult synAllOrganizeSysToDing(@PathVariable String corpId, @PathVariable String appId) {
        JSONObject retMsg = new JSONObject();
        MyDingTalkModel dingTalkModel = this.dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();
        try {
            JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.fail((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            List<OrganizeEntity> organizeList = this.organizeService.getList();
            List organizeModelList = JsonUtil.getJsonToList(organizeList, OrganizeModel.class);
            List trees = TreeDotUtils.convertListToTreeDot((List)organizeModelList);
            List listVO = JsonUtil.getJsonToList((Object)trees, OraganizeListVO.class);
            ArrayList<OrganizeEntity> listByOrder = new ArrayList<OrganizeEntity>();
            for (OraganizeListVO organizeVo : listVO) {
                OrganizeEntity entity = organizeList.stream().filter(t -> t.getId().equals(organizeVo.getId())).findFirst().orElse(null);
                listByOrder.add(entity);
                DingTalkSynUtil.getOrganizeTreeToList(organizeVo, organizeList, listByOrder);
            }
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (organizeList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteDepartmentSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            synThirdInfoList = this.synThirdInfoService.getList("2", "1");
            for (OrganizeEntity organizeEntity : listByOrder) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(organizeEntity.getId())).count() > 0L) {
                    retMsg = this.synThirdDingTalkService.updateDepartmentSysToDing(true, organizeEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.createDepartmentSysToDing(true, organizeEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }

    @Operation(summary="\u672c\u5730\u6240\u6709\u7528\u6237\u4fe1\u606f\u540c\u6b65\u5230\u9489\u9489")
    @PostMapping(value={"/synAllUserSysToDing"})
    public ActionResult synAllUserSysToDing(@PathVariable String corpId, @PathVariable String appId) throws ParseException {
        JSONObject retMsg = new JSONObject();
        MyDingTalkModel dingTalkModel = this.dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        String appSecret = dingTalkModel.getClientSecrent();
        try {
            JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret);
            if (!tokenObject.getBoolean("code").booleanValue()) {
                return ActionResult.success((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
            }
            String access_token = tokenObject.getString("access_token");
            List<SynThirdInfoEntity> synThirdInfoList = this.synThirdInfoService.getList("2", "2");
            List<UserEntity> userList = this.userService.getList();
            for (SynThirdInfoEntity synThirdInfoEntity : synThirdInfoList) {
                if (userList.stream().filter(t -> t.getId().equals(synThirdInfoEntity.getSystemObjectId())).count() != 0L) continue;
                retMsg = this.synThirdDingTalkService.deleteUserSysToDing(true, synThirdInfoEntity.getSystemObjectId(), access_token);
            }
            for (UserEntity userEntity : userList) {
                if (synThirdInfoList.stream().filter(t -> t.getSystemObjectId().equals(userEntity.getId())).count() == 0L) {
                    retMsg = this.synThirdDingTalkService.createUserSysToDing(true, userEntity, access_token);
                    continue;
                }
                retMsg = this.synThirdDingTalkService.updateUserSysToDing(true, userEntity, access_token);
            }
        }
        catch (Exception e) {
            ActionResult.fail((String)e.toString());
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "2");
        return ActionResult.success((Object)synThirdTotal);
    }

    @Operation(summary="\u9489\u9489\u6240\u6709\u7ec4\u7ec7\u4fe1\u606f(\u5305\u542b\u516c\u53f8\u548c\u90e8\u95e8)\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllOrganizeSys"})
    public ActionResult synDingToAllOrganizeSys(@PathVariable String corpId, @PathVariable String appId) throws Exception {
        String appSecret;
        MyDingTalkModel dingTalkModel = this.dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret = dingTalkModel.getClientSecrent());
        if (!tokenObject.getBoolean("code").booleanValue()) {
            return ActionResult.success((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
        }
        String access_token = tokenObject.getString("access_token");
        OapiGettokenRequest req = new OapiGettokenRequest();
        String serverUrl = "https://oapi.dingtalk.com/topapi/v2/department/listsub";
        DefaultDingTalkClient client = new DefaultDingTalkClient(serverUrl);
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, access_token);
        System.out.println(execute.getBody());
        List resultDepart = JsonUtil.getJsonToList((String)String.valueOf(JsonUtil.stringToMap((String)execute.getBody()).get("result")), DingDeptModel.class);
        if (CollectionUtil.isNotEmpty((Collection)resultDepart)) {
            return this.dIngTalkStream.orgAOD(resultDepart, corpId);
        }
        return ActionResult.fail((String)"\u6ca1\u6709\u8c03\u7528\u8be5\u63a5\u53e3\u7684\u6743\u9650");
    }

    @Operation(summary="\u9489\u9489\u6240\u6709\u7528\u6237\u540c\u6b65\u5230\u672c\u5730")
    @PostMapping(value={"/synDingToAllUserSys"})
    public ActionResult synDingToAllUserSys(@PathVariable String corpId, @PathVariable String appId) throws Exception {
        String appSecret;
        MyDingTalkModel dingTalkModel = this.dingTalkConfiguration.getDingTalkModel(corpId);
        String appKey = dingTalkModel.getClientId();
        JSONObject tokenObject = DingTalkSynUtil.getAccessToken(appKey, appSecret = dingTalkModel.getClientSecrent());
        if (!tokenObject.getBoolean("code").booleanValue()) {
            return ActionResult.success((String)"\u83b7\u53d6\u9489\u9489\u7684access_token\u5931\u8d25");
        }
        String accessToken = tokenObject.getString("access_token");
        OapiGettokenRequest req = new OapiGettokenRequest();
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/department/listsub");
        OapiGettokenResponse execute = (OapiGettokenResponse)client.execute((TaobaoRequest)req, accessToken);
        System.out.println(execute.getBody());
        ArrayList<DingDeptModel> resultDepart = new ArrayList<DingDeptModel>();
        DingDeptModel dingDeptModelPar = new DingDeptModel();
        dingDeptModelPar.setDept_id("1");
        resultDepart.add(dingDeptModelPar);
        Object result = JsonUtil.stringToMap((String)execute.getBody()).get("result");
        List dingDeptList = JsonUtil.getJsonToList((String)String.valueOf(result), DingDeptModel.class);
        resultDepart.addAll(dingDeptList);
        ArrayList<DingUserModel> resultUserList = new ArrayList<DingUserModel>();
        List<RoleEntity> listByEnCode = this.roleService.getListByEnCode("SimpleUser");
        List<SynThirdInfoEntity> listThird = this.synThirdInfoService.getList("2", "2");
        UserInfo userInfo = this.userProvider.get();
        if (!ObjectUtil.isEmpty(resultDepart)) {
            for (int i = 0; i < resultDepart.size(); ++i) {
                DingDeptModel dingDeptModel = (DingDeptModel)resultDepart.get(i);
                DefaultDingTalkClient clientUserId = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/user/listid");
                OapiUserListidRequest reqUserId = new OapiUserListidRequest();
                reqUserId.setDeptId(Long.valueOf(dingDeptModel.getDept_id()));
                OapiUserListidResponse rspUserListid = (OapiUserListidResponse)clientUserId.execute((TaobaoRequest)reqUserId, accessToken);
                System.out.println(rspUserListid.getBody());
                String resUserListid = String.valueOf(JsonUtil.stringToMap((String)rspUserListid.getBody()).get("result"));
                DingUserIdModel userListid = (DingUserIdModel)JsonUtil.getJsonToBean((String)resUserListid, DingUserIdModel.class);
                if (ObjectUtil.isEmpty((Object)userListid) || !CollectionUtil.isNotEmpty(userListid.getUserid_list())) continue;
                List<String> userid_list = userListid.getUserid_list();
                for (String userid : userid_list) {
                    DefaultDingTalkClient clientUser = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/get");
                    OapiV2UserGetRequest reqUser = new OapiV2UserGetRequest();
                    reqUser.setUserid(userid);
                    OapiV2UserGetResponse rspUser = (OapiV2UserGetResponse)clientUser.execute((TaobaoRequest)reqUser, accessToken);
                    String resUser = String.valueOf(JsonUtil.stringToMap((String)rspUser.getBody()).get("result"));
                    DingUserModel user = (DingUserModel)JsonUtil.getJsonToBean((String)resUser, DingUserModel.class);
                    user.setDepartmentId(dingDeptModel.getDept_id());
                    if (CollectionUtil.isNotEmpty(resultDepart)) {
                        this.dIngTalkStream.userAOD(user.getUserid(), corpId);
                        resultUserList.add(user);
                        continue;
                    }
                    return ActionResult.fail((String)"\u6ca1\u6709\u8c03\u7528\u8be5\u63a5\u53e3\u7684\u6743\u9650");
                }
            }
        }
        SynThirdTotal synThirdTotal = this.synThirdInfoService.getSynTotal("2", "1");
        return ActionResult.success((Object)synThirdTotal);
    }
}

