/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.system.external.config.mutil.DingTalkConfiguration;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.msgcenter.constant.Constants;
import com.bringspring.system.msgcenter.constant.DictType;
import com.bringspring.system.msgcenter.entity.McMsgAccountEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountCrForm;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountListVO;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountPagination;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountSelector;
import com.bringspring.system.msgcenter.model.mcmsgaccount.McMsgAccountUpForm;
import com.bringspring.system.msgcenter.service.McMsgAccountService;
import com.bringspring.system.msgcenter.service.McMsgSendTemplateService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u8d26\u53f7\u914d\u7f6e\u8868")
@RequestMapping(value={"/api/msgCenter/mcMsgAccount"})
public class McMsgAccountController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(McMsgAccountController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private McMsgAccountService mcMsgAccountService;
    @Autowired
    private McMsgSendTemplateService mcMsgSendTemplateService;
    @Autowired
    private WxCpConfiguration wxCpConfiguration;
    @Autowired
    private DingTalkConfiguration dingTalkConfiguration;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody McMsgAccountPagination mcMsgAccountPagination) throws IOException {
        List<McMsgAccountEntity> list = this.mcMsgAccountService.getList(mcMsgAccountPagination);
        List listVO = JsonUtil.getJsonToList(list, McMsgAccountListVO.class);
        for (McMsgAccountListVO vo : listVO) {
            vo.setCategory(this.baseDataUtil.getDictName(vo.getCategory(), DictType.MSG_TYPE.getCode()));
            vo.setSslLink(this.baseDataUtil.switchSelectValue(vo.getSslLink(), Constants.SslStatus.ON.getDisplay(), Constants.SslStatus.OFF.getDisplay()));
            vo.setChannel(this.baseDataUtil.getDictName(vo.getChannel(), DictType.SMS_TYPE.getCode()));
            vo.setWebhookType(this.baseDataUtil.getDictName(vo.getWebhookType(), DictType.WEB_HOOK_TYPE.getCode()));
            vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
            vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)mcMsgAccountPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid McMsgAccountCrForm mcMsgAccountCrForm) throws DataException {
        if (!this.mcMsgAccountService.checkEnCodeUnique(mcMsgAccountCrForm.getEnCode(), null)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgAccountService.checkFullNameUnique(mcMsgAccountCrForm.getFullName(), null)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        this.mcMsgAccountService.create(mcMsgAccountCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<McMsgAccountInfoVO> info(@PathVariable(value="id") String id) {
        McMsgAccountEntity entity = this.mcMsgAccountService.getInfo(id);
        McMsgAccountInfoVO vo = (McMsgAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgAccountInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<McMsgAccountInfoVO> detailInfo(@PathVariable(value="id") String id) {
        McMsgAccountEntity entity = this.mcMsgAccountService.getInfo(id);
        McMsgAccountInfoVO vo = (McMsgAccountInfoVO)JsonUtil.getJsonToBean((Object)entity, McMsgAccountInfoVO.class);
        vo.setCategory(this.baseDataUtil.getDictName(vo.getCategory(), DictType.MSG_TYPE.getCode()));
        vo.setSslLink(this.baseDataUtil.switchSelectValue(vo.getSslLink(), Constants.SslStatus.ON.getDisplay(), Constants.SslStatus.OFF.getDisplay()));
        vo.setChannel(this.baseDataUtil.getDictName(vo.getChannel(), DictType.SMS_TYPE.getCode()));
        vo.setWebhookType(this.baseDataUtil.getDictName(vo.getWebhookType(), DictType.WEB_HOOK_TYPE.getCode()));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), Constants.EnableStatus.ENABLED.getDisplay(), Constants.EnableStatus.DISABLED.getDisplay()));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid McMsgAccountUpForm mcMsgAccountUpForm) throws DataException {
        if (!this.mcMsgAccountService.checkEnCodeUnique(mcMsgAccountUpForm.getEnCode(), id)) {
            return ActionResult.fail((String)"\u7f16\u7801\u5df2\u5b58\u5728");
        }
        if (!this.mcMsgAccountService.checkFullNameUnique(mcMsgAccountUpForm.getFullName(), id)) {
            return ActionResult.fail((String)"\u540d\u79f0\u5df2\u5b58\u5728");
        }
        McMsgAccountEntity entity = this.mcMsgAccountService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            this.mcMsgAccountService.update(id, mcMsgAccountUpForm);
            if (ChannelTypeEnum.QY_MSG.getCode().equals(entity.getCategory())) {
                this.wxCpConfiguration.initServices();
            }
            if (ChannelTypeEnum.DING_MSG.getCode().equals(entity.getCategory())) {
                this.dingTalkConfiguration.initModels();
            }
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        McMsgAccountEntity entity = this.mcMsgAccountService.getInfo(id);
        if (ObjectUtil.isNotNull((Object)entity)) {
            if (this.mcMsgSendTemplateService.getCountByAccountConfigId(entity.getId()) > 0L) {
                return ActionResult.fail((String)"\u53d1\u9001\u914d\u7f6e\u5df2\u5173\u8054\u8d26\u53f7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            this.mcMsgAccountService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u6d88\u606f\u8d26\u53f7\u914d\u7f6e\u4e0b\u62c9\u6846")
    @GetMapping(value={"/Selector"})
    public ActionResult<PageListVO<McMsgAccountSelector>> selector(McMsgAccountPagination pagination) {
        List<McMsgAccountEntity> list = this.mcMsgAccountService.getList(pagination);
        List listSelector = JsonUtil.getJsonToList(list, McMsgAccountSelector.class);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page((List)listSelector, (PaginationVO)paginationVO);
    }
}

