/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.msgcenter.entity.McMsgSendEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.exception.MsgCenterException;
import com.bringspring.system.msgcenter.mapper.McTaskMsgMapper;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgPagination;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgUpForm;
import com.bringspring.system.msgcenter.service.McBusinessService;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.service.McMsgTemplateService;
import com.bringspring.system.msgcenter.service.McTaskMsgContentService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.McTaskMsgService;
import com.bringspring.system.msgcenter.service.context.SendReceiveParam;
import com.bringspring.system.msgcenter.service.strategy.AbstractMessageChannelStrategy;
import com.bringspring.system.msgcenter.service.strategy.factory.MessageChannelStrategyFactory;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.UserService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class McTaskMsgServiceImpl
extends ServiceImpl<McTaskMsgMapper, McTaskMsgEntity>
implements McTaskMsgService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McBusinessService mcBusinessService;
    @Autowired
    private McMsgTemplateService mcMsgTemplateService;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private McTaskMsgMapper mcTaskMsgMapper;
    @Autowired
    private MessageChannelStrategyFactory strategyFactory;
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public List<McTaskMsgEntity> getList(McTaskMsgPagination pagination) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            queryWrapper.lambda().and(t -> ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)t.like(McTaskMsgEntity::getId, (Object)pagination.getKeyword())).or()).like(McTaskMsgEntity::getTaskCode, (Object)pagination.getKeyword())).or()).like(McTaskMsgEntity::getSendCode, (Object)pagination.getKeyword()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSendCode())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getSendCode, (Object)pagination.getSendCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getEnabledMark())) {
            queryWrapper.lambda().eq(McTaskMsgEntity::getEnabledMark, (Object)Integer.parseInt(pagination.getEnabledMark()));
        }
        if (StringUtils.isNotEmpty((String)pagination.getToUserIds())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getToUserIds, (Object)pagination.getToUserIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgEntity mcTaskMsgEntity = new McTaskMsgEntity();
                Field declaredField = mcTaskMsgEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<McTaskMsgEntity> getTypeList(McTaskMsgPagination pagination, String dataType) {
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)pagination.getTaskCode())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getTaskCode, (Object)pagination.getTaskCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getSendCode())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getSendCode, (Object)pagination.getSendCode());
        }
        if (StringUtils.isNotEmpty((String)pagination.getToUserIds())) {
            queryWrapper.lambda().like(McTaskMsgEntity::getToUserIds, (Object)pagination.getToUserIds());
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgEntity mcTaskMsgEntity = new McTaskMsgEntity();
                Field declaredField = mcTaskMsgEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public McTaskMsgEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(McTaskMsgEntity::getId, (Object)id);
        return (McTaskMsgEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McTaskMsgCrForm mcTaskMsgCrForm) {
        String mainId = RandomUtil.uuId();
        McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgCrForm, McTaskMsgEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McTaskMsgUpForm mcTaskMsgUpForm) {
        McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgUpForm, McTaskMsgEntity.class);
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(McTaskMsgEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public void addAndSendMessage(McTaskMsgCrForm mcTaskMsgCrForm) throws Exception {
        McTaskMsgEntity entity = this.addTaskMsg(mcTaskMsgCrForm);
        if (!ObjectUtil.isEmpty((Object)entity)) {
            this.sendTaskMsgReceive(entity);
        }
    }

    @Override
    public McTaskMsgEntity addTaskMsg(McTaskMsgCrForm mcTaskMsgCrForm) throws MsgCenterException {
        if (ObjectUtil.isNotEmpty((Object)mcTaskMsgCrForm)) {
            String taskCode = mcTaskMsgCrForm.getTaskCode();
            if (StringUtils.isEmpty((String)taskCode)) {
                throw new MsgCenterException("taskCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String sendCode = mcTaskMsgCrForm.getSendCode();
            if (StringUtils.isEmpty((String)sendCode)) {
                throw new MsgCenterException("sendCode\u4e0d\u80fd\u4e3a\u7a7a");
            }
            McMsgSendEntity msgSendEntity = this.mcMsgSendService.getValidInfo(sendCode);
            if (ObjectUtil.isEmpty((Object)msgSendEntity)) {
                throw new MsgCenterException("sendCode\u4e0d\u5b58\u5728\u6216\u7981\u7528\uff0c\u8bf7\u786e\u5b9a\u53d1\u9001\u914d\u7f6e\u7f16\u7801");
            }
            if (StringUtils.isEmpty((String)mcTaskMsgCrForm.getBusinessKey())) {
                throw new MsgCenterException("\u4f7f\u7528\u6a21\u677f\uff0cbusinessKey\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!JsonUtil.isJSONString((String)mcTaskMsgCrForm.getBusinessKey())) {
                throw new MsgCenterException("parameterMap\u975ejson\u683c\u5f0f");
            }
            String toUserIds = mcTaskMsgCrForm.getToUserIds();
            String toDeptIds = mcTaskMsgCrForm.getToDeptIds();
            if (StringUtils.isEmpty((String)toUserIds) && StringUtils.isEmpty((String)toDeptIds)) {
                throw new MsgCenterException("\u65e0\u6548\u7684\u63a5\u6536\u4eba");
            }
            mcTaskMsgCrForm.setEnabledMark("1");
            McTaskMsgEntity entity = (McTaskMsgEntity)JsonUtil.getJsonToBean((Object)mcTaskMsgCrForm, McTaskMsgEntity.class);
            entity.setId(RandomUtil.uuId());
            this.save(entity);
            return entity;
        }
        throw new MsgCenterException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional
    public void sendTaskMsgReceive(McTaskMsgEntity entity) {
        String sendCode = entity.getSendCode();
        McMsgSendInfoVO sendInfoVO = this.mcMsgSendService.getInfoByEnCode(sendCode);
        List<McMsgSendTemplateModel> sendTemplateList = sendInfoVO.getSendTemplateList();
        if (CollectionUtil.isNotEmpty(sendTemplateList)) {
            this.saveContentAndReceive(entity, sendTemplateList);
            entity.setEnabledMark(2);
            this.updateById(entity);
            SendReceiveParam sendReceiveParam = new SendReceiveParam();
            sendReceiveParam.setCurrentUserInfo(this.userProvider.get());
            sendReceiveParam.setTaskMsg(entity);
            sendReceiveParam.setSendTemplateList(sendTemplateList);
            sendReceiveParam.setEnabledMark(0);
            this.threadPoolExecutor.execute(() -> {
                try {
                    this.mcTaskMsgReceiveService.postSendReceive(sendReceiveParam);
                }
                catch (Exception e) {
                    this.log.error("\u6d88\u606f\u4e2d\u5fc3-\u6839\u636etask_msg_receive\u6570\u636e\uff0c\u6e20\u9053\u6d88\u606f\u4e0b\u53d1\u5931\u8d25\uff0c\u5f02\u5e38\uff1a" + e.getMessage());
                }
            });
        } else {
            entity.setDescription("\u53d1\u9001\u914d\u7f6e-\u672a\u914d\u7f6e\u6e20\u9053\u6d88\u606f\u6a21\u677f");
            this.updateById(entity);
        }
    }

    private void saveContentAndReceive(McTaskMsgEntity taskMsg, List<McMsgSendTemplateModel> sendTemplateList) {
        List<String> orgIds;
        List<UserEntity> userList;
        if (ObjectUtil.isEmpty((Object)taskMsg) || CollectionUtil.isEmpty(sendTemplateList)) {
            return;
        }
        boolean allUsers = false;
        SetUtils.SetView userSet = new HashSet();
        String toUserIds = taskMsg.getToUserIds();
        if (StringUtils.isNotEmpty((String)toUserIds)) {
            if ("@ALL".equals(toUserIds)) {
                allUsers = true;
                List<String> listId = this.userService.getListId();
                userSet.addAll(listId);
            } else {
                String[] toUserArr = toUserIds.split(",");
                Collections.addAll(userSet, toUserArr);
            }
        }
        String toDeptIds = taskMsg.getToDeptIds();
        if (!allUsers && StringUtils.isNotEmpty((String)toDeptIds) && CollectionUtil.isNotEmpty(userList = this.userService.getUserByOrgIds(orgIds = Arrays.asList(toDeptIds.split(","))))) {
            Set deptUserSet = userList.stream().map(UserEntity::getId).collect(Collectors.toSet());
            userSet = SetUtils.union(userSet, (Set)deptUserSet);
        }
        HashMap<String, List<McTaskMsgReceiveEntity>> receiveMap = new HashMap<String, List<McTaskMsgReceiveEntity>>();
        HashMap<String, McTaskMsgContentEntity> contentMap = new HashMap<String, McTaskMsgContentEntity>();
        for (McMsgSendTemplateModel mcMsgSendTemplateModel : sendTemplateList) {
            AbstractMessageChannelStrategy strategy = this.strategyFactory.getStrategy(mcMsgSendTemplateModel.getMessageType());
            if (ObjectUtil.isEmpty((Object)strategy)) continue;
            strategy.processMessage(taskMsg, mcMsgSendTemplateModel, contentMap, receiveMap, (Set<String>)userSet);
        }
        ArrayList<McTaskMsgContentEntity> contentEntityList = new ArrayList<McTaskMsgContentEntity>();
        for (Object value : contentMap.values()) {
            contentEntityList.add((McTaskMsgContentEntity)value);
        }
        ArrayList arrayList = new ArrayList();
        for (List value : receiveMap.values()) {
            arrayList.addAll(value);
        }
        Integer autoAgainMaxNum = ObjectUtil.isEmpty((Object)taskMsg.getAutoAgainMaxNum()) ? 3 : taskMsg.getAutoAgainMaxNum();
        arrayList.stream().forEach(item -> item.setAutoAgainMaxNum(autoAgainMaxNum));
        this.mcTaskMsgContentService.saveBatch(contentEntityList);
        this.mcTaskMsgReceiveService.saveBatch(arrayList);
    }

    @Override
    public List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgPagination pagination) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            List<String> SendTimeList = pagination.getCreatorTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(McTaskMsgEntity::getCreatorTime, (Object)new Date(fir))).le(McTaskMsgEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        return this.mcTaskMsgMapper.selectGroupByEnabledMark((Wrapper)queryWrapper);
    }
}

