/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.msgcenter.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.dfa.FoundWord;
import cn.hutool.dfa.SensitiveProcessor;
import cn.hutool.dfa.WordTree;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.service.SysConfigService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class SensitiveWordUtil
implements ApplicationRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SensitiveWordUtil.class);
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private Executor threadPoolExecutor;
    private static WordTree sensitiveTree = new WordTree();

    public void run(ApplicationArguments args) {
        HashSet<String> sensitiveWords = new HashSet<String>();
        String systemFilePath = this.configValueUtil.getSystemFilePath();
        File file = FileUtil.file((String)(systemFilePath + File.separator + "sensitive_word.txt"));
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                sensitiveWords.add(line.trim());
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u654f\u611f\u8bcd\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        try {
            String keyValue;
            SysConfigEntity mcSensitive = this.sysConfigService.getConfigByKeyName("mcSensitive");
            if (ObjectUtil.isNotEmpty((Object)mcSensitive) && StringUtils.isNotEmpty((String)(keyValue = mcSensitive.getKeyValue()))) {
                JSONArray objects = JSONArray.parseArray((String)keyValue);
                objects.stream().forEach(s -> sensitiveWords.add(s.toString().trim()));
            }
        }
        catch (JSONException | BaseException e) {
            e.printStackTrace();
        }
        this.init(sensitiveWords, true);
        log.info("\u6d88\u606f\u4e2d\u5fc3-\u521d\u59cb\u5316\u654f\u611f\u8bcd\u5e93\u5b8c\u6bd5, \u5171" + sensitiveWords.size() + "\u4e2a\u654f\u611f\u8bcd");
    }

    public void init(Collection<String> sensitiveWords, boolean isAsync) {
        if (isAsync) {
            this.threadPoolExecutor.execute(() -> this.init(sensitiveWords));
        } else {
            this.init(sensitiveWords);
        }
    }

    public void init(Collection<String> sensitiveWords) {
        sensitiveTree.clear();
        sensitiveTree.addWords(sensitiveWords);
    }

    public static FoundWord getFoundFirstSensitive(String text) {
        return sensitiveTree.matchWord(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text) {
        return sensitiveTree.matchAllWords(text);
    }

    public static List<FoundWord> getFoundAllSensitive(String text, boolean isDensityMatch, boolean isGreedMatch) {
        return sensitiveTree.matchAllWords(text, -1, isDensityMatch, isGreedMatch);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch) {
        return SensitiveWordUtil.sensitiveFilter(text, isGreedMatch, null);
    }

    public static String sensitiveFilter(String text, boolean isGreedMatch, SensitiveProcessor sensitiveProcessor) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        TimeInterval timer = DateUtil.timer();
        List<FoundWord> foundWordList = SensitiveWordUtil.getFoundAllSensitive(text, false, isGreedMatch);
        if (CollectionUtil.isEmpty(foundWordList)) {
            return text;
        }
        TreeMap foundWordMap = new TreeMap();
        foundWordList.forEach(fw -> foundWordMap.put((Integer)fw.getStartIndex(), fw));
        StringBuilder textStringBuilder = new StringBuilder();
        int length = text.length();
        int currentIndex = 0;
        while (currentIndex < length) {
            Map.Entry entry = foundWordMap.ceilingEntry(currentIndex);
            if (entry == null) {
                textStringBuilder.append(text.substring(currentIndex));
                break;
            }
            FoundWord fw2 = (FoundWord)entry.getValue();
            textStringBuilder.append(text, currentIndex, (int)((Integer)fw2.getStartIndex()));
            textStringBuilder.append(sensitiveProcessor.process(fw2));
            currentIndex = (Integer)fw2.getEndIndex() + 1;
        }
        log.info("\u8fc7\u6ee4\u654f\u611f\u8bcd, \u8017\u65f6: " + timer.intervalMs() + "ms");
        return textStringBuilder.toString();
    }
}

