/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.DeleteMarkEnum;
import com.bringspring.common.base.EnabledMarkEnum;
import com.bringspring.common.base.GlobalMarkEnum;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.Pagination;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UpUtil;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.base.util.RemoveUtil;
import com.bringspring.system.permission.entity.GroupEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.OrganizeRelationEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.organize.OrganizeListVO;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.user.form.UserCrForm;
import com.bringspring.system.permission.model.user.form.UserResetPasswordForm;
import com.bringspring.system.permission.model.user.form.UserUpBatchForm;
import com.bringspring.system.permission.model.user.form.UserUpForm;
import com.bringspring.system.permission.model.user.mod.RangeElementModel;
import com.bringspring.system.permission.model.user.mod.UserByRoleModel;
import com.bringspring.system.permission.model.user.mod.UserIdModel;
import com.bringspring.system.permission.model.user.mod.UserSelectorModel;
import com.bringspring.system.permission.model.user.mod.UserUpBatchModel;
import com.bringspring.system.permission.model.user.mod.UsersByPositionModel;
import com.bringspring.system.permission.model.user.page.PageUser;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.model.user.vo.ImUserListVo;
import com.bringspring.system.permission.model.user.vo.RangeElementSelectorVO;
import com.bringspring.system.permission.model.user.vo.UserAllVO;
import com.bringspring.system.permission.model.user.vo.UserByRoleVO;
import com.bringspring.system.permission.model.user.vo.UserExportVO;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.model.user.vo.UserImportVO;
import com.bringspring.system.permission.model.user.vo.UserInfoVO;
import com.bringspring.system.permission.model.user.vo.UserListVO;
import com.bringspring.system.permission.model.user.vo.UserSelectorVO;
import com.bringspring.system.permission.service.GroupService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserCommonService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import com.bringspring.system.permission.util.PermissionUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u7528\u6237\u7ba1\u7406")
@RestController
@RequestMapping(value={"/api/permission/Users"})
public class UserController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private GroupService groupService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserCommonService userCommonService;
    @Autowired
    private Executor threadPoolExecutor;

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @GetMapping
    public ActionResult<PageListVO<UserListVO>> getList(PaginationUser pagination) {
        UserInfo userInfo = this.userProvider.get();
        List<UserEntity> userList = this.userService.getList(pagination, pagination.getOrganizeId(), false);
        ArrayList<UserListVO> list = new ArrayList<UserListVO>();
        for (UserEntity userEntity : userList) {
            UserListVO userVO = (UserListVO)JsonUtil.getJsonToBean((Object)userEntity, UserListVO.class);
            QueryWrapper roleQuery = new QueryWrapper();
            roleQuery.lambda().eq(UserRelationEntity::getUserId, (Object)userVO.getId());
            roleQuery.lambda().eq(UserRelationEntity::getObjectType, (Object)"Role");
            StringBuffer roleNameBuffer = new StringBuffer();
            for (UserRelationEntity ure : this.userRelationService.list((Wrapper)roleQuery)) {
                RoleEntity info = this.roleService.getInfo(ure.getObjectId());
                if (!StringUtils.isNotNull((Object)info)) continue;
                roleNameBuffer.append(info.getFullName() + ",");
            }
            userVO.setRoleName(roleNameBuffer.toString());
            if (userVO.getEnabledMark() != null && userVO.getEnabledMark() != 0 && Objects.nonNull(userEntity.getUnlockTime()) && userEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
            userVO.setOrganize(organizeStr);
            list.add(userVO);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u8d26\u53f7\u5bc6\u7801\u5b89\u5168\u5ba1\u8ba1\u7528\u6237\u5217\u8868\u5e26\u5206\u9875")
    @GetMapping(value={"/getAuditList"})
    public ActionResult<PageListVO<UserListVO>> getAuditList(PaginationUser pagination) throws BaseException {
        List<UserListVO> auditList = this.userService.getAuditList(pagination);
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(auditList, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u5458\u5de5\u7ba1\u7406\u6839\u636e\u6743\u9650\u83b7\u53d6\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/UserJurisdiction"})
    public ActionResult<PageListVO<UserListVO>> getUserDataPermissionList(@RequestBody @Valid PaginationUser pagination) {
        UserInfo userInfo = this.userProvider.get();
        List<UserEntity> userList = this.userService.getUserDataPermissionList(pagination);
        ArrayList<UserListVO> list = new ArrayList<UserListVO>();
        for (UserEntity userEntity : userList) {
            UserListVO userVO = (UserListVO)JsonUtil.getJsonToBean((Object)userEntity, UserListVO.class);
            if (!StringUtils.isNotEmpty((String)pagination.getOrganizeId())) continue;
            if (userVO.getEnabledMark() != null && userVO.getEnabledMark() != 0 && Objects.nonNull(userEntity.getUnlockTime()) && userEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
            userVO.setOrganize(organizeStr);
            list.add(userVO);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/authorizeAddressGetList"})
    public ActionResult<PageListVO<UserListVO>> authorizeAddressGetList(PaginationUser pagination) {
        UserInfo userInfo = this.userProvider.get();
        List<UserEntity> userList = this.userService.authorizeAddressGetList(pagination, pagination.getOrganizeId(), false);
        List<Object> list = new ArrayList();
        for (UserEntity userEntity : userList) {
            List arealist;
            if (ObjectUtil.isNotEmpty((Object)pagination.getAlreadyAuthorize()) && ObjectUtil.isNotEmpty((Object)(arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)userEntity.getId()))))) {
                List collect = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
                ArrayList<String> addressList = new ArrayList<String>();
                for (String s : collect) {
                    addressList.add(this.baseDataUtil.provinceData(s));
                }
                userEntity.setAddressList(StringUtils.join(addressList, (String)","));
            }
            if (userEntity.getRoleId().contains("361808523769679237")) {
                userEntity.setAreaManagerFlag("0");
            } else {
                userEntity.setAreaManagerFlag("1");
            }
            UserListVO userVO = (UserListVO)JsonUtil.getJsonToBean((Object)userEntity, UserListVO.class);
            if (userVO.getEnabledMark() != null && userVO.getEnabledMark() != 0 && Objects.nonNull(userEntity.getUnlockTime()) && userEntity.getUnlockTime().getTime() > System.currentTimeMillis()) {
                userVO.setEnabledMark(2);
            }
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
            userVO.setOrganize(organizeStr);
            list.add(userVO);
        }
        if (ObjectUtil.isNotEmpty((Object)pagination.getAlreadyAuthorize()) && ObjectUtil.isNotEmpty((Object)pagination.getAlreadyAuthorize()) && ObjectUtil.isNotEmpty(list)) {
            list = list.stream().sorted(Comparator.comparing(UserListVO::getAreaManagerFlag)).collect(Collectors.toList());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7528\u6237\u5217\u8868")
    @GetMapping(value={"/All"})
    public ActionResult<ListVO<UserAllVO>> getAllUsers(Pagination pagination) {
        List<UserEntity> list = this.userService.getList(pagination, null, false);
        List user = JsonUtil.getJsonToList(list, UserAllVO.class);
        ListVO vo = new ListVO();
        vo.setList(user);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="IM\u901a\u8baf\u83b7\u53d6\u7528\u6237")
    @GetMapping(value={"/ImUser"})
    public ActionResult<PageListVO<ImUserListVo>> getAllImUserUsers(Pagination pagination) {
        List<UserEntity> data = this.userService.getList(pagination, null, true);
        ArrayList<ImUserListVo> list = new ArrayList<ImUserListVo>();
        List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(data.stream().map(t -> t.getOrganizeId()).collect(Collectors.toList()));
        for (UserEntity entity : data) {
            ImUserListVo user = (ImUserListVo)JsonUtil.getJsonToBean((Object)entity, ImUserListVo.class);
            OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
            user.setDepartment(organize != null ? organize.getFullName() : "");
            user.setHeadIcon(entity.getHeadIcon());
            list.add(user);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)pagination, PaginationVO.class);
        return ActionResult.page(list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e0b\u62c9\u6846\u5217\u8868")
    @GetMapping(value={"/Selector"})
    public ActionResult<ListVO<UserSelectorVO>> selector() {
        List<OrganizeEntity> allOrganizeData = this.organizeService.getList();
        List organizeData = this.organizeService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List userData = this.userService.getList().stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark()))).collect(Collectors.toList());
        List treeList = JsonUtil.getJsonToList(organizeData, UserSelectorModel.class);
        for (UserSelectorModel entity1 : treeList) {
            if ("department".equals(entity1.getType())) {
                entity1.setIcon("icon-ym icon-ym-tree-department1");
                continue;
            }
            if (!"company".equals(entity1.getType())) continue;
            entity1.setIcon("icon-ym icon-ym-tree-organization3");
        }
        for (UserEntity entity : userData) {
            UserSelectorModel treeModel = new UserSelectorModel();
            treeModel.setId(entity.getId());
            treeModel.setParentId(entity.getOrganizeId());
            treeModel.setFullName(entity.getRealName());
            treeModel.setType("user");
            treeModel.setIcon("icon-ym icon-ym-tree-user2");
            treeList.add(treeModel);
        }
        List trees = TreeDotUtils.convertListToTreeDot((List)treeList);
        List listvo = JsonUtil.getJsonToList((Object)trees, UserSelectorVO.class);
        List entities = allOrganizeData.stream().filter(t -> "1".equals(String.valueOf(t.getEnabledMark())) && "-1".equals(t.getParentId())).collect(Collectors.toList());
        Iterator iterator = listvo.iterator();
        while (iterator.hasNext()) {
            UserSelectorVO userSelectorVO = (UserSelectorVO)iterator.next();
            for (OrganizeEntity entity : entities) {
                if (!entity.getId().equals(userSelectorVO.getParentId())) continue;
                iterator.remove();
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listvo);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/ImUser/Selector/{organizeId}"})
    public ActionResult<ListVO<UserSelectorVO>> imUserSelector(@PathVariable(value="organizeId") String organizeIdForm, @RequestBody Page page) {
        String organizeId = XSSEscape.escape((String)organizeIdForm);
        List<UserSelectorVO> jsonToList = new ArrayList();
        if (StringUtils.isNotEmpty((String)page.getKeyword())) {
            List<UserEntity> userList = this.userService.getList(page.getKeyword());
            List<String> organizeIds = userList.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
            List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(organizeIds);
            List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
            List<OrganizeEntity> companyList = this.organizeService.getOrganizeName(companyIds);
            organizeList.addAll(companyList);
            for (UserEntity entity : userList) {
                UserSelectorVO vo = (UserSelectorVO)JsonUtil.getJsonToBean((Object)entity, UserSelectorVO.class);
                vo.setId(entity.getId());
                vo.setParentId(entity.getOrganizeId());
                vo.setFullName(entity.getRealName());
                vo.setHeadIcon(entity.getHeadIcon());
                vo.setType("user");
                vo.setIcon("icon-ym icon-ym-tree-user2");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                if (ObjectUtil.isNotEmpty((Object)organize.getOrganizeId())) {
                    OrganizeEntity company = organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                    vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                }
                if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                    List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                    List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                    String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                    vo.setPositionName(positionNames);
                }
                jsonToList.add(vo);
            }
            ListVO vo = new ListVO();
            vo.setList(jsonToList);
            return ActionResult.success((Object)vo);
        }
        List collect = this.organizeService.getList().stream().filter(t -> t.getEnabledMark() == EnabledMarkEnum.ENABLE.getCode() && t.getDeleteMark() == DeleteMarkEnum.NOT_DELETE.getCode()).collect(Collectors.toList());
        if (!"0".equals(organizeId)) {
            List list = collect.stream().filter(t -> organizeId.equals(t.getId())).collect(Collectors.toList());
            if (list.size() > 0) {
                OrganizeEntity organizeEntity = (OrganizeEntity)list.get(0);
                List collect1 = collect.stream().filter(t -> t.getParentId().equals(organizeEntity.getId())).collect(Collectors.toList());
                for (OrganizeEntity entitys : collect1) {
                    UserSelectorVO vo = (UserSelectorVO)JsonUtil.getJsonToBean((Object)entitys, UserSelectorVO.class);
                    if ("department".equals(entitys.getCategory())) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                    } else if ("company".equals(entitys.getCategory())) {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    jsonToList.add(vo);
                    vo.setHasChildren(true);
                    vo.setIsLeaf(false);
                }
                List<UserEntity> userList = this.userService.getListByOrganizeId(organizeId, null);
                List<String> organizeIds = userList.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
                List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(organizeIds);
                List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
                List<OrganizeEntity> companyList = this.organizeService.getOrganizeName(companyIds);
                organizeList.addAll(companyList);
                for (UserEntity entity : userList) {
                    if ("0".equals(String.valueOf(entity.getEnabledMark()))) continue;
                    UserSelectorVO vo = (UserSelectorVO)JsonUtil.getJsonToBean((Object)entity, UserSelectorVO.class);
                    vo.setId(entity.getId());
                    vo.setParentId(organizeId);
                    vo.setFullName(entity.getRealName());
                    vo.setHeadIcon(entity.getHeadIcon());
                    vo.setType("user");
                    vo.setIcon("icon-ym icon-ym-tree-user2");
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setEnabledMark(1);
                    OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                    if (null != organize) {
                        OrganizeEntity company;
                        vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                        if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && null != (company = (OrganizeEntity)organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null))) {
                            vo.setCompanyName(null != company && StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                        List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                        List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                        String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                        vo.setPositionName(positionNames);
                    }
                    jsonToList.add(vo);
                }
            }
            ListVO vo = new ListVO();
            vo.setList(jsonToList);
            return ActionResult.success((Object)vo);
        }
        List organizeEntityList = collect.stream().filter(t -> "-1".equals(t.getParentId())).collect(Collectors.toList());
        jsonToList = JsonUtil.getJsonToList(organizeEntityList, UserSelectorVO.class);
        for (UserSelectorVO userSelectorVO : jsonToList) {
            userSelectorVO.setIcon("icon-ym icon-ym-tree-organization3");
            userSelectorVO.setHasChildren(true);
            userSelectorVO.setIsLeaf(false);
        }
        ListVO vo = new ListVO();
        vo.setList(jsonToList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u8303\u56f4\u9650\u5b9a\u524d\u7aef\u7ec4\u4ef6\u6570\u636e")
    @PostMapping(value={"/RangeElement/Selector/{tab}"})
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementSelector(@PathVariable String tab, @RequestBody Page page) {
        OrganizeEntity company;
        OrganizeEntity organize;
        OrganizeRelationEntity organizeRelation;
        List<OrganizeRelationEntity> relList;
        RangeElementSelectorVO vo;
        ArrayList<RangeElementSelectorVO> organizeUserList = new ArrayList<RangeElementSelectorVO>();
        List<OrganizeEntity> allOrganize = this.organizeService.getList();
        List<OrganizeEntity> companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        String keyword = page.getKeyword();
        if ("Organize".equals(tab)) {
            if (StringUtils.isNotEmpty((String)keyword)) {
                List organizeList = allOrganize.stream().filter(t -> t.getFullName().contains(keyword)).collect(Collectors.toList());
                for (OrganizeEntity organizeEntity : organizeList) {
                    vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)organizeEntity, RangeElementSelectorVO.class);
                    if ("department".equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                    } else if ("company".equals(vo.getType())) {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setEnabledMark(1);
                    if (StringUtils.isNotEmpty((String)vo.getCompanyId())) {
                        OrganizeEntity company2 = companyList.stream().filter(t -> t.getId().equals(vo.getCompanyId())).findFirst().orElse(null);
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company2.getShortName()) ? company2.getShortName() : company2.getFullName());
                    }
                    organizeUserList.add(vo);
                }
                List<UserEntity> userList = this.userService.getList(keyword);
                for (UserEntity entity : userList) {
                    RangeElementSelectorVO vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(entity.getId());
                    vo2.setParentId(entity.getOrganizeId());
                    vo2.setFullName(entity.getRealName());
                    vo2.setHeadIcon(entity.getHeadIcon());
                    vo2.setType("user");
                    vo2.setIcon("icon-ym icon-ym-tree-user2");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    OrganizeEntity organize3 = allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty((Object)organize3)) {
                        OrganizeEntity company3;
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize3.getShortName()) ? organize3.getShortName() : organize3.getFullName());
                        if (StringUtils.isNotEmpty((String)organize3.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company3 = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize3.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company3.getShortName()) ? company3.getShortName() : company3.getFullName());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                        List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                        List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                        String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                        vo2.setPositionName(positionNames);
                    }
                    organizeUserList.add(vo2);
                }
            } else {
                List<OrganizeListVO> organizeListTree = this.getOrganizeListTree("-1", allOrganize);
                List<UserEntity> allUser = this.userService.getList();
                if (CollectionUtil.isNotEmpty(organizeListTree)) {
                    List list = JsonUtil.getJsonToList(organizeListTree, RangeElementSelectorVO.class);
                    this.recursionSettingUser(list, allUser, companyList);
                    organizeUserList.addAll(list);
                }
            }
        }
        if ("Role".equals(tab)) {
            List<RoleEntity> roleList = this.roleService.getList(keyword);
            for (RoleEntity roleEntity : roleList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)roleEntity, RangeElementSelectorVO.class);
                vo.setId(roleEntity.getId());
                vo.setType("Role");
                vo.setIcon("icon-ym icon-ym-role");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                relList = this.organizeRelationService.getRelationListByRoleId(roleEntity.getId());
                OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if ("Position".equals(tab)) {
            List<PositionEntity> positionList = this.positionService.getList(keyword);
            for (PositionEntity positionEntity : positionList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)positionEntity, RangeElementSelectorVO.class);
                vo.setId(positionEntity.getId());
                vo.setType("Position");
                vo.setIcon("icon-ym icon-ym-position");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                relList = this.organizeRelationService.getRelationListByObjectIdAndType("Position", positionEntity.getId());
                OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                organizeUserList.add(vo);
            }
        }
        if ("Group".equals(tab)) {
            List<GroupEntity> groupList = this.groupService.list(keyword);
            for (GroupEntity groupEntity : groupList) {
                vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)groupEntity, RangeElementSelectorVO.class);
                vo.setId(groupEntity.getId());
                vo.setType("Group");
                vo.setIcon("icon-ym icon-ym-group");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                organizeUserList.add(vo);
            }
        }
        ListVO vo3 = new ListVO();
        vo3.setList(organizeUserList);
        return ActionResult.success((Object)vo3);
    }

    private List<OrganizeListVO> getOrganizeListTree(String parentId, List<OrganizeEntity> allOrganize) {
        List listByParentId = allOrganize.stream().filter(t -> t.getParentId().equals(parentId)).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(listByParentId)) {
            List listVO = JsonUtil.getJsonToList(listByParentId, OrganizeListVO.class);
            this.recursionOrganizeTree(listVO, allOrganize);
            return listVO;
        }
        return null;
    }

    private void recursionOrganizeTree(List<OrganizeListVO> returnList, List<OrganizeEntity> allOrganize) {
        returnList.stream().forEach(item -> {
            List listChild = allOrganize.stream().filter(t -> t.getParentId().equals(item.getId())).collect(Collectors.toList());
            if (ObjectUtil.isEmpty(listChild)) {
                return;
            }
            List listVO = JsonUtil.getJsonToList(listChild, OrganizeListVO.class);
            item.setChildren(listVO);
            this.recursionOrganizeTree(listVO, allOrganize);
        });
    }

    private void recursionSettingUser(List<RangeElementSelectorVO> organizeList, List<UserEntity> allUser, List<OrganizeEntity> companyList) {
        if (CollectionUtil.isNotEmpty(organizeList)) {
            for (RangeElementSelectorVO organizeVo : organizeList) {
                List<RangeElementSelectorVO> children;
                OrganizeEntity company;
                if (StringUtils.isNotEmpty((String)organizeVo.getCompanyId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organizeVo.getCompanyId())).findFirst().orElse(null)))) {
                    organizeVo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                }
                if (CollectionUtil.isNotEmpty(children = organizeVo.getChildren())) {
                    this.recursionSettingUser(children, allUser, companyList);
                    organizeVo.setHasChildren(true);
                } else {
                    organizeVo.setHasChildren(false);
                }
                if ("department".equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-department1");
                } else if ("company".equals(organizeVo.getType())) {
                    organizeVo.setIcon("icon-ym icon-ym-tree-organization3");
                }
                List userList = allUser.stream().filter(t -> organizeVo.getId().equals(t.getOrganizeId())).collect(Collectors.toList());
                if (CollectionUtil.isNotEmpty(userList)) {
                    organizeVo.getFullName();
                    if (CollectionUtil.isEmpty(children)) {
                        children = new ArrayList<RangeElementSelectorVO>();
                        organizeVo.setChildren(children);
                        organizeVo.setHasChildren(true);
                    }
                    ArrayList<RangeElementSelectorVO> userVoList = new ArrayList<RangeElementSelectorVO>();
                    for (UserEntity entity : userList) {
                        RangeElementSelectorVO vo = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                        vo.setId(entity.getId());
                        vo.setParentId(entity.getOrganizeId());
                        vo.setFullName(entity.getRealName());
                        vo.setHeadIcon(entity.getHeadIcon());
                        vo.setType("user");
                        vo.setIcon("icon-ym icon-ym-tree-user2");
                        vo.setHasChildren(false);
                        vo.setIsLeaf(true);
                        vo.setEnabledMark(1);
                        vo.setOrganizeName(organizeVo.getFullName());
                        vo.setCompanyName(organizeVo.getCompanyName());
                        if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                            List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                            List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                            String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                            vo.setPositionName(positionNames);
                        }
                        userVoList.add(vo);
                    }
                    children.addAll(0, userVoList);
                }
                organizeVo.setIsLeaf(organizeVo.getHasChildren() == false);
            }
        }
    }

    @Operation(summary="\u83b7\u53d6\u8303\u56f4\u9650\u5b9a\u524d\u7aef\u7ec4\u4ef6\u56de\u663e\u6570\u636e")
    @PostMapping(value={"/RangeElement/playback"})
    public ActionResult<ListVO<RangeElementSelectorVO>> rangeElementPlayback(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail((String)"selected\u4e3a\u7a7a");
        }
        ArrayList<RangeElementSelectorVO> organizeUserList = new ArrayList<RangeElementSelectorVO>();
        List<OrganizeEntity> allOrganize = this.organizeService.getList();
        List companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
        Map<String, Object> rangeElementSelected = this.userService.getRangeElementSelected(selected);
        for (Map.Entry<String, Object> entry : rangeElementSelected.entrySet()) {
            List groupList;
            List positionList;
            OrganizeEntity company;
            OrganizeEntity organize;
            OrganizeRelationEntity organizeRelation;
            List<OrganizeRelationEntity> relList;
            List roleList;
            List userList;
            List departmentList;
            RangeElementSelectorVO vo2;
            List companys;
            String type = entry.getKey();
            if ("company".equals(type) && CollectionUtil.isNotEmpty((Collection)(companys = (List)entry.getValue()))) {
                List companyVOList = JsonUtil.getJsonToList((Object)companys, RangeElementSelectorVO.class);
                for (RangeElementSelectorVO vo2 : companyVOList) {
                    vo2.setIcon("icon-ym icon-ym-tree-organization3");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                }
                organizeUserList.addAll(companyVOList);
            }
            if ("department".equals(type) && CollectionUtil.isNotEmpty((Collection)(departmentList = (List)entry.getValue()))) {
                List departmentVOList = JsonUtil.getJsonToList((Object)departmentList, RangeElementSelectorVO.class);
                for (RangeElementSelectorVO vo2 : departmentVOList) {
                    OrganizeEntity company2;
                    vo2.setIcon("icon-ym icon-ym-tree-department1");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    if (!StringUtils.isNotEmpty((String)vo2.getCompanyId()) || !ObjectUtil.isNotEmpty((Object)(company2 = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(vo2.getCompanyId())).findFirst().orElse(null)))) continue;
                    vo2.setCompanyName(StringUtils.isNotEmpty((String)company2.getShortName()) ? company2.getShortName() : company2.getFullName());
                }
                organizeUserList.addAll(departmentVOList);
            }
            if ("user".equals(type) && CollectionUtil.isNotEmpty((Collection)(userList = (List)entry.getValue()))) {
                for (Object entity : userList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((UserEntity)entity).getId());
                    vo2.setParentId(((UserEntity)entity).getOrganizeId());
                    vo2.setFullName(((UserEntity)entity).getRealName());
                    vo2.setHeadIcon(((UserEntity)entity).getHeadIcon());
                    vo2.setType("user");
                    vo2.setIcon("icon-ym icon-ym-tree-user2");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    OrganizeEntity organize2 = allOrganize.stream().filter(arg_0 -> UserController.lambda$rangeElementPlayback$29((UserEntity)entity, arg_0)).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty((Object)organize2)) {
                        OrganizeEntity company3;
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize2.getShortName()) ? organize2.getShortName() : organize2.getFullName());
                        if (StringUtils.isNotEmpty((String)organize2.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company3 = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize2.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company3.getShortName()) ? company3.getShortName() : company3.getFullName());
                        }
                    }
                    if (StringUtils.isNotEmpty((String)((UserEntity)entity).getPositionId())) {
                        List<String> positionIds = Arrays.asList(((UserEntity)entity).getPositionId().split(","));
                        List<PositionEntity> positionList2 = this.positionService.getPositionList(positionIds);
                        String positionNames = positionList2.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                        vo2.setPositionName(positionNames);
                    }
                    organizeUserList.add(vo2);
                }
            }
            if ("Role".equals(type) && CollectionUtil.isNotEmpty((Collection)(roleList = (List)entry.getValue()))) {
                for (Object entity : roleList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((PermissionEntityBase)entity).getId());
                    vo2.setType("Role");
                    vo2.setIcon("icon-ym icon-ym-role");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    relList = this.organizeRelationService.getRelationListByRoleId(((PermissionEntityBase)entity).getId());
                    OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                    if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                        if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                        }
                    }
                    organizeUserList.add(vo2);
                }
            }
            if ("Position".equals(type) && CollectionUtil.isNotEmpty((Collection)(positionList = (List)entry.getValue()))) {
                for (Object entity : positionList) {
                    vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                    vo2.setId(((PermissionEntityBase)entity).getId());
                    vo2.setType("Position");
                    vo2.setIcon("icon-ym icon-ym-position");
                    vo2.setHasChildren(false);
                    vo2.setIsLeaf(true);
                    vo2.setEnabledMark(1);
                    relList = this.organizeRelationService.getRelationListByObjectIdAndType("Position", ((PermissionEntityBase)entity).getId());
                    OrganizeRelationEntity organizeRelationEntity = organizeRelation = CollectionUtil.isEmpty(relList) ? null : relList.get(0);
                    if (ObjectUtil.isNotEmpty((Object)organizeRelation) && ObjectUtil.isNotEmpty((Object)(organize = (OrganizeEntity)allOrganize.stream().filter(t -> t.getId().equals(organizeRelation.getOrganizeId())).findFirst().orElse(null)))) {
                        vo2.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                        if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                            vo2.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                        }
                    }
                    organizeUserList.add(vo2);
                }
            }
            if (!"Group".equals(type) || !CollectionUtil.isNotEmpty((Collection)(groupList = (List)entry.getValue()))) continue;
            for (Object entity : groupList) {
                vo2 = (RangeElementSelectorVO)JsonUtil.getJsonToBean((Object)entity, RangeElementSelectorVO.class);
                vo2.setId(((GroupEntity)entity).getId());
                vo2.setType("Group");
                vo2.setIcon("icon-ym icon-ym-group");
                vo2.setHasChildren(false);
                vo2.setIsLeaf(true);
                vo2.setEnabledMark(1);
                organizeUserList.add(vo2);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(organizeUserList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4e0b\u62c9\u6846\u5217\u8868(\u9650\u5b9a\u8303\u56f4\u7684)")
    @PostMapping(value={"/RangeElement/User/Selector"})
    public ActionResult<ListVO<UserSelectorVO>> rangeElementUserSelector(@RequestBody List<RangeElementModel> selected) {
        if (CollectionUtil.isEmpty(selected)) {
            return ActionResult.fail((String)"selected\u4e3a\u7a7a");
        }
        ArrayList<UserSelectorVO> listvo = new ArrayList<UserSelectorVO>();
        List<UserEntity> userData = this.userService.getRangeElementUserList(selected);
        if (CollectionUtil.isNotEmpty(userData)) {
            List<OrganizeEntity> allOrganize = this.organizeService.getList();
            List companyList = allOrganize.stream().filter(t -> "company".equals(t.getCategory())).collect(Collectors.toList());
            for (UserEntity entity : userData) {
                UserSelectorVO vo = (UserSelectorVO)JsonUtil.getJsonToBean((Object)entity, UserSelectorVO.class);
                vo.setId(entity.getId());
                vo.setParentId(entity.getOrganizeId());
                vo.setFullName(entity.getRealName());
                vo.setHeadIcon(entity.getHeadIcon());
                vo.setType("user");
                vo.setIcon("icon-ym icon-ym-tree-user2");
                vo.setHasChildren(false);
                vo.setIsLeaf(true);
                vo.setEnabledMark(1);
                OrganizeEntity organize = allOrganize.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)organize)) {
                    OrganizeEntity company;
                    vo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                    if (StringUtils.isNotEmpty((String)organize.getOrganizeId()) && ObjectUtil.isNotEmpty((Object)(company = (OrganizeEntity)companyList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null)))) {
                        vo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                    }
                }
                if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                    List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                    List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                    String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                    vo.setPositionName(positionNames);
                }
                listvo.add(vo);
            }
        }
        ListVO vo = new ListVO();
        vo.setList(listvo);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/{id}"})
    public ActionResult<UserInfoVO> getInfo(@PathVariable(value="id") String id) throws DataException {
        UserEntity entity = this.userService.getInfo(id);
        if (entity == null) {
            return ActionResult.fail((String)"\u7528\u6237\u4e0d\u5b58\u5728");
        }
        List arealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"Area")).eq(UserRelationEntity::getUserId, (Object)entity.getId()));
        ArrayList<List<String>> addrList = new ArrayList<List<String>>();
        if (ObjectUtil.isNotEmpty((Object)arealist)) {
            List collect = arealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            collect.stream().forEach(item -> {
                ArrayList<String> stringList = new ArrayList<String>();
                String[] split = item.replace("[", "").replace("]", "").replaceAll("\"", "").split(",");
                stringList.addAll(Arrays.asList(split));
                addrList.add(stringList);
            });
        }
        List afterArealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"AfterArea")).eq(UserRelationEntity::getUserId, (Object)entity.getId()));
        ArrayList<List<String>> afterAddrList = new ArrayList<List<String>>();
        if (ObjectUtil.isNotEmpty((Object)afterArealist)) {
            List collect = afterArealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            collect.stream().forEach(item -> {
                ArrayList<String> stringList = new ArrayList<String>();
                String[] split = item.replace("[", "").replace("]", "").replaceAll("\"", "").split(",");
                stringList.addAll(Arrays.asList(split));
                afterAddrList.add(stringList);
            });
        }
        List executeArealist = this.userRelationService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserRelationEntity::getObjectType, (Object)"ExecuteArea")).eq(UserRelationEntity::getUserId, (Object)entity.getId()));
        ArrayList<List<String>> executeAddrList = new ArrayList<List<String>>();
        if (ObjectUtil.isNotEmpty((Object)executeArealist)) {
            List collect = executeArealist.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
            collect.stream().forEach(item -> {
                ArrayList<String> stringList = new ArrayList<String>();
                String[] split = item.replace("[", "").replace("]", "").replaceAll("\"", "").split(",");
                stringList.addAll(Arrays.asList(split));
                executeAddrList.add(stringList);
            });
        }
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.lambda().eq(UserRelationEntity::getUserId, (Object)id);
        roleQuery.lambda().eq(UserRelationEntity::getObjectType, (Object)"Role");
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (UserRelationEntity ure : this.userRelationService.list((Wrapper)roleQuery)) {
            roleIdList.add(ure.getObjectId());
        }
        UserInfoVO vo = JsonUtilEx.getJsonToBeanEx(entity, UserInfoVO.class);
        vo.setRoleId(String.join((CharSequence)",", roleIdList));
        QueryWrapper query = new QueryWrapper();
        query.lambda().eq(UserRelationEntity::getUserId, (Object)id);
        query.lambda().eq(UserRelationEntity::getObjectType, (Object)"Organize");
        ArrayList<String> organizeIds = new ArrayList<String>();
        this.userRelationService.list((Wrapper)query).forEach(u -> organizeIds.add(u.getObjectId()));
        QueryWrapper positionQuery = new QueryWrapper();
        positionQuery.lambda().eq(UserRelationEntity::getUserId, (Object)id);
        positionQuery.lambda().eq(UserRelationEntity::getObjectType, (Object)"Position");
        Object positionIds = "";
        for (UserRelationEntity ure : this.userRelationService.list((Wrapper)positionQuery)) {
            PositionEntity info = this.positionService.getInfo(ure.getObjectId());
            if (info == null) continue;
            positionIds = (String)positionIds + "," + ure.getObjectId();
        }
        if (((String)positionIds).length() > 0) {
            vo.setPositionId(((String)positionIds).substring(1));
        } else {
            vo.setPositionId(null);
        }
        List<UserRelationEntity> listByObjectType = this.userRelationService.getListByObjectType(entity.getId(), "Group");
        StringBuilder groupId = new StringBuilder();
        listByObjectType.stream().forEach(t -> groupId.append("," + t.getObjectId()));
        if (groupId.length() > 0) {
            vo.setGroupId(groupId.toString().replaceFirst(",", ""));
        }
        vo.setOrganizeIdTree(PermissionUtil.getOrgIdsTree(organizeIds, 1, this.organizeService));
        String majorOrgId = entity.getOrganizeId();
        List<PermissionModel> permissionModels = this.userRelationService.setModel(this.organizeService.getOrgEntityList(organizeIds, false), majorOrgId);
        permissionModels.forEach(p -> p.setFullName(PermissionUtil.getLinkInfoByOrgId(p.getId(), this.organizeService, true)));
        vo.setOrganizeNames(permissionModels);
        vo.setAuthorizeAddress(addrList);
        vo.setAfterAuthorizeAddress(afterAddrList);
        vo.setExecuteAddress(executeAddrList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/getSimpleInfo/{id}"})
    public ActionResult<UserEntity> getSimpleInfo(@PathVariable(value="id") String id) throws DataException {
        UserEntity info = this.userService.getInfo(id);
        return ActionResult.success((Object)info);
    }

    @Operation(summary="\u65b0\u5efa\u7528\u6237")
    @PostMapping
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u65b0\u5efa\u7528\u6237")
    public ActionResult<String> create(@RequestBody @Valid UserCrForm userCrForm) throws Exception {
        UserEntity entity = (UserEntity)JsonUtil.getJsonToBean((Object)userCrForm, UserEntity.class);
        this.userService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237")
    @PutMapping(value={"/{id}"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u4fee\u6539\u7528\u6237")
    public ActionResult<String> update(@PathVariable(value="id") String id, @RequestBody @Valid UserUpForm userUpForm) throws Exception {
        UserEntity entity = (UserEntity)JsonUtil.getJsonToBean((Object)userUpForm, UserEntity.class);
        boolean flag = this.userService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u5220\u9664\u7528\u6237")
    @DeleteMapping(value={"/{id}"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u5220\u9664\u7528\u6237")
    public ActionResult<String> delete(@PathVariable(value="id") String id) throws Exception {
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            this.userService.delete(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u903b\u8f91\u5220\u9664\u7528\u6237")
    @DeleteMapping(value={"/deleteByLogical/{id}"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u903b\u8f91\u5220\u9664\u7528\u6237")
    public ActionResult<String> deleteByLogical(@PathVariable(value="id") String id) throws Exception {
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            this.userService.deleteByLogical(entity);
            return ActionResult.success((String)MsgCode.SU003.get());
        }
        return ActionResult.fail((String)MsgCode.FA003.get());
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/{id}/Actions/ResetPassword"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    public ActionResult<String> modifyPassword(@PathVariable(value="id") String id, @RequestBody @Valid UserResetPasswordForm userResetPasswordForm) {
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            entity.setPassword(userResetPasswordForm.getUserPassword());
            this.userService.updatePassword(entity);
            this.userProvider.removeOnLine(entity.getId());
            RemoveUtil.removeOnline(entity.getId());
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.success((String)"\u64cd\u4f5c\u5931\u8d25,\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @Operation(summary="\u66f4\u65b0\u7528\u6237\u72b6\u6001")
    @PutMapping(value={"/{id}/Actions/State"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u66f4\u65b0\u7528\u6237\u72b6\u6001")
    public ActionResult<String> disable(@PathVariable(value="id") String id) throws Exception {
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            if ("1".equals(String.valueOf(entity.getIsAdministrator()))) {
                return ActionResult.fail((String)"\u65e0\u6cd5\u4fee\u6539\u7ba1\u7406\u5458\u8d26\u6237\u72b6\u6001");
            }
            if (entity.getEnabledMark() != null) {
                if ("1".equals(String.valueOf(entity.getEnabledMark()))) {
                    entity.setEnabledMark(0);
                    this.userProvider.removeOnLine(entity.getId());
                    RemoveUtil.removeOnline(entity.getId());
                    this.userService.update(id, entity);
                } else {
                    entity.setEnabledMark(1);
                    this.userService.update(id, entity);
                }
            } else {
                entity.setEnabledMark(1);
                this.userService.update(id, entity);
            }
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.success((String)"\u64cd\u4f5c\u5931\u8d25,\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @Operation(summary="\u89e3\u9664\u9501\u5b9a")
    @PutMapping(value={"/{id}/Actions/unlock"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u89e3\u9664\u9501\u5b9a")
    public ActionResult<String> unlock(@PathVariable(value="id") String id) throws Exception {
        UserEntity entity = this.userService.getInfo(id);
        if (entity != null) {
            entity.setEnabledMark(1);
            entity.setUnlockTime(null);
            entity.setLogErrorCount(0);
            entity.setId(id);
            this.userService.update(entity);
            return ActionResult.success((String)MsgCode.SU005.get());
        }
        return ActionResult.success((String)"\u64cd\u4f5c\u5931\u8d25,\u7528\u6237\u4e0d\u5b58\u5728");
    }

    @Operation(summary="\u83b7\u53d6\u7528\u6237\u57fa\u672c\u4fe1\u606f")
    @PostMapping(value={"/getUserList"})
    public ActionResult<ListVO<UserIdListVo>> getUserList(@RequestBody UserIdModel userIdModel) {
        ArrayList<UserIdListVo> list = new ArrayList<UserIdListVo>();
        List<UserEntity> userByIds = this.userService.getUserByIds(userIdModel.getUserId());
        List<String> organizeIds = userByIds.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(organizeIds);
        List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> companyList = this.organizeService.getOrganizeName(companyIds);
        organizeList.addAll(companyList);
        for (UserEntity userEntity : userByIds) {
            if ("0".equals(String.valueOf(userEntity.getEnabledMark()))) continue;
            UserIdListVo userListVo = (UserIdListVo)JsonUtil.getJsonToBean((Object)userEntity, UserIdListVo.class);
            OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(userEntity.getOrganizeId())).findFirst().orElse(null);
            if (ObjectUtil.isNotEmpty((Object)organize)) {
                userListVo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                OrganizeEntity company = organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)company)) {
                    userListVo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                }
            }
            if (StringUtils.isNotEmpty((String)userEntity.getPositionId())) {
                List<String> positionIds = Arrays.asList(userEntity.getPositionId().split(","));
                List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                userListVo.setPositionName(positionNames);
            }
            list.add(userListVo);
        }
        ListVO listVO = new ListVO();
        listVO.setList(list);
        return ActionResult.success((Object)listVO);
    }

    @Operation(summary="\u83b7\u53d6\u7ec4\u7ec7\u4e0b\u7684\u4eba\u5458")
    @GetMapping(value={"/getOrganization"})
    public ActionResult getOrganization(PageUser page) {
        String departmentId = page.getOrganizeId();
        if ("0".equals(departmentId) && StringUtils.isEmpty((String)(departmentId = this.userProvider.get().getDepartmentId()))) {
            departmentId = this.userProvider.get().getOrganizeId();
        }
        List<UserEntity> userList = this.userService.getListByOrganizeId(departmentId, page.getKeyword());
        List<String> organizeIds = userList.stream().map(UserEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> organizeList = this.organizeService.getOrganizeName(organizeIds);
        List<String> companyIds = organizeList.stream().map(OrganizeEntity::getOrganizeId).collect(Collectors.toList());
        List<OrganizeEntity> companyList = this.organizeService.getOrganizeName(companyIds);
        organizeList.addAll(companyList);
        ArrayList<UserIdListVo> jsonToList = new ArrayList<UserIdListVo>();
        for (UserEntity entity : userList) {
            if ("0".equals(String.valueOf(entity.getEnabledMark()))) continue;
            UserIdListVo userListVo = (UserIdListVo)JsonUtil.getJsonToBean((Object)entity, UserIdListVo.class);
            OrganizeEntity organize = organizeList.stream().filter(t -> t.getId().equals(entity.getOrganizeId())).findFirst().orElse(null);
            if (ObjectUtil.isNotEmpty((Object)organize)) {
                userListVo.setOrganizeName(StringUtils.isNotEmpty((String)organize.getShortName()) ? organize.getShortName() : organize.getFullName());
                OrganizeEntity company = organizeList.stream().filter(t -> t.getId().equals(organize.getOrganizeId())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)company)) {
                    userListVo.setCompanyName(StringUtils.isNotEmpty((String)company.getShortName()) ? company.getShortName() : company.getFullName());
                }
            }
            if (StringUtils.isNotEmpty((String)entity.getPositionId())) {
                List<String> positionIds = Arrays.asList(entity.getPositionId().split(","));
                List<PositionEntity> positionList = this.positionService.getPositionList(positionIds);
                String positionNames = positionList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(","));
                userListVo.setPositionName(positionNames);
            }
            jsonToList.add(userListVo);
        }
        return ActionResult.success(jsonToList);
    }

    @Operation(summary="\u83b7\u53d6\u5c97\u4f4d\u4eba\u5458")
    @GetMapping(value={"/GetUsersByPositionId"})
    public ActionResult<List<UserByRoleVO>> getUsersByPositionId(UsersByPositionModel page) {
        ArrayList<UserByRoleVO> list = new ArrayList<UserByRoleVO>(1);
        String keyword = page.getKeyword();
        String positionId = page.getPositionId();
        List<OrganizeRelationEntity> relationListByObjectIdAndType = this.organizeRelationService.getRelationListByObjectIdAndType("Position", positionId);
        if (relationListByObjectIdAndType.size() == 1) {
            UserByRoleVO vo = new UserByRoleVO();
            String organizeId = relationListByObjectIdAndType.get(0).getOrganizeId();
            OrganizeEntity organizeEntity = this.organizeService.getInfo(organizeId);
            if (Objects.nonNull(organizeEntity)) {
                vo.setId(organizeEntity.getId());
                vo.setType(organizeEntity.getCategory());
                if ("department".equals(organizeEntity.getCategory())) {
                    vo.setIcon("icon-ym icon-ym-tree-department1");
                } else {
                    vo.setIcon("icon-ym icon-ym-tree-organization3");
                }
                vo.setEnabledMark(organizeEntity.getEnabledMark());
                String orgName = this.organizeService.getFullNameByOrgIdTree(organizeEntity.getOrganizeIdTree(), "/");
                vo.setFullName(orgName);
                ArrayList<UserByRoleVO> userByRoleVOS = new ArrayList<UserByRoleVO>(16);
                List<UserEntity> lists = this.userService.getListByOrganizeId(organizeEntity.getId(), keyword);
                if (lists.size() > 0) {
                    vo.setHasChildren(true);
                    vo.setIsLeaf(false);
                    lists.stream().forEach(t -> {
                        UserByRoleVO userByRoleVO = new UserByRoleVO();
                        userByRoleVO.setParentId(organizeEntity.getId());
                        userByRoleVO.setId(t.getId());
                        userByRoleVO.setFullName(t.getRealName());
                        userByRoleVO.setEnabledMark(t.getEnabledMark());
                        userByRoleVO.setIsLeaf(true);
                        userByRoleVO.setHasChildren(false);
                        userByRoleVO.setIcon("icon-ym icon-ym-tree-user2");
                        userByRoleVO.setType("user");
                        userByRoleVOS.add(userByRoleVO);
                    });
                    vo.setChildren(userByRoleVOS);
                } else {
                    vo.setHasChildren(false);
                    vo.setIsLeaf(true);
                    vo.setChildren(new ArrayList<UserByRoleVO>());
                }
                list.add(vo);
            }
        }
        return ActionResult.success(list);
    }

    @Operation(summary="\u89d2\u8272\u6210\u5458\u5f39\u7a97")
    @GetMapping(value={"/GetUsersByRoleOrgId"})
    public ActionResult<List<UserByRoleVO>> getUsersByRoleOrgId(UserByRoleModel model) {
        ArrayList<UserByRoleVO> jsonToList = new ArrayList<UserByRoleVO>(16);
        List<OrganizeRelationEntity> relationListByRoleId = this.organizeRelationService.getRelationListByRoleId(model.getRoleId());
        List<OrganizeEntity> orgEntityList = this.organizeService.getOrgEntityList(relationListByRoleId.stream().map(OrganizeRelationEntity::getOrganizeId).collect(Collectors.toList()), true);
        if (StringUtils.isNotEmpty((String)model.getKeyword())) {
            List<UserEntity> list = this.userService.getList(orgEntityList.stream().map(OrganizeEntity::getId).collect(Collectors.toList()), model.getKeyword());
            for (UserEntity entity : list) {
                UserByRoleVO vo = new UserByRoleVO();
                vo.setId(entity.getId());
                vo.setFullName(entity.getRealName());
                vo.setEnabledMark(entity.getEnabledMark());
                vo.setIsLeaf(true);
                vo.setHasChildren(false);
                vo.setIcon("icon-ym icon-ym-tree-user2");
                vo.setType("user");
                jsonToList.add(vo);
            }
            return ActionResult.success(jsonToList);
        }
        List collect = this.organizeService.getList().stream().filter(t -> t.getEnabledMark() == 1).collect(Collectors.toList());
        if (!"0".equals(model.getOrganizeId())) {
            List list = collect.stream().filter(t -> model.getOrganizeId().equals(t.getId())).collect(Collectors.toList());
            if (list.size() > 0) {
                OrganizeEntity organizeEntity = (OrganizeEntity)list.get(0);
                List collect1 = collect.stream().filter(t -> t.getParentId().equals(organizeEntity.getId())).collect(Collectors.toList());
                ArrayList organizeEntities = new ArrayList();
                for (OrganizeEntity entity : collect1) {
                    List collect2 = relationListByRoleId.stream().filter(t -> entity.getId().equals(t.getOrganizeId())).collect(Collectors.toList());
                    collect2.stream().forEach(t -> {
                        if (StringUtils.isNotEmpty((String)t.getOrganizeId())) {
                            organizeEntities.add(this.organizeService.getInfo(t.getOrganizeId()));
                        }
                    });
                }
                List collect2 = relationListByRoleId.stream().filter(item -> !organizeEntities.stream().map(e -> e.getId()).collect(Collectors.toList()).contains(item.getOrganizeId())).collect(Collectors.toList());
                List collect3 = collect2.stream().filter(t -> !Arrays.asList(this.organizeService.getInfo(t.getOrganizeId()).getOrganizeIdTree().split(",")).contains(model.getOrganizeId())).collect(Collectors.toList());
                collect2.removeAll(collect3);
                List collect4 = collect2.stream().filter(t -> !t.getOrganizeId().equals(model.getOrganizeId())).collect(Collectors.toList());
                List collect5 = collect.stream().filter(x -> collect4.stream().map(d -> d.getOrganizeId()).collect(Collectors.toList()).contains(x.getId())).collect(Collectors.toList());
                ArrayList organizeEntities1 = new ArrayList(collect5);
                for (Object entity : collect5) {
                    for (OrganizeEntity organizeEntity1 : organizeEntities) {
                        if (!((OrganizeEntity)entity).getOrganizeIdTree().contains(organizeEntity1.getId())) continue;
                        organizeEntities1.remove(entity);
                    }
                }
                List<UserEntity> entityList = this.userService.getListByOrganizeId(model.getOrganizeId(), null);
                for (UserEntity entity : entityList) {
                    UserByRoleVO vo = new UserByRoleVO();
                    vo.setId(entity.getId());
                    vo.setFullName(entity.getRealName());
                    vo.setEnabledMark(entity.getEnabledMark());
                    vo.setIsLeaf(true);
                    vo.setHasChildren(false);
                    vo.setIcon("icon-ym icon-ym-tree-user2");
                    vo.setType("user");
                    jsonToList.add(vo);
                }
                ArrayList organizeEntities2 = new ArrayList(collect5);
                for (OrganizeEntity entity : organizeEntities2) {
                    List collect6 = organizeEntities2.stream().filter(t -> !entity.getId().equals(t.getId()) && t.getOrganizeIdTree().contains(entity.getOrganizeIdTree())).collect(Collectors.toList());
                    organizeEntities1.removeAll(collect6);
                }
                for (OrganizeEntity entity : organizeEntities1) {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] split = entity.getOrganizeIdTree().split(",");
                    List<String> list1 = Arrays.asList(split);
                    ArrayList<String> list2 = new ArrayList<String>(list1);
                    for (int indexOf = list2.indexOf(model.getOrganizeId()); indexOf >= 0; --indexOf) {
                        list2.remove(indexOf);
                    }
                    StringBuffer organizeIdTree = new StringBuffer();
                    for (String parentId : list2) {
                        OrganizeEntity organizes = this.organizeService.getInfo(parentId);
                        if (!Objects.nonNull(organizes) || !StringUtils.isNotEmpty((String)organizes.getFullName())) continue;
                        organizeIdTree.append("/" + organizes.getFullName());
                    }
                    String toString = organizeIdTree.toString();
                    if (StringUtils.isNotEmpty((String)toString)) {
                        String organizeId = toString.replaceFirst("/", "");
                        stringBuffer.append("," + organizeId);
                    }
                    UserByRoleVO userByRoleVO = new UserByRoleVO();
                    userByRoleVO.setId(entity.getId());
                    userByRoleVO.setType(entity.getCategory());
                    userByRoleVO.setFullName(stringBuffer.toString().replace(",", ""));
                    if ("department".equals(entity.getCategory())) {
                        userByRoleVO.setIcon("icon-ym icon-ym-tree-department1");
                    } else {
                        userByRoleVO.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    userByRoleVO.setHasChildren(true);
                    userByRoleVO.setIsLeaf(false);
                    userByRoleVO.setEnabledMark(entity.getEnabledMark());
                    jsonToList.add(userByRoleVO);
                }
                for (OrganizeEntity entitys : organizeEntities) {
                    UserByRoleVO vo = new UserByRoleVO();
                    vo.setId(entitys.getId());
                    vo.setType(entitys.getCategory());
                    vo.setFullName(entitys.getFullName());
                    if ("department".equals(entitys.getCategory())) {
                        vo.setIcon("icon-ym icon-ym-tree-department1");
                    } else {
                        vo.setIcon("icon-ym icon-ym-tree-organization3");
                    }
                    vo.setHasChildren(true);
                    vo.setIsLeaf(false);
                    vo.setEnabledMark(entitys.getEnabledMark());
                    jsonToList.add(vo);
                }
            }
            return ActionResult.success(jsonToList);
        }
        HashSet set = new HashSet(16);
        for (OrganizeEntity entity : orgEntityList) {
            List collect1 = orgEntityList.stream().filter(t -> !entity.getId().equals(t.getId()) && entity.getOrganizeIdTree().contains(t.getOrganizeIdTree())).collect(Collectors.toList());
            set.addAll(collect1);
        }
        ArrayList<OrganizeEntity> list = new ArrayList<OrganizeEntity>(set);
        ArrayList list1 = new ArrayList(list);
        for (OrganizeEntity organizeEntity : list) {
            List collect1 = list.stream().filter(t -> !organizeEntity.getId().equals(t.getId()) && t.getOrganizeIdTree().contains(organizeEntity.getId())).collect(Collectors.toList());
            list1.removeAll(collect1);
        }
        list = list1;
        ArrayList<OrganizeEntity> list2 = new ArrayList<OrganizeEntity>(orgEntityList);
        for (OrganizeEntity organizeEntity : orgEntityList) {
            if (list.stream().filter(t -> organizeEntity.getOrganizeIdTree().contains(t.getId())).count() <= 0L) continue;
            list2.remove(organizeEntity);
        }
        list.addAll(list2);
        for (OrganizeEntity organizeEntity : list) {
            if (organizeEntity == null || organizeEntity.getEnabledMark() != 1) continue;
            UserByRoleVO userByRoleVO = new UserByRoleVO();
            userByRoleVO.setId(organizeEntity.getId());
            userByRoleVO.setType(organizeEntity.getCategory());
            String orgName = this.organizeService.getFullNameByOrgIdTree(organizeEntity.getOrganizeIdTree(), "/");
            userByRoleVO.setFullName(orgName);
            if ("department".equals(organizeEntity.getCategory())) {
                userByRoleVO.setIcon("icon-ym icon-ym-tree-department1");
            } else {
                userByRoleVO.setIcon("icon-ym icon-ym-tree-organization3");
            }
            userByRoleVO.setHasChildren(true);
            userByRoleVO.setIsLeaf(false);
            userByRoleVO.setEnabledMark(organizeEntity.getEnabledMark());
            jsonToList.add(userByRoleVO);
        }
        return ActionResult.success(jsonToList);
    }

    @Operation(summary="\u83b7\u53d6\u6211\u7684\u4e0b\u5c5e(\u4e0d\u53d6\u5b50\u96c6)")
    @PostMapping(value={"/getSubordinates"})
    public ActionResult<List<UserIdListVo>> getSubordinates(@RequestBody Page page) {
        List<UserIdListVo> subordinatesUserList = this.userService.getListByManagerId(this.userProvider.get().getUserId(), page.getKeyword());
        return ActionResult.success(subordinatesUserList);
    }

    @GetMapping(value={"/getCommonList"})
    public ActionResult listCommon() {
        List<UserIdListVo> userIdListVos = this.userCommonService.getList();
        return ActionResult.success(userIdListVos);
    }

    @PutMapping(value={"/updateCommon"})
    public ActionResult updateCommon(@RequestBody UserIdModel userIdModel) throws DataException {
        this.userCommonService.update(userIdModel.getUserId());
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/deleteCommon/{userId}"})
    public ActionResult deleteCommon(@PathVariable(value="userId") String userId) {
        this.userCommonService.delete(userId);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @Operation(summary="\u5bfc\u51faexcel")
    @GetMapping(value={"/ExportExcel"})
    public ActionResult<DownloadVO> Export(String dataType, String selectKey, PaginationUser pagination) {
        DownloadVO vo = this.userService.exportExcel(dataType, selectKey, pagination);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/TemplateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u7528\u6237\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u7528\u6237\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:" + e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/ImportData"})
    public ActionResult<UserImportVO> ImportData(@RequestBody UserExportVO data) throws PermissionException {
        List dataList = JsonUtil.getJsonToList(data.getList(), UserExportVO.class);
        UserImportVO result = this.userService.importData(dataList);
        return ActionResult.success((Object)result);
    }

    @Operation(summary="\u5bfc\u51fa\u9519\u8bef\u62a5\u544a")
    @PostMapping(value={"/ExportExceptionData"})
    public ActionResult<DownloadVO> exportExceptionData(@RequestBody UserExportVO data) {
        List dataList = JsonUtil.getJsonToList(data.getList(), UserExportVO.class);
        DownloadVO vo = this.userService.exportExceptionData(dataList);
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6")
    @PostMapping(value={"/Uploader"})
    public ActionResult<Object> Uploader() {
        List list = UpUtil.getFileAll();
        MultipartFile file = (MultipartFile)list.get(0);
        if (file.getOriginalFilename().endsWith(".xlsx") || file.getOriginalFilename().endsWith(".xls")) {
            String filePath = XSSEscape.escape((String)this.configValueUtil.getTemporaryFilePath());
            String fileName = XSSEscape.escape((String)(RandomUtil.uuId() + "." + UpUtil.getFileType((MultipartFile)file)));
            FileUtil.upFile((MultipartFile)file, (String)filePath, (String)fileName);
            try {
                UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)(filePath + fileName), (String)"temporary", (String)fileName);
            }
            catch (IOException e) {
                log.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff1a" + e.getMessage());
            }
            DownloadVO vo = DownloadVO.builder().build();
            vo.setName(fileName);
            return ActionResult.success((Object)vo);
        }
        return ActionResult.fail((String)"\u9009\u62e9\u6587\u4ef6\u4e0d\u7b26\u5408\u5bfc\u5165");
    }

    @Operation(summary="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/ImportPreview"})
    public ActionResult<Map<String, Object>> ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        UploadUtil.downToLocal((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)filePath);
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List personList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, UserExportVO.class);
        Map<String, Object> map = this.userService.importPreview(personList);
        return ActionResult.success(map);
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272ID\u83b7\u53d6\u6240\u6709\u6210\u5458")
    @GetMapping(value={"/getUsersByRoleId"})
    public ActionResult getUsersByRoleId(PaginationUser pagination) {
        ArrayList<UserEntity> userList = new ArrayList<UserEntity>();
        RoleEntity roleEntity = this.roleService.getInfo(pagination.getRoleId());
        if (ObjectUtil.isNotEmpty((Object)roleEntity) && ObjectUtil.isNotEmpty((Object)roleEntity.getGlobalMark()) && GlobalMarkEnum.NOT_ORGANIZE.getCode().intValue() == roleEntity.getGlobalMark().intValue()) {
            userList.addAll(this.userService.getList(pagination, null, false));
        } else {
            this.userService.getListByRoleId(pagination.getRoleId()).forEach(u -> userList.add(this.userService.getInfo(u.getId())));
        }
        List afterUserList = userList.stream().distinct().collect(Collectors.toList());
        if (StringUtils.isNotEmpty((String)pagination.getKeyword())) {
            afterUserList = afterUserList.stream().filter(t -> t.getRealName().contains(pagination.getKeyword()) || t.getAccount().contains(pagination.getKeyword())).collect(Collectors.toList());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)pagination), PaginationVO.class);
        return ActionResult.page(afterUserList, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/getOrganizeTreeById/{userId}"})
    public ActionResult getOrganizeTreeById(@PathVariable(value="userId") String userId) {
        UserInfo userInfo = this.userProvider.get();
        ArrayList<String> orgIdString = new ArrayList<String>();
        List<OrganizeEntity> allOrgByUserId = this.organizeService.getAllOrgByUserId(userId);
        List collect1 = allOrgByUserId.stream().map(OrganizeEntity::getOrganizeIdTree).collect(Collectors.toList());
        for (String s : collect1) {
            if (!s.contains(userInfo.getOrganizeId())) continue;
            String[] split = s.split(",");
            orgIdString.addAll(Arrays.asList(split));
        }
        List collect = orgIdString.stream().distinct().collect(Collectors.toList());
        return ActionResult.success(collect);
    }

    public List<String> getOrganizeTreeByUserId(String userId) {
        ArrayList<String> orgIdString = new ArrayList<String>();
        List<OrganizeEntity> allOrgByUserId = this.organizeService.getAllOrgByUserId(userId);
        List collect1 = allOrgByUserId.stream().map(OrganizeEntity::getOrganizeIdTree).collect(Collectors.toList());
        if (ObjectUtil.isNotEmpty(collect1)) {
            for (String s : collect1) {
                String[] split = s.split(",");
                if (split.length < 1) continue;
                orgIdString.add(split[1]);
            }
        }
        return orgIdString.stream().distinct().collect(Collectors.toList());
    }

    @Operation(summary="\u6839\u636e\u9009\u4e2d\u7528\u6237\u5206\u6790\u5e76\u83b7\u53d6\u56de\u663e\u4fe1\u606f")
    @GetMapping(value={"/selectUpBatchModelByIds"})
    public ActionResult<UserUpBatchModel> selectUpBatchModelByIds(UserUpBatchModel model) {
        if (ObjectUtil.isEmpty((Object)model) || CollectionUtil.isEmpty(model.getUserIds())) {
            return ActionResult.fail((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        UserUpBatchModel userUpBatchModel = this.userService.getUpBatchModelByIds(model.getUserIds());
        return ActionResult.success((Object)userUpBatchModel);
    }

    @Operation(summary="\u6279\u91cf\u8c03\u6574\u7528\u6237")
    @PutMapping(value={"/updateBatch"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u6279\u91cf\u8c03\u6574\u7528\u6237")
    public ActionResult<String> updateBatch(@RequestBody @Valid UserUpBatchForm upBatchForm) throws Exception {
        if (ObjectUtil.isEmpty((Object)upBatchForm) || CollectionUtil.isEmpty(upBatchForm.getUserIds())) {
            return ActionResult.fail((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u53c2\u6570\u9519\u8bef");
        }
        this.userService.updateBatch(upBatchForm);
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    private static /* synthetic */ boolean lambda$rangeElementPlayback$29(UserEntity entity, OrganizeEntity t) {
        return t.getId().equals(entity.getOrganizeId());
    }
}

