/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.annotation.HandleLog;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.GlobalMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.model.UserLogForm;
import com.bringspring.common.model.login.ModuleModel;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.model.button.ButtonModel;
import com.bringspring.system.base.model.column.ColumnModel;
import com.bringspring.system.base.model.form.ModuleFormModel;
import com.bringspring.system.base.model.resource.ResourceModel;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PermissionEntityBase;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnVO;
import com.bringspring.system.permission.model.authorize.AuthorizeModel;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.model.authorize.DataValuesQuery;
import com.bringspring.system.permission.model.permission.PermissionModel;
import com.bringspring.system.permission.model.user.form.UserAppDataForm;
import com.bringspring.system.permission.model.user.form.UserInfoForm;
import com.bringspring.system.permission.model.user.form.UserLanguageForm;
import com.bringspring.system.permission.model.user.form.UserModifyPasswordForm;
import com.bringspring.system.permission.model.user.form.UserSettingForm;
import com.bringspring.system.permission.model.user.form.UserThemeForm;
import com.bringspring.system.permission.model.user.form.UserUpAvatarForm;
import com.bringspring.system.permission.model.user.mod.UserAuthorizeModel;
import com.bringspring.system.permission.model.user.page.PaginationUser;
import com.bringspring.system.permission.model.user.vo.UserAuthorizeVO;
import com.bringspring.system.permission.model.user.vo.UserBaseInfoVO;
import com.bringspring.system.permission.model.user.vo.UserIdListVo;
import com.bringspring.system.permission.model.user.vo.UserListVO;
import com.bringspring.system.permission.model.user.vo.UserLogVO;
import com.bringspring.system.permission.model.user.vo.UserSubordinateVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.RecursiveRemovalUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4e2a\u4eba\u8d44\u6599", description="CurrentUsersInfo")
@RestController
@RequestMapping(value={"/api/permission/Users/Current"})
public class UserSettingController {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private LogService logService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private RoleService roleService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private ModuleService moduleService;

    @Operation(summary="\u4e2a\u4eba\u8d44\u6599")
    @GetMapping(value={"/BaseInfo"})
    public ActionResult<UserBaseInfoVO> get() {
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        String catchKey = this.cacheKeyUtil.getAllUser();
        if (this.cacheUtil.exists(catchKey)) {
            this.cacheUtil.remove(catchKey);
        }
        UserBaseInfoVO vo = (UserBaseInfoVO)JsonUtil.getJsonToBean((Object)userEntity, UserBaseInfoVO.class);
        if (StringUtils.isNotEmpty((String)userEntity.getManagerId())) {
            UserEntity menager = this.userService.getInfo(userEntity.getManagerId());
            vo.setManager(menager != null ? menager.getRealName() : "");
        }
        vo.setLanguage(userEntity.getLanguage() != null ? userEntity.getLanguage() : "zh-CN");
        vo.setTheme(userEntity.getTheme() != null ? userEntity.getTheme() : "W-001");
        String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
        vo.setOrganize(organizeStr);
        if (StringUtils.isNotEmpty((String)userEntity.getOrganizeId())) {
            OrganizeEntity directlyUnderCompanyById = this.organizeService.getDirectlyUnderCompanyById(userEntity.getOrganizeId());
            vo.setCompany(StringUtils.isNotEmpty((String)directlyUnderCompanyById.getShortName()) ? directlyUnderCompanyById.getShortName() : directlyUnderCompanyById.getFullName());
        }
        if (StringUtils.isNotEmpty((String)userInfo.getDepartmentId())) {
            vo.setRoleId(this.roleService.getCurRolesByOrgId(userInfo.getDepartmentId()).stream().map(PermissionEntityBase::getFullName).collect(Collectors.joining(",")));
        }
        List<RoleEntity> listByUserId = this.roleService.getListByUserId(userInfo.getUserId());
        vo.setRoleEntityList(listByUserId);
        List<PositionEntity> positionEntityList = this.positionService.getListByOrgIdAndUserId(userInfo.getDepartmentId(), userEntity.getId());
        if (positionEntityList.size() > 0) {
            List fullNames = positionEntityList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.toList());
            vo.setPosition(String.join((CharSequence)",", fullNames));
        }
        if (StringUtils.isNotEmpty((String)userInfo.getTenantId())) {
            vo.setAccount(userInfo.getTenantId() + "@" + vo.getAccount());
        }
        if (!StringUtils.isEmpty((String)userInfo.getUserIcon())) {
            vo.setAvatar(userInfo.getUserIcon());
        }
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u4e2a\u4eba\u8d44\u6599")
    @GetMapping(value={"/getBaseInfoById/{id}"})
    public ActionResult<UserBaseInfoVO> getBaseInfoById(@PathVariable(value="id") String id) {
        UserEntity userEntity = this.userService.getInfo(id);
        UserBaseInfoVO vo = (UserBaseInfoVO)JsonUtil.getJsonToBean((Object)userEntity, UserBaseInfoVO.class);
        if (StringUtils.isNotEmpty((String)userEntity.getManagerId())) {
            UserEntity menager = this.userService.getInfo(userEntity.getManagerId());
            vo.setManager(menager != null ? menager.getRealName() : "");
        }
        vo.setLanguage(userEntity.getLanguage() != null ? userEntity.getLanguage() : "zh-CN");
        vo.setTheme(userEntity.getTheme() != null ? userEntity.getTheme() : "W-001");
        String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(userEntity.getId());
        vo.setOrganize(organizeStr);
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.lambda().eq(UserRelationEntity::getUserId, (Object)id);
        roleQuery.lambda().eq(UserRelationEntity::getObjectType, (Object)"Role");
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (UserRelationEntity ure : this.userRelationService.list((Wrapper)roleQuery)) {
            roleIdList.add(ure.getObjectId());
        }
        List<RoleEntity> listByIds = this.roleService.getListByIds(roleIdList);
        Object roleNameList = "";
        for (RoleEntity roleEntity : listByIds) {
            roleNameList = (String)roleNameList + roleEntity.getFullName() + ",";
        }
        if (StringUtils.isNotEmpty((String)roleNameList)) {
            roleNameList = ((String)roleNameList).substring(0, ((String)roleNameList).length() - 1);
        }
        vo.setRoleId((String)roleNameList);
        vo.setRoleEntityList(listByIds);
        for (RoleEntity entity : vo.getRoleEntityList()) {
            if (ObjectUtil.isNotEmpty((Object)entity) && ObjectUtil.isNotEmpty((Object)entity.getGlobalMark()) && GlobalMarkEnum.NOT_ORGANIZE.getCode().intValue() == entity.getGlobalMark().intValue()) {
                entity.setType("\u5168\u5c40");
                continue;
            }
            entity.setType("\u7ec4\u7ec7");
        }
        List<PositionEntity> positionEntityList = this.positionService.getListByOrgIdAndUserId(userEntity.getOrganizeId(), userEntity.getId());
        if (positionEntityList.size() > 0) {
            List fullNames = positionEntityList.stream().map(PermissionEntityBase::getFullName).collect(Collectors.toList());
            vo.setPosition(String.join((CharSequence)",", fullNames));
        }
        if (!StringUtils.isEmpty((String)userEntity.getHeadIcon())) {
            vo.setAvatar(userEntity.getHeadIcon());
        }
        return ActionResult.success((Object)vo);
    }

    public void getOrganizeName(List<OrganizeEntity> OrganizeList, String OrganizeId, StringBuilder organizeName) {
        List OrganizeList2 = OrganizeList.stream().filter(t -> t.getId().equals(OrganizeId)).collect(Collectors.toList());
        if (OrganizeList2.size() > 0) {
            for (OrganizeEntity organizeEntity : OrganizeList2) {
                if ("-1".equals(organizeEntity.getParentId())) {
                    organizeName.append(organizeEntity.getFullName());
                    continue;
                }
                organizeName.append(organizeEntity.getFullName() + "/");
            }
            for (OrganizeEntity orgSub : OrganizeList2) {
                this.getOrganizeName(OrganizeList, orgSub.getParentId(), organizeName);
            }
        }
    }

    @Operation(summary="\u7cfb\u7edf\u6743\u9650")
    @GetMapping(value={"/Authorize"})
    public ActionResult<UserAuthorizeVO> getList() {
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(false);
        ArrayList<AuthorizeEntity> authorizeList = new ArrayList<AuthorizeEntity>();
        Map<String, ModuleModel> moduleMap = this.moduleList(authorizeModel.getModuleList());
        List<ModuleModel> modelList = authorizeModel.getModuleList();
        UserAuthorizeVO vo = UserAuthorizeVO.builder().button(this.moduleButton(modelList, authorizeModel.getButtonList(), authorizeList, moduleMap)).column(this.moduleColumn(modelList, authorizeModel.getColumnList(), authorizeList, moduleMap)).form(this.moduleForm(modelList, authorizeModel.getFormsList(), authorizeList, moduleMap)).resource(this.resourceData(modelList, authorizeModel.getResourceList(), authorizeList, moduleMap)).module(this.module(authorizeModel.getModuleList(), authorizeList)).build();
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u5b89\u5168\u5ba1\u8ba1\u83b7\u53d6\u5168\u90e8\u7cfb\u7edf\u6743\u9650")
    @GetMapping(value={"/getAllAuthorize"})
    public ActionResult<UserAuthorizeVO> getAllAuthorize() throws Exception {
        UserInfo userInfo = new UserInfo();
        userInfo.setIsAdministrator(Boolean.valueOf(true));
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(userInfo);
        ArrayList<AuthorizeEntity> authorizeList = new ArrayList<AuthorizeEntity>();
        Map<String, ModuleModel> moduleMap = this.moduleList(authorizeModel.getModuleList());
        List<ModuleModel> modelList = authorizeModel.getModuleList();
        UserAuthorizeVO vo = UserAuthorizeVO.builder().button(this.moduleButton(modelList, authorizeModel.getButtonList(), authorizeList, moduleMap)).column(this.moduleColumn(modelList, authorizeModel.getColumnList(), authorizeList, moduleMap)).form(this.moduleForm(modelList, authorizeModel.getFormsList(), authorizeList, moduleMap)).resource(this.resourceData(modelList, authorizeModel.getResourceList(), authorizeList, moduleMap)).module(this.module(authorizeModel.getModuleList(), authorizeList)).build();
        return ActionResult.success((Object)vo);
    }

    @Operation(summary="\u7cfb\u7edf\u65e5\u5fd7")
    @GetMapping(value={"/SystemLog"})
    public ActionResult<PageListVO<UserLogVO>> getLogList(UserLogForm userLogForm) {
        List<LogEntity> data = this.logService.getList(userLogForm);
        List list = JsonUtil.getJsonToList(data, UserLogVO.class);
        for (int i = 0; i < list.size(); ++i) {
            ((UserLogVO)list.get(i)).setIpaddress(data.get(i).getIpAddress());
            ((UserLogVO)list.get(i)).setRequestURL(data.get(i).getRequestUrl());
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)userLogForm, PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u8d44\u6599")
    @PutMapping(value={"/BaseInfo"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u4fee\u6539\u7528\u6237\u8d44\u6599")
    public ActionResult updateInfo(@RequestBody UserInfoForm userInfoForm) throws Exception {
        this.userService.updateBySetting(userInfoForm);
        return ActionResult.success((String)MsgCode.SU002.get());
    }

    @Operation(summary="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/Actions/ModifyPassword"})
    @HandleLog(moduleName="\u7528\u6237\u7ba1\u7406", requestMethod="\u4fee\u6539\u7528\u6237\u5bc6\u7801")
    public ActionResult modifyPassword(@RequestBody @Valid UserModifyPasswordForm userModifyPasswordForm) {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        if (userEntity != null) {
            String timestamp = String.valueOf(this.cacheUtil.query(userModifyPasswordForm.getTimestamp()));
            if (!userModifyPasswordForm.getCode().equalsIgnoreCase(timestamp)) {
                return ActionResult.fail((String)MsgCode.LOG104.get());
            }
            if (!Md5Util.getStringMd5((String)(userModifyPasswordForm.getOldPassword().toLowerCase() + userEntity.getSecretkey().toLowerCase())).equals(userEntity.getPassword())) {
                return ActionResult.fail((String)MsgCode.LOG201.get());
            }
            userEntity.setPassword(userModifyPasswordForm.getPassword());
            this.userService.updatePassword(userEntity);
            this.userProvider.remove();
            return ActionResult.success((String)MsgCode.LOG202.get());
        }
        return ActionResult.fail((String)MsgCode.LOG203.get());
    }

    @Operation(summary="\u6211\u7684\u4e0b\u5c5e")
    @GetMapping(value={"/Subordinate/{id}"})
    public ActionResult getSubordinate(@PathVariable(value="id") String id) {
        ArrayList<Object> userList = new ArrayList(16);
        ArrayList<UserSubordinateVO> list = new ArrayList<UserSubordinateVO>();
        if ("0".equals(id)) {
            if (Objects.isNull(this.userProvider.get()) || StringUtils.isEmpty((String)this.userProvider.get().getUserId())) {
                return ActionResult.success(list);
            }
            userList.addAll(this.userService.getListByManagerId(this.userProvider.get().getUserId(), null));
        } else {
            userList = new ArrayList<UserIdListVo>(this.userService.getListByManagerId(id, null));
        }
        for (UserIdListVo userIdListVo : userList) {
            UserSubordinateVO subordinateVO = UserSubordinateVO.builder().id(userIdListVo.getId()).avatar(userIdListVo.getHeadIcon()).department(userIdListVo.getOrganizeName()).userName(userIdListVo.getRealName()).position(userIdListVo.getPositionName()).isLeaf(false).build();
            list.add(subordinateVO);
        }
        return ActionResult.success(list);
    }

    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u4e3b\u9898")
    @PutMapping(value={"/SystemTheme"})
    public ActionResult updateTheme(@RequestBody @Valid UserThemeForm userThemeForm) {
        UserEntity entity = (UserEntity)JsonUtil.getJsonToBean((Object)userThemeForm, UserEntity.class);
        entity.setId(this.userProvider.get().getUserId());
        this.userService.update(entity);
        return ActionResult.success((String)MsgCode.SU016.get());
    }

    @Operation(summary="\u4fee\u6539\u5934\u50cf")
    @PutMapping(value={"/Avatar/{name}"})
    public ActionResult updateAvatar(@PathVariable(value="name") String name) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        userEntity.setHeadIcon(name);
        this.userService.update(userEntity.getId(), userEntity);
        if (!StringUtils.isEmpty((String)userInfo.getId())) {
            userInfo.setUserIcon(name);
            this.cacheUtil.insert("loginCacheSpace", userInfo.getId(), (Object)userInfo, DateUtil.getTime((Date)userInfo.getOverdueTime()) - DateUtil.getTime((Date)new Date()));
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u4fee\u6539\u5934\u50cf")
    @PutMapping(value={"/Avatar"})
    public ActionResult updateAvatar(@RequestBody @Valid UserUpAvatarForm avatarForm) throws Exception {
        String name = avatarForm.getHeadIcon();
        UserInfo userInfo = this.userProvider.get();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        userEntity.setHeadIcon(name);
        this.userService.update(userEntity.getId(), userEntity);
        if (!StringUtils.isEmpty((String)userInfo.getId())) {
            userInfo.setUserIcon(name);
            this.cacheUtil.insert("loginCacheSpace", userInfo.getId(), (Object)userInfo, DateUtil.getTime((Date)userInfo.getOverdueTime()) - DateUtil.getTime((Date)new Date()));
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @Operation(summary="\u4fee\u6539\u7cfb\u7edf\u8bed\u8a00")
    @PutMapping(value={"/SystemLanguage"})
    public ActionResult updateLanguage(@RequestBody @Valid UserLanguageForm userLanguageForm) {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        userEntity.setLanguage(userLanguageForm.getLanguage());
        this.userService.update(userEntity);
        return ActionResult.success((String)MsgCode.SU016.get());
    }

    private Map<String, ModuleModel> moduleList(List<ModuleModel> moduleList) {
        HashMap<String, ModuleModel> auth = new HashMap<String, ModuleModel>(16);
        for (ModuleModel module : moduleList) {
            auth.put(module.getId(), module);
            module.setIcon(module.getIcon());
        }
        return auth;
    }

    private List<UserAuthorizeModel> module(List<ModuleModel> moduleList, List<AuthorizeEntity> authorizeLiat) {
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List treeList = JsonUtil.getJsonToList(moduleList, AuthorizeModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)treeList, (String)"-1");
        List vo = JsonUtil.getJsonToList((Object)trees, UserAuthorizeModel.class);
        return vo;
    }

    private List<UserAuthorizeModel> moduleButton(List<ModuleModel> moduleList, List<ButtonModel> moduleButtonList, List<AuthorizeEntity> authorizeLiat, Map<String, ModuleModel> moduleMap) {
        List<Object> treeList = new ArrayList();
        HashSet<String> moduleModeId = new HashSet<String>();
        for (ButtonModel buttonModel : moduleButtonList) {
            moduleModeId.add(buttonModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(buttonModel.getId());
            treeModel.setFullName(buttonModel.getFullName());
            treeModel.setParentId(buttonModel.getModuleId());
            treeModel.setIcon(buttonModel.getIcon());
            ModuleEntity info = this.moduleService.getInfo(buttonModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeList.add((Object)treeModel);
        }
        List buttonList = moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(buttonList, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List data = JsonUtil.getJsonToList((Object)trees, UserAuthorizeModel.class);
        return data;
    }

    private List<UserAuthorizeModel> moduleColumn(List<ModuleModel> moduleList, List<ColumnModel> moduleColumnList, List<AuthorizeEntity> authorizeLiat, Map<String, ModuleModel> moduleMap) {
        List<Object> treeList = new ArrayList();
        ArrayList<String> moduleModeId = new ArrayList<String>();
        for (ColumnModel columnModel : moduleColumnList) {
            moduleModeId.add(columnModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(columnModel.getId());
            treeModel.setFullName(columnModel.getFullName());
            treeModel.setParentId(columnModel.getModuleId());
            treeModel.setIcon("fa fa-tags column");
            ModuleEntity info = this.moduleService.getInfo(columnModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeList.add((Object)treeModel);
        }
        List buttonList = moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(buttonList, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, UserAuthorizeModel.class);
        return data;
    }

    private List<UserAuthorizeModel> moduleForm(List<ModuleModel> moduleList, List<ModuleFormModel> moduleFormList, List<AuthorizeEntity> authorizeLiat, Map<String, ModuleModel> moduleMap) {
        List<Object> treeList = new ArrayList();
        ArrayList<String> moduleModeId = new ArrayList<String>();
        for (ModuleFormModel formModel : moduleFormList) {
            moduleModeId.add(formModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(formModel.getId());
            treeModel.setFullName(formModel.getFullName());
            treeModel.setParentId(formModel.getModuleId());
            treeModel.setIcon("fa fa-binoculars resource");
            ModuleEntity info = this.moduleService.getInfo(formModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeList.add((Object)treeModel);
        }
        List buttonList = moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(buttonList, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, UserAuthorizeModel.class);
        return data;
    }

    private List<UserAuthorizeModel> resourceData(List<ModuleModel> moduleList, List<ResourceModel> moduleResourceList, List<AuthorizeEntity> authorizeLiat, Map<String, ModuleModel> moduleMap) {
        List<Object> treeList = new ArrayList();
        ArrayList<String> moduleModeId = new ArrayList<String>();
        for (ResourceModel resourceModel : moduleResourceList) {
            moduleModeId.add(resourceModel.getModuleId());
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(resourceModel.getId());
            treeModel.setFullName(resourceModel.getFullName());
            treeModel.setParentId(resourceModel.getModuleId());
            treeModel.setIcon("fa fa-binoculars resource");
            ModuleEntity info = this.moduleService.getInfo(resourceModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeList.add((Object)treeModel);
        }
        List buttonList = moduleList.stream().filter(t -> moduleModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(buttonList, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, UserAuthorizeModel.class);
        return data;
    }

    @Operation(summary="\u8bbe\u7f6e\u4e3b\u8981\u7ec4\u7ec7\u3001\u4e3b\u8981\u5c97\u4f4d\uff08\u89d2\u8272\u5f53\u524d\u4e0d\u505a\uff09")
    @Parameters(value={@Parameter(name="majorType", description="\u7ec4\u7ec7:Organize/\u5c97\u4f4d:Position"), @Parameter(name="majorId", description="\u7ec4\u7ec7/\u5c97\u4f4did")})
    @PutMapping(value={"/major"})
    public ActionResult<String> defaultOrganize(@RequestBody UserSettingForm userSettingForm) {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        UserEntity updateUser = new UserEntity();
        switch (userSettingForm.getMajorType()) {
            case "Organize": {
                String orgId = userSettingForm.getMajorId();
                if (!this.organizeRelationService.checkBasePermission(userEntity.getId(), orgId).booleanValue()) {
                    return ActionResult.fail((String)MsgCode.FA025.get());
                }
                updateUser.setOrganizeId(orgId);
                updateUser.setPositionId(this.organizeRelationService.autoGetMajorPositionId(userEntity.getId(), orgId, userEntity.getPortalId()));
                break;
            }
            case "Position": {
                updateUser.setPositionId(userSettingForm.getMajorId());
                break;
            }
        }
        updateUser.setId(userEntity.getId());
        this.userService.update(updateUser);
        String key = this.cacheKeyUtil.getUserAuthorize() + this.userProvider.get().getUserId();
        this.cacheUtil.remove("loginCacheSpace", key);
        return ActionResult.success((String)MsgCode.SU016.get());
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u6709\u7ec4\u7ec7")
    @GetMapping(value={"/getUserOrganizes"})
    public ActionResult<List<PermissionModel>> getUserOrganizes() {
        return ActionResult.success(this.userRelationService.getObjectVoList("Organize"));
    }

    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u6240\u6709\u7ec4\u7ec7")
    @GetMapping(value={"/getUserOrganizesById/{id}"})
    public ActionResult<List<PermissionModel>> getUserOrganizesById(@PathVariable(value="id") String id) {
        return ActionResult.success(this.userRelationService.getObjectVoListById(id, "Organize"));
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5f53\u524d\u7ec4\u7ec7\u5e95\u4e0b\u6240\u6709\u5c97\u4f4d")
    @GetMapping(value={"/getUserPositions"})
    public ActionResult<List<PermissionModel>> getUserPositions() {
        return ActionResult.success(this.userRelationService.getObjectVoList("Position"));
    }

    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u7528\u6237\u5f53\u524d\u7ec4\u7ec7\u5e95\u4e0b\u6240\u6709\u5c97\u4f4d")
    @GetMapping(value={"/getUserPositionsById/{id}"})
    public ActionResult<List<PermissionModel>> getUserPositionsById(@PathVariable(value="id") String id) {
        return ActionResult.success(this.userRelationService.getObjectVoListById(id, "Position"));
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6240\u6709\u89d2\u8272")
    @GetMapping(value={"/getUserRoles"})
    public ActionResult<List<PermissionModel>> getUserRoles() {
        return ActionResult.success(this.userRelationService.getObjectVoList("Role"));
    }

    @Operation(summary="\u6839\u636e\u7528\u6237id\u83b7\u53d6\u83dc\u5355\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/getMenuListByUserId/{userId}"})
    public ActionResult<AuthorizeDataReturnVO> getMenuListByUserId(@PathVariable(value="userId") String userId, @RequestBody DataValuesQuery dataValuesQuery) throws Exception {
        QueryWrapper roleQuery = new QueryWrapper();
        roleQuery.lambda().eq(UserRelationEntity::getUserId, (Object)userId);
        roleQuery.lambda().eq(UserRelationEntity::getObjectType, (Object)"Role");
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (UserRelationEntity ure : this.userRelationService.list((Wrapper)roleQuery)) {
            roleIdList.add(ure.getObjectId());
        }
        String ids = roleIdList.stream().collect(Collectors.joining(","));
        ActionResult<AuthorizeDataReturnVO> menuListByRoleIds = this.getMenuListByRoleIds(ids, dataValuesQuery);
        return menuListByRoleIds;
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272id\u96c6\u5408\u83b7\u53d6\u83dc\u5355\u5217\u8868\u4fe1\u606f")
    @PostMapping(value={"/getMenuListByRoleIds/{roleIds}"})
    public ActionResult<AuthorizeDataReturnVO> getMenuListByRoleIds(@PathVariable(value="roleIds") String roleIds, @RequestBody DataValuesQuery dataValuesQuery) throws Exception {
        String[] split = roleIds.split(",");
        ArrayList<String> roleIdList = new ArrayList<String>();
        for (String id : split) {
            roleIdList.add(id);
        }
        List<RoleEntity> listByIds = this.roleService.getListByIds(roleIdList);
        ArrayList<AuthorizeDataReturnModel> dataReturnModelList = new ArrayList<AuthorizeDataReturnModel>();
        ArrayList<String> ids = new ArrayList<String>();
        DataValuesQuery module = new DataValuesQuery();
        module.setType("module");
        for (RoleEntity roleEntity : listByIds) {
            String objectId = roleEntity.getId();
            AuthorizeVO authorizeModel = this.authorizeService.getAuthorizeByRoleId(objectId);
            List list = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
            if (!StringUtils.isEmpty((String)dataValuesQuery.getType())) {
                AuthorizeDataReturnVO authorizeDataReturnVO = this.authorizeService.getAuthorizeDataReturnVO(authorizeModel, list, module, objectId);
                dataReturnModelList.addAll(authorizeDataReturnVO.getList());
                ids.addAll(authorizeDataReturnVO.getIds());
                continue;
            }
            return ActionResult.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<String> listWithoutDuplicates = ids.stream().distinct().collect(Collectors.toList());
        if (!StringUtils.isEmpty((String)dataValuesQuery.getType()) && !"module".equals(dataValuesQuery.getType()) && listWithoutDuplicates.size() > 0) {
            dataValuesQuery.setModuleIds(String.join((CharSequence)",", listWithoutDuplicates));
            dataReturnModelList = new ArrayList();
            for (RoleEntity roleEntity : listByIds) {
                String objectId = roleEntity.getId();
                AuthorizeVO authorizeModel = this.authorizeService.getAuthorizeByRoleId(objectId);
                List list = this.authorizeService.list((Wrapper)new QueryWrapper().lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId));
                if (!StringUtils.isEmpty((String)dataValuesQuery.getType())) {
                    AuthorizeDataReturnVO authorizeDataReturnVO = this.authorizeService.getAuthorizeDataReturnVO(authorizeModel, list, dataValuesQuery, objectId);
                    dataReturnModelList.addAll(authorizeDataReturnVO.getList());
                    ids.addAll(authorizeDataReturnVO.getIds());
                    continue;
                }
                return ActionResult.fail((String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        List<AuthorizeDataReturnModel> list = RecursiveRemovalUtil.deduplicateAndMerge(dataReturnModelList);
        List<AuthorizeDataReturnModel> authorizeDataReturnModelList = new ArrayList<AuthorizeDataReturnModel>();
        for (int i = 0; i < list.size(); ++i) {
            AuthorizeDataReturnModel authorizeDataReturnModel = list.get(i);
            if (!StringUtils.isNotEmpty((String)authorizeDataReturnModel.getType()) || !"root".equals(authorizeDataReturnModel.getType())) continue;
            authorizeDataReturnModelList.add(authorizeDataReturnModel);
        }
        String str = JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString();
        if (str.contains("$ref")) {
            authorizeDataReturnModelList = RecursiveRemovalUtil.deduplicateAndKeepDeepest(authorizeDataReturnModelList);
        }
        AuthorizeDataReturnVO returnVO = new AuthorizeDataReturnVO();
        returnVO.setList(authorizeDataReturnModelList);
        returnVO.setIds(listWithoutDuplicates);
        System.out.println(JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString());
        return ActionResult.success((Object)returnVO);
    }

    @Operation(summary="\u6839\u636e\u83dc\u5355id\u83b7\u53d6\u62e5\u6709\u8be5\u83dc\u5355\u7684\u5168\u90e8\u4eba\u5458\u4fe1\u606f")
    @PostMapping(value={"/getUserListByMenuId/{menuId}"})
    public ActionResult<PageListVO<UserListVO>> getUserListByMenuId(@PathVariable(value="menuId") String menuId, @RequestBody PaginationUser paginationUser) {
        List<AuthorizeEntity> authorizeEntityList = this.roleService.getListBymenuId(menuId);
        List<UserEntity> userList = this.userService.getUserListByMenuId(authorizeEntityList, paginationUser);
        List list = JsonUtil.getJsonToList(userList, UserListVO.class);
        for (UserListVO vo : list) {
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(vo.getId());
            vo.setOrganize(organizeStr);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationUser), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272id\u83b7\u53d6\u5168\u90e8\u4eba\u5458\u4fe1\u606f")
    @PostMapping(value={"/getUserListByRoleId/{roleId}"})
    public ActionResult<PageListVO<UserListVO>> getUserListByRoleId(@PathVariable(value="roleId") String roleId, @RequestBody PaginationUser paginationUser) {
        ArrayList<AuthorizeEntity> authorizeEntityList = new ArrayList<AuthorizeEntity>();
        AuthorizeEntity authorizeEntity = new AuthorizeEntity();
        authorizeEntity.setObjectId(roleId);
        authorizeEntityList.add(authorizeEntity);
        List<UserEntity> userList = this.userService.getUserListByMenuId(authorizeEntityList, paginationUser);
        List list = JsonUtil.getJsonToList(userList, UserListVO.class);
        for (UserListVO vo : list) {
            String organizeStr = this.userRelationService.getAllOrganizeNameInfoById(vo.getId());
            vo.setOrganize(organizeStr);
        }
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)paginationUser), PaginationVO.class);
        return ActionResult.page((List)list, (PaginationVO)paginationVO);
    }

    @Operation(summary="\u4fee\u6539app\u5e38\u7528\u6570\u636e")
    @PutMapping(value={"/SystemAppData"})
    public ActionResult updateAppData(@RequestBody @Valid UserAppDataForm userAppDataForm) {
        UserInfo userInfo = this.userProvider.get();
        UserEntity entity = this.userService.getInfo(userInfo.getUserId());
        entity.setPropertyJson(userAppDataForm.getData());
        this.userService.update(entity);
        return ActionResult.success((String)MsgCode.SU016.get());
    }
}

