/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.auth.util.UserProvider;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DbSourceOrDbLink;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DataSourceUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.bringspring.common.model.login.ModuleModel;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.enums.SearchMethodEnum;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.ModuleButtonEntity;
import com.bringspring.system.base.entity.ModuleColumnEntity;
import com.bringspring.system.base.entity.ModuleDataAuthorizeSchemeEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.entity.ModuleFormEntity;
import com.bringspring.system.base.model.button.ButtonModel;
import com.bringspring.system.base.model.column.ColumnModel;
import com.bringspring.system.base.model.form.ModuleFormModel;
import com.bringspring.system.base.model.resource.ResourceModel;
import com.bringspring.system.base.service.ModuleButtonService;
import com.bringspring.system.base.service.ModuleColumnService;
import com.bringspring.system.base.service.ModuleDataAuthorizeSchemeService;
import com.bringspring.system.base.service.ModuleFormService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.mapper.AuthorizeMapper;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnModel;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnVO;
import com.bringspring.system.permission.model.authorize.AuthorizeDataUpForm;
import com.bringspring.system.permission.model.authorize.AuthorizeModel;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.model.authorize.ConditionModel;
import com.bringspring.system.permission.model.authorize.DataValuesQuery;
import com.bringspring.system.permission.model.authorize.SaveAuthForm;
import com.bringspring.system.permission.model.authorize.SaveBatchForm;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeAdministratorService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.service.strategy.ConditionStrategy;
import com.bringspring.system.permission.service.strategy.ConditionStrategyFactory;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@DSTransactional
public class AuthorizeServiceImpl
extends ServiceImpl<AuthorizeMapper, AuthorizeEntity>
implements AuthorizeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthorizeServiceImpl.class);
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private DataSourceUtil dataSourceUtils;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private PositionService positionService;
    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OrganizeAdministratorService organizeAdminIsTratorService;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ModuleButtonService buttonService;
    @Autowired
    private ModuleColumnService columnService;
    @Autowired
    private ModuleFormService formService;
    @Autowired
    private ModuleDataAuthorizeSchemeService schemeService;
    @Autowired
    private ConditionStrategyFactory conditionStrategyFactory;

    @Override
    public AuthorizeVO getAuthorize(boolean isCache) {
        if (isCache) {
            return this.getCacheAuthor(this.userProvider.get());
        }
        return this.getAuthorize(this.userProvider.get());
    }

    private AuthorizeVO getCacheAuthor(UserInfo userInfo) {
        String cacheKey = this.cacheKeyUtil.getUserAuthorize() + userInfo.getUserId();
        if (!this.cacheUtil.exists(cacheKey)) {
            AuthorizeVO authorizeModel = this.getAuthorize(userInfo);
            if (authorizeModel.getModuleList().size() != 0) {
                this.cacheUtil.insert("loginCacheSpace", cacheKey, (Object)authorizeModel, 60L);
            }
            return authorizeModel;
        }
        return (AuthorizeVO)JsonUtil.getJsonToBean((String)this.cacheUtil.query("loginCacheSpace", cacheKey).toString(), AuthorizeVO.class);
    }

    @Override
    public AuthorizeVO getAuthorize(UserInfo userInfo) {
        List<Object> moduleList = new ArrayList();
        List<Object> buttonList = new ArrayList();
        List<ColumnModel> columnList = new ArrayList<ColumnModel>();
        List<ResourceModel> resourceList = new ArrayList<ResourceModel>();
        List<ModuleFormModel> formsList = new ArrayList<ModuleFormModel>();
        Boolean isAdmin = userInfo.getIsAdministrator();
        if (!isAdmin.booleanValue()) {
            ArrayList roleIds = new ArrayList();
            this.roleService.getRoleIdsByCurrentUser(userInfo.getDepartmentId()).forEach(role -> {
                if (role != null) {
                    roleIds.add("'" + role + "'");
                }
            });
            if (roleIds.size() != 0) {
                String roleIdsStr = String.join((CharSequence)",", roleIds);
                moduleList = ((AuthorizeMapper)this.baseMapper).findModule(roleIdsStr);
                buttonList = ((AuthorizeMapper)this.baseMapper).findButton(roleIdsStr);
                columnList = ((AuthorizeMapper)this.baseMapper).findColumn(roleIdsStr);
                resourceList = ((AuthorizeMapper)this.baseMapper).findResource(roleIdsStr);
                formsList = ((AuthorizeMapper)this.baseMapper).findForms(roleIdsStr);
            }
        } else {
            moduleList = ((AuthorizeMapper)this.baseMapper).findModuleAdmin(1);
            buttonList = ((AuthorizeMapper)this.baseMapper).findButtonAdmin(1);
            columnList = ((AuthorizeMapper)this.baseMapper).findColumnAdmin(1);
            resourceList = ((AuthorizeMapper)this.baseMapper).findResourceAdmin(1);
            formsList = ((AuthorizeMapper)this.baseMapper).findFormsAdmin(1);
        }
        return new AuthorizeVO(moduleList, buttonList, columnList, resourceList, formsList);
    }

    @Override
    public AuthorizeVO getAuthorizeByRoleId(String roleId) {
        ArrayList<ModuleModel> moduleList = new ArrayList();
        ArrayList<ButtonModel> buttonList = new ArrayList();
        ArrayList<ColumnModel> columnList = new ArrayList();
        ArrayList<ResourceModel> resourceList = new ArrayList();
        ArrayList<ModuleFormModel> formsList = new ArrayList();
        moduleList = ((AuthorizeMapper)this.baseMapper).findModule(roleId);
        buttonList = ((AuthorizeMapper)this.baseMapper).findButton(roleId);
        columnList = ((AuthorizeMapper)this.baseMapper).findColumn(roleId);
        resourceList = ((AuthorizeMapper)this.baseMapper).findResource(roleId);
        formsList = ((AuthorizeMapper)this.baseMapper).findForms(roleId);
        return new AuthorizeVO(moduleList, buttonList, columnList, resourceList, formsList);
    }

    @Override
    public void save(String objectId, AuthorizeDataUpForm authorizeList) {
        SaveBatchForm form = (SaveBatchForm)JsonUtil.getJsonToBean((Object)authorizeList, SaveBatchForm.class);
        form.setRoleIds(new String[]{objectId});
        this.saveBatch(form, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveBatch(SaveBatchForm saveBatchForm, boolean isBatch) {
        try {
            UserInfo userInfo = this.userProvider.get();
            String dbName = userInfo.getTenantDbConnectionString() == null ? this.dataSourceUtils.getDbName() : userInfo.getTenantDbConnectionString();
            ArrayList<AuthorizeEntity> objectList = new ArrayList<AuthorizeEntity>();
            ArrayList<AuthorizeEntity> authorizeList = new ArrayList<AuthorizeEntity>();
            this.setEntity(saveBatchForm.getUserIds(), "User", objectList, true);
            this.setEntity(saveBatchForm.getPositionIds(), "Position", objectList, true);
            this.setEntity(saveBatchForm.getRoleIds(), "Role", objectList, true);
            this.setEntity(saveBatchForm.getButton(), "button", authorizeList, false);
            this.setEntity(saveBatchForm.getModule(), "module", authorizeList, false);
            this.setEntity(saveBatchForm.getColumn(), "column", authorizeList, false);
            this.setEntity(saveBatchForm.getResource(), "resource", authorizeList, false);
            this.setEntity(saveBatchForm.getForm(), "form", authorizeList, false);
            Connection conn = ConnUtil.getConn((DbSourceOrDbLink)this.dataSourceUtils, (String)dbName);
            try {
                List<String> objectIdAll = objectList.stream().map(AuthorizeEntity::getObjectId).collect(Collectors.toList());
                this.userService.delCurRoleUser(objectIdAll);
                if (!isBatch) {
                    JdbcUtil.creUpDe((PreparedStatementDTO)new PreparedStatementDTO(conn, XSSEscape.escapeEmpty((String)SqlBase.getAuthorDelSql(objectIdAll))));
                }
                String sql = DbTypeUtil.checkOracle((DbSourceOrDbLink)this.dataSourceUtils) != false || DbTypeUtil.checkPostgre((DbSourceOrDbLink)this.dataSourceUtils) != false ? "INSERT INTO base_authorize (ID, ITEM_TYPE, ITEM_ID, OBJECT_TYPE, OBJECT_ID, SORT_CODE, CREATOR_TIME, CREATOR_USER_ID ) VALUES  (?,?,?,?,?,?,TO_DATE(?,'yyyy-mm-dd hh24:mi:ss'),?)" : "INSERT INTO base_authorize (ID, ITEM_TYPE, ITEM_ID, OBJECT_TYPE, OBJECT_ID, SORT_CODE, CREATOR_TIME, CREATOR_USER_ID ) VALUES  (?,?,?,?,?,?,?,?)";
                LinkedList<PreparedStatementDTO> prepareDtoList = new LinkedList<PreparedStatementDTO>();
                for (int i = 0; i < objectList.size(); ++i) {
                    for (AuthorizeEntity entityItem : authorizeList) {
                        LinkedList<Object> paramList = new LinkedList<Object>();
                        paramList.add(RandomUtil.uuId());
                        paramList.add(entityItem.getItemType());
                        paramList.add(entityItem.getItemId());
                        paramList.add(((AuthorizeEntity)objectList.get(i)).getObjectType());
                        paramList.add(((AuthorizeEntity)objectList.get(i)).getObjectId());
                        paramList.add(i);
                        paramList.add(DateUtil.getNow());
                        paramList.add(userInfo.getUserId());
                        prepareDtoList.add(new PreparedStatementDTO(null, null, paramList));
                    }
                }
                JdbcUtil.creUpDeBatchOneSql((Connection)conn, (String)sql, prepareDtoList);
            }
            finally {
                if (Collections.singletonList(conn).get(0) != null) {
                    conn.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u6743\u9650\u62a5\u9519:" + e.getMessage());
        }
    }

    private void setEntity(String[] ids, String type, List<AuthorizeEntity> entityList, Boolean objectFlag) {
        if (ids != null) {
            for (String id : ids) {
                AuthorizeEntity entity = new AuthorizeEntity();
                if (objectFlag.booleanValue()) {
                    entity.setObjectType(type);
                    entity.setObjectId(id);
                } else {
                    entity.setItemType(type);
                    entity.setItemId(id);
                }
                entityList.add(entity);
            }
        }
    }

    @Override
    public List<AuthorizeEntity> getListByUserId(boolean isAdmin, String userId) {
        if (!isAdmin) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().in(UserRelationEntity::getUserId, new Object[]{userId});
            List list = this.userRelationService.list((Wrapper)queryWrapper);
            List userRelationList = list.stream().map(u -> u.getObjectId()).collect(Collectors.toList());
            userRelationList.add(userId);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.lambda().in(AuthorizeEntity::getObjectId, userRelationList);
            return this.list((Wrapper)wrapper);
        }
        return new ArrayList<AuthorizeEntity>();
    }

    @Override
    public List<AuthorizeEntity> getListByObjectId(String objectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Boolean existByObjId(String objectId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId);
        queryWrapper.lambda().eq(AuthorizeEntity::getItemType, (Object)"module");
        return this.count((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public List<AuthorizeEntity> getListByObjectId(String objectId, String itemType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AuthorizeEntity::getObjectId, (Object)objectId);
        queryWrapper.lambda().eq(AuthorizeEntity::getItemType, (Object)itemType);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AuthorizeEntity> getListByObjectAndItem(String itemId, String objectType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(AuthorizeEntity::getObjectType, (Object)objectType)).eq(AuthorizeEntity::getItemId, (Object)itemId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<AuthorizeEntity> getListByItemId(String itemId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AuthorizeEntity::getItemId, (Object)itemId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public Map<String, List<Map<String, Object>>> getDataAuthorizeForm() {
        return this.conditionStrategyFactory.getDataAuthorizeForm();
    }

    @Override
    public String getDescByCondition(String condition) {
        String desc = null;
        Map<String, List<Map<String, Object>>> dataAuthorizeForm = this.conditionStrategyFactory.getDataAuthorizeForm();
        if (CollectionUtil.isNotEmpty(dataAuthorizeForm)) {
            List<Map<String, Object>> dateConditionOptions;
            List<Map<String, Object>> numberConditionOptions;
            List<Map<String, Object>> stringConditionOptions;
            List<Map<String, Object>> textConditionOptions = dataAuthorizeForm.get("textOptions");
            if (CollectionUtil.isNotEmpty(textConditionOptions)) {
                for (Map<String, Object> textCondition : textConditionOptions) {
                    if (!textCondition.get("value").equals(condition)) continue;
                    desc = String.valueOf(textCondition.get("label"));
                    break;
                }
            }
            if (StringUtils.isEmpty(desc) && CollectionUtil.isNotEmpty(stringConditionOptions = dataAuthorizeForm.get("organizeOptions"))) {
                for (Map<String, Object> stringCondition : stringConditionOptions) {
                    if (!stringCondition.get("value").equals(condition)) continue;
                    desc = String.valueOf(stringCondition.get("label"));
                    break;
                }
            }
            if (StringUtils.isEmpty(desc) && CollectionUtil.isNotEmpty(numberConditionOptions = dataAuthorizeForm.get("numberOptions"))) {
                for (Map<String, Object> numberCondition : numberConditionOptions) {
                    if (!numberCondition.get("value").equals(condition)) continue;
                    desc = String.valueOf(numberCondition.get("label"));
                    break;
                }
            }
            if (StringUtils.isEmpty(desc) && CollectionUtil.isNotEmpty(dateConditionOptions = dataAuthorizeForm.get("dataTimeOptions"))) {
                for (Map<String, Object> dateCondition : dateConditionOptions) {
                    if (!dateCondition.get("value").equals(condition)) continue;
                    desc = String.valueOf(dateCondition.get("label"));
                    break;
                }
            }
        }
        return desc;
    }

    @Override
    public void saveAuth(String itemId, SaveAuthForm saveAuthForm) {
        String creatorUserId = this.userProvider.get().getUserId();
        ArrayList<AuthorizeEntity> list = new ArrayList<AuthorizeEntity>();
        for (int i = 0; i < saveAuthForm.getObjectId().length; ++i) {
            AuthorizeEntity authorizeEntity = new AuthorizeEntity();
            authorizeEntity.setId(RandomUtil.uuId());
            authorizeEntity.setItemType("portal");
            authorizeEntity.setItemId(itemId);
            authorizeEntity.setObjectType(saveAuthForm.getObjectType());
            authorizeEntity.setObjectId(saveAuthForm.getObjectId()[i]);
            authorizeEntity.setSortCode(Long.valueOf(i));
            authorizeEntity.setCreatorTime(new Date());
            authorizeEntity.setCreatorUserId(creatorUserId);
            list.add(authorizeEntity);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(AuthorizeEntity::getItemId, (Object)itemId);
        this.remove((Wrapper)queryWrapper);
        if (list.size() > 0) {
            this.saveBatch(list);
            List<String> objectIdAll = list.stream().map(AuthorizeEntity::getObjectId).collect(Collectors.toList());
            this.userService.delCurRoleUser(objectIdAll);
        }
    }

    public QueryWrapper<T> getCondition(AuthorizeConditionModel conditionModel) {
        QueryWrapper queryWhere = conditionModel.getObj();
        String moduleId = conditionModel.getModuleId();
        String tableName = conditionModel.getTableName();
        AuthorizeVO model = this.getAuthorize(true);
        List resourceList = model.getResourceList().stream().filter(m -> m.getModuleId().equals(moduleId)).collect(Collectors.toList());
        if (resourceList.size() == 0) {
            return null;
        }
        ArrayList<ResourceModel> resourceList1 = new ArrayList<ResourceModel>();
        boolean t = true;
        for (ResourceModel item : resourceList) {
            if ("alldata".equals(item.getEnCode())) {
                t = false;
                break;
            }
            String conditionJson = item.getConditionJson();
            List conditionModelList = JsonUtil.getJsonToList((String)conditionJson, ConditionModel.class);
            List newConditionModelList = conditionModelList.stream().filter(cm -> {
                List<ConditionModel.ConditionItemModel> groups;
                List<ConditionModel.ConditionItemModel> newGroups;
                if (ObjectUtil.isNotEmpty((Object)cm) && CollectionUtil.isNotEmpty(cm.getGroups()) && CollectionUtil.isNotEmpty(newGroups = (groups = cm.getGroups()).stream().filter(group -> {
                    if (StringUtils.isEmpty((String)group.getBindTable())) {
                        return true;
                    }
                    return group.getBindTable().equalsIgnoreCase(tableName);
                }).collect(Collectors.toList()))) {
                    cm.setGroups(newGroups);
                    return true;
                }
                return false;
            }).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(newConditionModelList)) continue;
            item.setConditionJson(JsonUtil.getObjectToString(newConditionModelList));
            resourceList1.add(item);
        }
        if (t && resourceList1.size() > 0) {
            queryWhere.and(tw -> {
                for (ResourceModel item : resourceList1) {
                    String matchLogic = StringUtils.isEmpty((String)item.getMatchLogic()) ? SearchMethodEnum.And.getSymbol() : item.getMatchLogic();
                    List conditionModelList = JsonUtil.getJsonToList((String)item.getConditionJson(), ConditionModel.class);
                    Consumer<QueryWrapper> conditionModelConsumer = cmqw -> {
                        for (int i = 0; i < conditionModelList.size(); ++i) {
                            ConditionModel conditionItem = (ConditionModel)conditionModelList.get(i);
                            Consumer<QueryWrapper<T>> conditionItemConsumer = this.getConditionItem(conditionItem);
                            if (!ObjectUtil.isNotEmpty(conditionItemConsumer)) continue;
                            if (SearchMethodEnum.And.getSymbol().equalsIgnoreCase(matchLogic)) {
                                cmqw.and(conditionItemConsumer);
                                continue;
                            }
                            cmqw.or(conditionItemConsumer);
                        }
                    };
                    tw.or(conditionModelConsumer);
                }
            });
        }
        return queryWhere;
    }

    private Consumer<QueryWrapper<T>> getConditionItem(ConditionModel conditionItem) {
        if (Objects.isNull(conditionItem) || CollectionUtil.isEmpty(conditionItem.getGroups())) {
            return null;
        }
        Consumer<QueryWrapper<T>> queryWrapperConsumer = tw -> {
            for (int k = 0; k < conditionItem.getGroups().size(); ++k) {
                ConditionModel.ConditionItemModel fieldItem = conditionItem.getGroups().get(k);
                ConditionStrategy strategy = "datetime".equals(fieldItem.getType()) ? this.conditionStrategyFactory.getConditionStrategy(1) : ("text".equals(fieldItem.getType()) ? this.conditionStrategyFactory.getConditionStrategy(5) : ("int\u3001bigint\u3001double".contains(fieldItem.getType()) ? this.conditionStrategyFactory.getConditionStrategy(3) : ("string\u3001varchar".contains(fieldItem.getType()) ? this.conditionStrategyFactory.getConditionStrategy(4) : this.conditionStrategyFactory.getConditionStrategy(2))));
                strategy.generateCondition((QueryWrapper<T>)tw, conditionItem.getLogic(), fieldItem);
            }
        };
        return queryWrapperConsumer;
    }

    @Override
    public String getConditionSql(UserInfo userInfo, String moduleId, String tableName) {
        return StringUtils.replaceIgnoreCase((String)this.getConditionSql(moduleId, tableName), (String)"WHERE", (String)" AND") + " ";
    }

    public String getConditionSql(String moduleId, String tableName) {
        AuthorizeConditionModel conditionModel = new AuthorizeConditionModel(new QueryWrapper(), moduleId, tableName);
        QueryWrapper<T> queryWhere = this.getCondition(conditionModel);
        String sqlSegment = this.getSql(queryWhere);
        return sqlSegment;
    }

    public <T> String getSql(QueryWrapper<T> queryWrapper) {
        String customSqlSegment = queryWrapper.getCustomSqlSegment();
        for (Map.Entry entry : queryWrapper.getParamNameValuePairs().entrySet()) {
            if (ObjectUtil.isEmpty(entry) || ObjectUtil.isEmpty(entry.getKey()) || ObjectUtil.isEmpty(entry.getValue())) continue;
            customSqlSegment = customSqlSegment.replace("#{ew.paramNameValuePairs." + (String)entry.getKey() + "}", this.formatParamValue(entry.getValue()));
        }
        return customSqlSegment;
    }

    public String formatParamValue(Object arg) {
        Object paramValue = arg instanceof String ? "'" + arg.toString().replace("'", "\\'") + "'" : (arg instanceof Date ? "'" + DateUtil.format((Date)((Date)arg), (String)"yyyy-MM-dd HH:mm:ss") + "'" : (arg != null ? arg.toString() : null));
        return paramValue;
    }

    @Override
    public AuthorizeDataReturnVO getAuthorizeDataReturnVO(AuthorizeVO authorizeModel, List<AuthorizeEntity> list, DataValuesQuery dataValuesQuery, String objectId) {
        AuthorizeDataReturnVO dataReturnVO = new AuthorizeDataReturnVO();
        if (!StringUtils.isEmpty((String)dataValuesQuery.getType())) {
            switch (dataValuesQuery.getType()) {
                case "module": {
                    List<ModuleEntity> moduleList = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    dataReturnVO = this.module(moduleList, list, authorizeModel);
                    return dataReturnVO;
                }
                case "button": {
                    List moduleList1 = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    List<ModuleEntity> selectList1 = new ArrayList<ModuleEntity>();
                    if (!StringUtils.isEmpty((String)dataValuesQuery.getModuleIds())) {
                        List<String> moduleId1 = Arrays.asList(dataValuesQuery.getModuleIds().split(","));
                        selectList1 = moduleList1.stream().filter(t -> moduleId1.contains(t.getId())).collect(Collectors.toList());
                    }
                    List<ModuleButtonEntity> moduleButtonList = this.buttonService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    dataReturnVO = this.moduleButton(selectList1, moduleButtonList, list, authorizeModel);
                    return dataReturnVO;
                }
                case "column": {
                    List moduleList2 = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    List<ModuleEntity> selectList2 = new ArrayList<ModuleEntity>();
                    if (!StringUtils.isEmpty((String)dataValuesQuery.getModuleIds())) {
                        List<String> moduleId2 = Arrays.asList(dataValuesQuery.getModuleIds().split(","));
                        selectList2 = moduleList2.stream().filter(t -> moduleId2.contains(t.getId())).collect(Collectors.toList());
                    }
                    List<ModuleColumnEntity> moduleColumnList = this.columnService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    dataReturnVO = this.moduleColumn(selectList2, moduleColumnList, list, authorizeModel);
                    return dataReturnVO;
                }
                case "resource": {
                    List moduleList3 = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    List<ModuleEntity> selectList3 = new ArrayList<ModuleEntity>();
                    if (!StringUtils.isEmpty((String)dataValuesQuery.getModuleIds())) {
                        List<String> moduleId3 = Arrays.asList(dataValuesQuery.getModuleIds().split(","));
                        selectList3 = moduleList3.stream().filter(t -> moduleId3.contains(t.getId())).collect(Collectors.toList());
                    }
                    List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList = this.schemeService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    dataReturnVO = this.resourceData(selectList3, moduleDataSchemeList, list, authorizeModel);
                    return dataReturnVO;
                }
                case "form": {
                    List moduleList4 = this.moduleService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    List<ModuleEntity> selectList4 = new ArrayList<ModuleEntity>();
                    if (!StringUtils.isEmpty((String)dataValuesQuery.getModuleIds())) {
                        List<String> moduleId4 = Arrays.asList(dataValuesQuery.getModuleIds().split(","));
                        selectList4 = moduleList4.stream().filter(t -> moduleId4.contains(t.getId())).collect(Collectors.toList());
                    }
                    List<ModuleFormEntity> moduleFormList = this.formService.getList().stream().filter(m -> "1".equals(String.valueOf(m.getEnabledMark()))).collect(Collectors.toList());
                    dataReturnVO = this.moduleForm(selectList4, moduleFormList, list, authorizeModel);
                    return dataReturnVO;
                }
                case "userList": {
                    List<UserEntity> userEntityList = this.userService.getUserListByRoleId(objectId);
                    dataReturnVO = this.roleUserList(userEntityList);
                    return dataReturnVO;
                }
            }
        }
        return dataReturnVO;
    }

    @Override
    public AuthorizeDataReturnVO module(List<ModuleEntity> moduleListAll, List<AuthorizeEntity> authorizeList, AuthorizeVO authorizeModel) {
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        List<ModuleModel> moduleList = authorizeModel.getModuleList();
        List<String> moduleModeId = moduleListAll.stream().map(t -> t.getId()).collect(Collectors.toList());
        List<String> ids = authorizeList.stream().filter(t -> "module".equals(t.getItemType())).map(t -> t.getItemId()).collect(Collectors.toList());
        moduleModeId.addAll(ids);
        List treeList = JsonUtil.getJsonToList(moduleList, AuthorizeDataModel.class);
        List trees = TreeDotUtils.convertListToTreeDot((List)treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, AuthorizeDataReturnModel.class);
        vo.setAll(moduleModeId);
        vo.setIds(ids);
        vo.setList(data);
        return vo;
    }

    @Override
    public AuthorizeDataReturnVO moduleButton(List<ModuleEntity> moduleList, List<ModuleButtonEntity> moduleButton, List<AuthorizeEntity> authorizeList, AuthorizeVO authorizeModel) {
        List<Object> treeList = new ArrayList();
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List<ButtonModel> buttonList = authorizeModel.getButtonList();
        List<String> moduleModeId = moduleList.stream().map(t -> t.getId()).collect(Collectors.toList());
        List buttonModeId = buttonList.stream().map(t -> t.getModuleId()).collect(Collectors.toList());
        moduleModeId.addAll(buttonModeId);
        List<String> ids = authorizeList.stream().filter(t -> "button".equals(t.getItemType())).map(t -> t.getItemId()).collect(Collectors.toList());
        for (ButtonModel buttonModel : buttonList) {
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(buttonModel.getId());
            treeModel.setFullName(buttonModel.getFullName());
            treeModel.setParentId(buttonModel.getModuleId());
            treeModel.setIcon(buttonModel.getIcon());
            ModuleEntity info = this.moduleService.getInfo(buttonModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeList.add((Object)treeModel);
        }
        List list = moduleList.stream().filter(t -> buttonModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(list, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, AuthorizeDataReturnModel.class);
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setAll(moduleModeId);
        vo.setIds(ids);
        vo.setList(data);
        return vo;
    }

    @Override
    public AuthorizeDataReturnVO moduleColumn(List<ModuleEntity> moduleList, List<ModuleColumnEntity> moduleColumnList, List<AuthorizeEntity> authorizeList, AuthorizeVO authorizeModel) {
        List<Object> treeList = new ArrayList();
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List<ColumnModel> columnList = authorizeModel.getColumnList();
        List<String> moduleModeId = moduleList.stream().map(t -> t.getId()).collect(Collectors.toList());
        List columnModeId = columnList.stream().map(t -> t.getModuleId()).collect(Collectors.toList());
        moduleModeId.addAll(columnModeId);
        List<String> ids = authorizeList.stream().filter(t -> "column".equals(t.getItemType())).map(t -> t.getItemId()).collect(Collectors.toList());
        for (ColumnModel columnModel : columnList) {
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(columnModel.getId());
            treeModel.setFullName(columnModel.getFullName());
            treeModel.setParentId(columnModel.getModuleId());
            ModuleEntity info = this.moduleService.getInfo(columnModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeModel.setIcon("fa fa-tags column");
            treeList.add((Object)treeModel);
        }
        List list = moduleList.stream().filter(t -> columnModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(list, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, AuthorizeDataReturnModel.class);
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setAll(moduleModeId);
        vo.setIds(ids);
        vo.setList(data);
        return vo;
    }

    @Override
    public AuthorizeDataReturnVO moduleForm(List<ModuleEntity> moduleList, List<ModuleFormEntity> moduleFormList, List<AuthorizeEntity> authorizeList, AuthorizeVO authorizeModel) {
        List<Object> treeList = new ArrayList();
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List<ModuleFormModel> formList = authorizeModel.getFormsList();
        List<String> moduleModeId = moduleList.stream().map(t -> t.getId()).collect(Collectors.toList());
        List formModeId = formList.stream().map(t -> t.getModuleId()).collect(Collectors.toList());
        moduleModeId.addAll(formModeId);
        List<String> ids = authorizeList.stream().filter(t -> "form".equals(t.getItemType())).map(t -> t.getItemId()).collect(Collectors.toList());
        for (ModuleFormModel columnModel : formList) {
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(columnModel.getId());
            treeModel.setFullName(columnModel.getFullName());
            treeModel.setParentId(columnModel.getModuleId());
            ModuleEntity info = this.moduleService.getInfo(columnModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeModel.setIcon("fa fa-binoculars resource");
            treeList.add((Object)treeModel);
        }
        List list = moduleList.stream().filter(t -> formModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(list, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, AuthorizeDataReturnModel.class);
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setAll(moduleModeId);
        vo.setIds(ids);
        vo.setList(data);
        return vo;
    }

    @Override
    public AuthorizeDataReturnVO resourceData(List<ModuleEntity> moduleList, List<ModuleDataAuthorizeSchemeEntity> moduleDataSchemeList, List<AuthorizeEntity> authorizeList, AuthorizeVO authorizeModel) {
        List<Object> treeList = new ArrayList();
        List appId = moduleList.stream().filter(t -> "App".equals(t.getCategory()) || t.getType() == 0).map(t -> t.getId()).collect(Collectors.toList());
        List<ResourceModel> resourceList = authorizeModel.getResourceList();
        List<String> moduleModeId = moduleList.stream().map(t -> t.getId()).collect(Collectors.toList());
        List resourceModeId = resourceList.stream().map(t -> t.getModuleId()).collect(Collectors.toList());
        moduleModeId.addAll(resourceModeId);
        List<String> ids = authorizeList.stream().filter(t -> "resource".equals(t.getItemType())).map(t -> t.getItemId()).collect(Collectors.toList());
        for (ResourceModel resourceModel : resourceList) {
            AuthorizeModel treeModel = new AuthorizeModel();
            treeModel.setId(resourceModel.getId());
            treeModel.setFullName(resourceModel.getFullName());
            treeModel.setParentId(resourceModel.getModuleId());
            ModuleEntity info = this.moduleService.getInfo(resourceModel.getModuleId());
            treeModel.setCategory(ObjectUtil.isNotNull((Object)info) ? info.getCategory() : "");
            treeModel.setIcon("fa fa-binoculars resource");
            treeList.add((Object)treeModel);
        }
        List list = moduleList.stream().filter(t -> resourceModeId.contains(t.getId())).collect(Collectors.toList());
        List moduleListAll = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere(list, moduleList), AuthorizeModel.class);
        treeList.addAll(moduleListAll);
        treeList = treeList.stream().sorted(Comparator.comparing(AuthorizeModel::getSortCode)).collect(Collectors.toList());
        List trees = TreeDotUtils.convertListToTreeDot(treeList, (String)"-1");
        List data = JsonUtil.getJsonToList((Object)trees, AuthorizeDataReturnModel.class);
        AuthorizeDataReturnVO vo = new AuthorizeDataReturnVO();
        vo.setAll(moduleModeId);
        vo.setIds(ids);
        vo.setList(data);
        return vo;
    }

    private AuthorizeDataReturnVO roleUserList(List<UserEntity> userEntityList) {
        AuthorizeDataReturnVO dataReturnVO = new AuthorizeDataReturnVO();
        ArrayList<AuthorizeDataReturnModel> userList = new ArrayList<AuthorizeDataReturnModel>();
        for (UserEntity userEntity : userEntityList) {
            AuthorizeDataReturnModel authorizeDataReturnModel = new AuthorizeDataReturnModel();
            authorizeDataReturnModel.setId(userEntity.getId());
            authorizeDataReturnModel.setFullName(userEntity.getRealName());
            userList.add(authorizeDataReturnModel);
        }
        dataReturnVO.setList(userList);
        return dataReturnVO;
    }
}

