/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.system.permission.util;

import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.system.permission.model.authorize.AuthorizeDataReturnModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RecursiveRemovalUtil {
    public static void main(String[] args) {
        String jsonInput = "[{\"id\":\"444023864675010437\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u7cfb\u7edf\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n[{\"id\":\"445967278584890757\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u7f6e\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u5b57\u5178\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"445966332937110917\",\"fullName\":\"\u65b0\u589e\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n{\"id\":\"444023864675010437\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u7cfb\u7edf\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n[{\"id\":\"445967278584890757\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u7f6e\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313989\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u5b57\u5178\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109115\",\"fullName\":\"\u5220\u9664\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n{\"id\":\"444023864675010437\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u7cfb\u7edf\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n[{\"id\":\"4459672785848907571\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u8bbe\u7f6e1\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"4459663310203139891\",\"fullName\":\"\u56fa\u5b9a\u8d44\u4ea7\u5b57\u51781\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109115\",\"fullName\":\"\u5220\u9664\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]},\n{\"id\":\"444023864675010434\",\"fullName\":\"\u4eba\u4e8b\u7ba1\u7406\",\"icon\":\"el-icon-s-order\",\"sortCode\":20,\"children\":\n[{\"id\":\"445967278584890751\",\"fullName\":\"\u4eba\u4e8b\u8bbe\u7f6e\",\"icon\":\"icon-ym icon-ym-report-icon-configuration\",\"sortCode\":99,\"children\":[{\"id\":\"445966331020313981\",\"fullName\":\"\u4eba\u4e8b\u5b57\u5178\",\"icon\":\"ym-custom ym-custom-view-module\",\"sortCode\":99,\"children\":[{\"id\":\"4459663329371109111\",\"fullName\":\"\u5220\u9664\",\"icon\":\"el-icon-plus\",\"sortCode\":0}]}]}]}]";
        List originalList = JsonUtil.getJsonToList((String)jsonInput, AuthorizeDataReturnModel.class);
        List<AuthorizeDataReturnModel> authorizeDataReturnModels = RecursiveRemovalUtil.deduplicateAndMerge(originalList);
        List<AuthorizeDataReturnModel> authorizeDataReturnModelList = new ArrayList<AuthorizeDataReturnModel>();
        for (int i = 0; i < authorizeDataReturnModels.size(); ++i) {
            AuthorizeDataReturnModel authorizeDataReturnModel = authorizeDataReturnModels.get(i);
            if (!StringUtils.isNotEmpty((String)authorizeDataReturnModel.getType())) continue;
            authorizeDataReturnModelList.add(authorizeDataReturnModel);
        }
        String str = JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString();
        if (str.contains("$ref")) {
            authorizeDataReturnModelList = RecursiveRemovalUtil.deduplicateAndKeepDeepest(authorizeDataReturnModelList);
        }
        System.out.println(JsonUtil.getListToJsonArray(authorizeDataReturnModelList).toJSONString());
    }

    public static List<AuthorizeDataReturnModel> deduplicateAndKeepDeepest(List<AuthorizeDataReturnModel> list) {
        HashMap<String, AuthorizeDataReturnModel> idNodeMap = new HashMap<String, AuthorizeDataReturnModel>();
        ArrayList<AuthorizeDataReturnModel> result = new ArrayList<AuthorizeDataReturnModel>();
        for (AuthorizeDataReturnModel node : list) {
            String nodeId = node.getId();
            if (idNodeMap.containsKey(nodeId)) {
                AuthorizeDataReturnModel existingNode = (AuthorizeDataReturnModel)idNodeMap.get(nodeId);
                if (RecursiveRemovalUtil.isDeepest(node, existingNode)) {
                    idNodeMap.put(nodeId, node);
                }
            } else {
                idNodeMap.put(nodeId, node);
                result.add(node);
            }
            if (node.getChildren() == null) continue;
            node.setChildren(RecursiveRemovalUtil.deduplicateAndKeepDeepest(node.getChildren()));
        }
        return result;
    }

    private static boolean isDeepest(AuthorizeDataReturnModel newNode, AuthorizeDataReturnModel existingNode) {
        int existingNodeDepth;
        if (newNode.getChildren() == null || existingNode.getChildren() == null) {
            return newNode.getChildren() == null && existingNode.getChildren() == null;
        }
        int newNodeDepth = RecursiveRemovalUtil.countChildrenDepth(newNode);
        return newNodeDepth > (existingNodeDepth = RecursiveRemovalUtil.countChildrenDepth(existingNode));
    }

    private static int countChildrenDepth(AuthorizeDataReturnModel node) {
        if (node.getChildren() == null) {
            return 0;
        }
        int depth = 1;
        for (AuthorizeDataReturnModel child : node.getChildren()) {
            depth += RecursiveRemovalUtil.countChildrenDepth(child);
        }
        return depth;
    }

    public static List<AuthorizeDataReturnModel> deduplicateAndMerge(List<AuthorizeDataReturnModel> list) {
        HashMap<String, AuthorizeDataReturnModel> nodeMap = new HashMap<String, AuthorizeDataReturnModel>();
        ArrayList<AuthorizeDataReturnModel> result = new ArrayList<AuthorizeDataReturnModel>();
        for (AuthorizeDataReturnModel node : list) {
            String nodeId = node.getId();
            if (nodeMap.containsKey(nodeId)) {
                AuthorizeDataReturnModel existingNode = (AuthorizeDataReturnModel)nodeMap.get(nodeId);
                existingNode = RecursiveRemovalUtil.mergeNodes(existingNode, node);
                nodeMap.put(nodeId, existingNode);
            } else {
                nodeMap.put(nodeId, node);
                node.setType("root");
                result.add(node);
            }
            if (node.getChildren() == null) continue;
            for (AuthorizeDataReturnModel childNode : node.getChildren()) {
                RecursiveRemovalUtil.deduplicateAndMerge(Collections.singletonList(childNode), nodeMap, result);
            }
        }
        return result;
    }

    private static AuthorizeDataReturnModel mergeNodes(AuthorizeDataReturnModel node1, AuthorizeDataReturnModel node2) {
        if (StringUtils.isNotEmpty(node2.getChildren())) {
            node1.getChildren().addAll(node2.getChildren());
        }
        return node1;
    }

    private static void deduplicateAndMerge(List<AuthorizeDataReturnModel> children, Map<String, AuthorizeDataReturnModel> nodeMap, List<AuthorizeDataReturnModel> result) {
        for (AuthorizeDataReturnModel childNode : children) {
            String childNodeId = childNode.getId();
            if (nodeMap.containsKey(childNodeId)) {
                AuthorizeDataReturnModel mergedChild = RecursiveRemovalUtil.mergeNodes(nodeMap.get(childNodeId), childNode);
                nodeMap.put(childNodeId, mergedChild);
            } else {
                nodeMap.put(childNodeId, childNode);
                result.add(childNode);
            }
            if (childNode.getChildren() == null) continue;
            RecursiveRemovalUtil.deduplicateAndMerge(childNode.getChildren(), nodeMap, result);
        }
    }
}

