package com.bringspring.system.base.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;
/**
 * 区域分组管理
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2025-05-13
 */
@Data
@TableName("BASE_PROVINCE_GROUP")
public class AreagroupEntity  {

    /** 自然主键 **/
    @TableId("ID")
    private String id;

    /** 名称 **/
    @TableField("FULL_NAME")
    private String fullName;

    /** 编码 **/
    @TableField("ENCODE")
    private String encode;

    /** 类型 **/
    @TableField("TYPE")
    private String type;

    /** 所属公司 **/
    @TableField("COMPANY_ID")
    private String companyId;

    /** 所属组织 **/
    @TableField("ORGANIZE_ID")
    private String organizeId;

    /** 说明 **/
    @TableField("DESCRIPTION")
    private String description;

    /** 有效标志 **/
    @TableField("ENABLED_MARK")
    private Integer enabledMark;

    /** 排序 **/
    @TableField("SORT_CODE")
    private Long sortCode;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;
    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;
    @TableField(value = "LAST_MODIFY_USER_ID", fill = FieldFill.UPDATE)
    private String lastModifyUserId;
    @TableField(value = "LAST_MODIFY_TIME", fill = FieldFill.UPDATE)
    private Date lastModifyTime;


    /** 删除标志 **/
    @TableField("DELETE_MARK")
    private Integer deleteMark;

    /** 删除时间 **/
    @TableField("DELETE_TIME")
    private Date deleteTime;

    /** 删除用户 **/
    @TableField("DELETE_USER_ID")
    private String deleteUserId;

    @TableField("DIRECTLY_ORG_ID")
    private String directlyOrgId;
}
