package com.bringspring.system.base.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.mapper.AreagroupMapper;
import com.bringspring.system.base.model.areagroup.AreagroupCrForm;
import com.bringspring.system.base.model.areagroup.AreagroupPagination;
import com.bringspring.system.base.model.areagroup.AreagroupUpForm;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ArearelationService;
import com.bringspring.system.base.service.ProvinceService;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 *
 * 区域分组管理
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-05-13
 */
@Service
public class AreagroupServiceImpl extends ServiceImpl<AreagroupMapper, AreagroupEntity> implements AreagroupService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private AuthorizeService authorizeService;

    @Autowired
    private ArearelationService arearelationService;

    @Autowired
    private ProvinceService provinceService;



    /**
     * 区域分组管理列表分页查询
     * @param areagroupPagination 查询参数
     * @return List<AreagroupEntity>
     */
    @Override
    public List<AreagroupEntity> getList(AreagroupPagination areagroupPagination){
        String userId=userProvider.get().getUserId();
        List<String> AllIdList =new ArrayList();
        int total=0;
		int areagroupNum =0;
        QueryWrapper<AreagroupEntity> areagroupQueryWrapper=new QueryWrapper<>();
        boolean pcPermission = true;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader("jsbos-origin").equals("pc");
        if (isPc && pcPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object crmProductBuyObj = authorizeService.getCondition(new AuthorizeConditionModel(areagroupQueryWrapper, areagroupPagination.getMenuId(), "base_province_group"));
                if (ObjectUtil.isEmpty(crmProductBuyObj)) {
                    return new ArrayList<>();
                } else {
                    areagroupQueryWrapper = (QueryWrapper<AreagroupEntity>) crmProductBuyObj;
                }
            }
        }
        if (!isPc && appPermission) {
            if (!userProvider.get().getIsAdministrator()) {
                Object crmProductBuyObj = authorizeService.getCondition(new AuthorizeConditionModel(areagroupQueryWrapper, areagroupPagination.getMenuId(), "base_province_group"));
                if (ObjectUtil.isEmpty(crmProductBuyObj)) {
                    return new ArrayList<>();
                } else {
                    areagroupQueryWrapper = (QueryWrapper<AreagroupEntity>) crmProductBuyObj;
                }


            }
        }
		int arearelationNum =0;
        QueryWrapper<ArearelationEntity> arearelationQueryWrapper=new QueryWrapper<>();
        if (ObjectUtil.isNotEmpty(areagroupPagination.getType())) {
            areagroupNum++;
            areagroupQueryWrapper.lambda().eq(AreagroupEntity::getType, areagroupPagination.getType());
        }

        if (ObjectUtil.isNotEmpty(areagroupPagination.getCompanyId())) {
            areagroupNum++;
            areagroupQueryWrapper.lambda().eq(AreagroupEntity::getCompanyId, areagroupPagination.getCompanyId());
        }

        if (StringUtils.isNotEmpty(areagroupPagination.getFullName())) {
            areagroupNum++;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName,areagroupPagination.getFullName());
            }

			if(StringUtils.isNotEmpty(areagroupPagination.getEncode())){
            areagroupNum++;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getEncode,areagroupPagination.getEncode());
            }


        if (StringUtils.isNotEmpty(areagroupPagination.getOrganizeId())) {
            areagroupNum++;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getOrganizeId, areagroupPagination.getOrganizeId());
        }

        if (StringUtils.isNotEmpty(areagroupPagination.getKeyword())) {
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName, areagroupPagination.getKeyword())
                    .or().like(AreagroupEntity::getEncode, areagroupPagination.getKeyword());
        }
        if(AllIdList.size()>0){
            areagroupQueryWrapper.lambda().in(AreagroupEntity::getId, AllIdList);
        }
        //排序
        if(StringUtils.isEmpty(areagroupPagination.getSidx())){
        areagroupQueryWrapper.lambda().orderByDesc(AreagroupEntity::getId);
        }else{
            try {
                String sidx = areagroupPagination.getSidx();
                AreagroupEntity areagroupEntity = new AreagroupEntity();
                Field declaredField = areagroupEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                areagroupQueryWrapper="asc".equals(areagroupPagination.getSort().toLowerCase())?areagroupQueryWrapper.orderByAsc(value):areagroupQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if((total>0 && AllIdList.size()>0) || total==0){
        Page<AreagroupEntity> page=new Page<>(areagroupPagination.getCurrentPage(), areagroupPagination.getPageSize());
        IPage<AreagroupEntity> userIPage=this.page(page, areagroupQueryWrapper);
        return areagroupPagination.setData(userIPage.getRecords(),userIPage.getTotal());
        }else{
            List<AreagroupEntity> list = new ArrayList();
            return areagroupPagination.setData(list, list.size());
        }
    }
    /**
     * 区域分组管理列表分页查询（导出使用）
     * @param areagroupPagination 查询参数
     * @param dataType 0-当前页；非0-当前查询条件所有数据
     * @return List<AreagroupEntity>
     */
    @Override
    public List<AreagroupEntity> getTypeList(AreagroupPagination areagroupPagination,String dataType){
        String userId=userProvider.get().getUserId();
        List<String> AllIdList =new ArrayList();
		int total=0;
		int areagroupNum =0;
        QueryWrapper<AreagroupEntity> areagroupQueryWrapper=new QueryWrapper<>();
		int arearelationNum =0;
        QueryWrapper<ArearelationEntity> arearelationQueryWrapper=new QueryWrapper<>();
			if(StringUtils.isNotEmpty(areagroupPagination.getFullName())){
            areagroupNum++;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getFullName,areagroupPagination.getFullName());
                    }

			if(StringUtils.isNotEmpty(areagroupPagination.getEncode())){
            areagroupNum++;
            areagroupQueryWrapper.lambda().like(AreagroupEntity::getEncode,areagroupPagination.getEncode());
                    }

		if(AllIdList.size()>0){
        areagroupQueryWrapper.lambda().in(AreagroupEntity::getId, AllIdList);
				}
        //排序
        if(StringUtils.isEmpty(areagroupPagination.getSidx())){
        areagroupQueryWrapper.lambda().orderByDesc(AreagroupEntity::getId);
        }else{
            try {
            	String sidx = areagroupPagination.getSidx();
                AreagroupEntity areagroupEntity = new AreagroupEntity();
				Field declaredField = areagroupEntity.getClass().getDeclaredField(sidx);
				declaredField.setAccessible(true);
				String value = declaredField.getAnnotation(TableField.class).value();
                 areagroupQueryWrapper="asc".equals(areagroupPagination.getSort().toLowerCase())?areagroupQueryWrapper.orderByAsc(value):areagroupQueryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if("0".equals(dataType)){
            if((total>0 && AllIdList.size()>0) || total==0){
                Page<AreagroupEntity> page=new Page<>(areagroupPagination.getCurrentPage(), areagroupPagination.getPageSize());
                IPage<AreagroupEntity> userIPage=this.page(page, areagroupQueryWrapper);
                return areagroupPagination.setData(userIPage.getRecords(),userIPage.getTotal());
            }else{
                List<AreagroupEntity> list = new ArrayList();
                return areagroupPagination.setData(list, list.size());
            }
        }else{
            return this.list(areagroupQueryWrapper);
        }
    }
    /**
     * 获取区域分组管理详细信息
     * @param id 主键
     * @return AreagroupEntity
     */
    @Override
    public AreagroupEntity getInfo(String id){
        QueryWrapper<AreagroupEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.lambda().eq(AreagroupEntity::getId,id);
        return this.getOne(queryWrapper);
    }
    /**
     * 创建区域分组管理操作
     * @param areagroupCrForm 主键
     * @return  boolean 是否成功
     */
    @Override
    @DSTransactional
    public void create(AreagroupCrForm areagroupCrForm){
        String mainId = RandomUtil.uuId();
        AreagroupEntity entity = JsonUtil.getJsonToBean(areagroupCrForm, AreagroupEntity.class);
        entity.setId(mainId);
    this.save(entity);

    }
    /**
     * 更新区域分组管理操作
     * @param id 主键
     * @param areagroupUpForm 主键
     * @return  boolean 是否成功
     */
    @Override
    @DSTransactional
    public void update(String id, AreagroupUpForm areagroupUpForm){
        UserInfo userInfo=userProvider.get();
    AreagroupEntity entity= this.getInfo(id);
        if(entity!=null){
    AreagroupEntity subentity=JsonUtil.getJsonToBean(areagroupUpForm, AreagroupEntity.class);
        this.updateById(subentity);
        }
    }

    @Override
    public List<AreagroupEntity> getProList(List<String> ProIdList) {
        if (ProIdList.size() > 0) {
            QueryWrapper<AreagroupEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().select(AreagroupEntity::getId, AreagroupEntity::getFullName).in(AreagroupEntity::getId
                    , ProIdList);
            return this.list(queryWrapper);
        }
        return new ArrayList<>();
    }
    @Override
    public List<String> getAreaIdsByCompanyId(String companyId, String modelId) {
        QueryWrapper<AreagroupEntity> queryWrapper = new QueryWrapper<>();
//        queryWrapper.lambda().eq(AreagroupEntity::getCompanyId, companyId).or().isNull(AreagroupEntity::getCompanyId);
        if (!userProvider.get().getIsAdministrator()) {
            Object crmCustomerVerifyObj = authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, modelId, "base_province_group"));
            if (ObjectUtil.isEmpty(crmCustomerVerifyObj)) {
//                queryWrapper.lambda().eq(AreagroupEntity::getCompanyId, userProvider.get().getOrganizeId()).or().isNull(AreagroupEntity::getCompanyId);
                return new ArrayList<>();
            } else {
                queryWrapper = (QueryWrapper<AreagroupEntity>) crmCustomerVerifyObj;
            }
        }
        List<AreagroupEntity> areagroupList = this.list(queryWrapper);
        List<String> returnIds = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(areagroupList)){
            List<ArearelationEntity> listByObjects = arearelationService.getListByObjects(areagroupList.stream().map(AreagroupEntity::getId).collect(Collectors.toList()));
            // 改变格式只取最后一个
            List<String> areaIds = listByObjects.stream().map(ArearelationEntity::getProvinceId).collect(Collectors.toList());

            areaIds.forEach(id -> {
                List<String> jsonToList = JsonUtil.getJsonToList(id, String.class);
                returnIds.add(jsonToList.get(jsonToList.size() - 1));
            });
        }

        return returnIds;
    }


    @Override
    public List<AreagroupEntity> getListByCompanyType(String companyId, String type) {
        QueryWrapper<AreagroupEntity> queryWrapper=new QueryWrapper<>();
        if (ObjectUtil.isNotEmpty(companyId)) {
            queryWrapper.lambda().in(AreagroupEntity::getCompanyId, companyId.split(","));
        }
        if (ObjectUtil.isNotEmpty(type)){
            queryWrapper.lambda().eq(AreagroupEntity::getType,type);
        }
        List<AreagroupEntity> areagroupEntityList = this.list(queryWrapper);
        return areagroupEntityList;
    }

    @Override
    public List<List<String>> areaGroupToArea(List<List<String>> address) {
        List<List<String>> returnAddress = new ArrayList<>();
        // 第一级转换成原有大区
        address.forEach(area -> {
            if (area.size() > 1) {
                String province = area.get(1);
                ProvinceEntity info = provinceService.getInfo(province);
                if (ObjectUtil.isNotEmpty(info)) {
                    area.set(0, info.getParentId());
                }
                returnAddress.add(area);
            }
            if (area.size() == 1) {
                // 返回分组下所有区域
//                area = new ArrayList<>();
                List<ArearelationEntity> listByObjects = arearelationService.getListByObjects(area);
                if (ObjectUtil.isNotEmpty(listByObjects)) {
                    listByObjects.forEach(v -> {
//                        ProvinceEntity info = provinceService.getInfo(v.getProvinceId());
                        List<String> jsonToList = JsonUtil.getJsonToList(v.getProvinceId(), String.class);
//                        area.set(0, jsonToList.get(0));
//                        area.add(jsonToList.get(1));
                        returnAddress.add(jsonToList);
                    });
                } else {
                    returnAddress.add(area);
                }
            }
        });
        return returnAddress;
    }

    /**
     * 删除区域分组管理操作
     * @param entity
     * @return
     */
    @Override
    @DSTransactional
    public void delete(AreagroupEntity entity){
        if(entity!=null){
            this.removeById(entity.getId());
        }
    }
    //子表方法



}