package com.bringspring.system.base.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.mapper.ArearelationMapper;
import com.bringspring.system.base.service.ArearelationService;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;

/**
 *
 * base_province_relation
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2025-05-13
 */
@Service
public class ArearelationServiceImpl extends ServiceImpl<ArearelationMapper, ArearelationEntity> implements ArearelationService {


    @Override
    public List<ArearelationEntity> getList(String objectType, String objectId) {
        QueryWrapper<ArearelationEntity> arearelationQueryWrapper = new QueryWrapper<>();
        if (ObjectUtil.isNotEmpty(objectType)) {
            arearelationQueryWrapper.lambda().eq(ArearelationEntity::getObjectType, objectType);
        }
        arearelationQueryWrapper.lambda().eq(ArearelationEntity::getObjectId, objectId);
        return this.list(arearelationQueryWrapper);
    }

    @Override
    public List<ArearelationEntity> getListByObjects(List<String> objectId) {
        QueryWrapper<ArearelationEntity> arearelationQueryWrapper = new QueryWrapper<>();
        arearelationQueryWrapper.lambda().in(ArearelationEntity::getObjectId, objectId);
        return this.list(arearelationQueryWrapper);

    }
}