package com.bringspring.system.base.service.impl;


import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.Page;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.entity.AreagroupEntity;
import com.bringspring.system.base.entity.ArearelationEntity;
import com.bringspring.system.base.entity.ProvinceEntity;
import com.bringspring.system.base.mapper.ProvinceMapper;
import com.bringspring.system.base.model.areagroup.AreagroupQuery;
import com.bringspring.system.base.model.province.ProvinceListQuery;
import com.bringspring.system.base.service.AreagroupService;
import com.bringspring.system.base.service.ArearelationService;
import com.bringspring.system.base.service.ProvinceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 行政区划
 *
 * @author RKKJ开发平台组
 * @version V1.0.0
 * @copyright 荣科科技股份有限公司
 * @date 2017年9月27日 上午9:18
 */
@Service
public class ProvinceServiceImpl extends ServiceImpl<ProvinceMapper, ProvinceEntity> implements ProvinceService {

    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ProvinceService provinceService;
    @Autowired
    private AreagroupService areagroupService;

    @Autowired
    private ArearelationService arearelationService;

    @Override
    public boolean isExistByFullName(String fullName, String id) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProvinceEntity::getFullName, fullName);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(ProvinceEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public boolean isExistByEnCode(String enCode, String id) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProvinceEntity::getEnCode, enCode);
        if (!StringUtils.isEmpty(id)) {
            queryWrapper.lambda().ne(ProvinceEntity::getId, id);
        }
        return this.count(queryWrapper) > 0 ? true : false;
    }

    @Override
    public List<ProvinceEntity> getListByParentId(String parentId) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProvinceEntity::getParentId, parentId);
        // 排序
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
        return this.list(queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getListByParentIdAuth(String parentId, String modelId) {
        // 用户权限判断// 用户所属公司
        // 根据用户所属公司查询公司下的区域分组，在根据区域分组查询区域
        UserInfo userInfo = userProvider.get();
        String organizeId = userInfo.getOrganizeId();
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        if (!userProvider.get().getIsAdministrator()) {
            List<String> areaIdsByCompanyId = areagroupService.getAreaIdsByCompanyId(organizeId, modelId);
        if (ObjectUtil.isNotEmpty(areaIdsByCompanyId)) {
            queryWrapper.lambda().eq(ProvinceEntity::getParentId, parentId).in(ProvinceEntity::getId, areaIdsByCompanyId);
            // 排序
            queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
            return this.list(queryWrapper);
        } else {
            return new ArrayList<>();
        }
        } else {
            queryWrapper.lambda().eq(ProvinceEntity::getParentId, parentId);
            // 排序
            queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
            return this.list(queryWrapper);
        }
    }


    @Override
    public List<ProvinceEntity> SelectorAuthByGroup(String groupId) {
        // 公司 ，类型 根据参数查询指定范围的区域
        List<String> returnAreaIds = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(groupId)) {
            List<ArearelationEntity> listByObjects = arearelationService.getList(null, groupId);
            // 改变格式只取最后一个
            List<String> areaIds = listByObjects.stream().map(ArearelationEntity::getProvinceId).collect(Collectors.toList());

            areaIds.forEach(id -> {
                List<String> jsonToList = JsonUtil.getJsonToList(id, String.class);
                returnAreaIds.add(jsonToList.get(jsonToList.size() - 1));
            });
        }
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        if (ObjectUtil.isNotEmpty(returnAreaIds)) {
            queryWrapper.lambda().in(ProvinceEntity::getId, returnAreaIds);
            // 排序
            queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
            return this.list(queryWrapper);
        } else {
            return new ArrayList<>();
        }

    }

    @Override
    public List<ProvinceEntity> SelectorAuthByGroupLevelOne(AreagroupQuery areagroupQuery) {
        return Collections.emptyList();
    }

    @Override
    public List<ProvinceEntity> getListByCityLevel(String cityLevel) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProvinceEntity::getCityLevel, cityLevel);
        // 排序
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode);
        return this.list(queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getListByNodeId(String parentId, Page page) {
        // 定义变量判断是否需要使用修改时间倒序
        boolean flag = false;
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        // 模糊查询
        if (Objects.nonNull(page) && StringUtils.isNotEmpty(page.getKeyword())) {
            flag = true;
            queryWrapper.lambda().and(
                    t -> t.like(ProvinceEntity::getFullName, page.getKeyword()).or()
                            .like(ProvinceEntity::getEnCode, page.getKeyword())
            );
        }
        queryWrapper.lambda().eq(ProvinceEntity::getParentId, parentId);
        // 排序
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode).orderByDesc(ProvinceEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(ProvinceEntity::getLastModifyTime);
        }
        return this.list(queryWrapper);
    }


    @Override
    public List<ProvinceEntity> getListAll(ProvinceListQuery query) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();

        String keyword = query.getKeyword();
        if (StringUtils.isNotEmpty(keyword)) {
            queryWrapper.lambda().and(t -> t.like(ProvinceEntity::getFullName, keyword).or().like(ProvinceEntity::getEnCode, keyword).or().like(ProvinceEntity::getQuickQuery, keyword));
        }
        if (StringUtils.isNotEmpty(query.getEnCode())) {
            queryWrapper.lambda().like(ProvinceEntity::getEnCode, query.getEnCode());
        }
        if (StringUtils.isNotEmpty(query.getFullName())) {
            queryWrapper.lambda().like(ProvinceEntity::getFullName, query.getFullName());
        }
        if (StringUtils.isNotEmpty(query.getQuickQuery())) {
            queryWrapper.lambda().like(ProvinceEntity::getQuickQuery, query.getQuickQuery());
        }
        if (StringUtils.isNotEmpty(query.getParentId())) {
            queryWrapper.lambda().eq(ProvinceEntity::getParentId, query.getParentId());
        }
        if (StringUtils.isNotEmpty(query.getType())) {
            queryWrapper.lambda().eq(ProvinceEntity::getType, query.getType());
        }
//        queryWrapper.lambda().eq(ProvinceEntity::getDeleteMark, NOT_DELETE.getCode());
        // 排序
        queryWrapper.lambda().orderByAsc(ProvinceEntity::getSortCode).orderByAsc(ProvinceEntity::getCreatorTime);

        return this.list(queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getAllList() {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().orderByDesc(ProvinceEntity::getSortCode).orderByAsc(ProvinceEntity::getCreatorTime);

        return this.list(queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getAllProList() {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().select(ProvinceEntity::getId, ProvinceEntity::getFullName);
        return this.list(queryWrapper);
    }

    @Override
    public List<ProvinceEntity> getProList(List<String> ProIdList) {
        if (ProIdList.size() > 0) {
            QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().select(ProvinceEntity::getId, ProvinceEntity::getFullName).in(ProvinceEntity::getId
                    , ProIdList);
            return this.list(queryWrapper);
        }
        return new ArrayList<>();
    }


    @Override
    public ProvinceEntity getInfo(String id) {
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(ProvinceEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    public void delete(ProvinceEntity entity) {
        this.removeById(entity.getId());
    }

    @Override
    public void create(ProvinceEntity entity) {
        entity.setId(RandomUtil.uuId());
        if ("-1".equals(entity.getParentId())) {
            entity.setParentIdTree(entity.getId());
//        entity.setTreeNames(entity.getFullName());
        } else {
            entity.setParentIdTree(entity.getParentIdTree() + "," + entity.getId());
//        entity.setTreeNames(entity.getTreeNames() + "/" + entity.getFullName());
        }
        this.save(entity);
    }

    @Override
    public boolean update(String id, ProvinceEntity entity) {

        entity.setId(id);
        if ("-1".equals(entity.getParentId())) {
            entity.setParentIdTree(entity.getId());
//        entity.setTreeNames(entity.getFullName());
        } else {
            entity.setParentIdTree(entity.getParentIdTree() + "," + entity.getId());
//        entity.setTreeNames(entity.getTreeNames() + "/" + entity.getFullName());
        }
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public boolean first(String id) {
        boolean isOk = false;
        //获取要上移的那条数据的信息
        ProvinceEntity upEntity = this.getById(id);
        Long upSortCode = upEntity.getSortCode() == null ? 0 : upEntity.getSortCode();
        //查询上几条记录
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .lt(ProvinceEntity::getSortCode, upSortCode)
                .eq(ProvinceEntity::getParentId, upEntity.getParentId())
                .orderByDesc(ProvinceEntity::getSortCode);
        List<ProvinceEntity> downEntity = this.list(queryWrapper);
        if (downEntity.size() > 0) {
            //交换两条记录的sort值
            Long temp = upEntity.getSortCode();
            upEntity.setSortCode(downEntity.get(0).getSortCode());
            downEntity.get(0).setSortCode(temp);
            updateById(downEntity.get(0));
            updateById(upEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    @DSTransactional
    public boolean next(String id) {
        boolean isOk = false;
        //获取要下移的那条数据的信息
        ProvinceEntity downEntity = this.getById(id);
        Long upSortCode = downEntity.getSortCode() == null ? 0 : downEntity.getSortCode();
        //查询下几条记录
        QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .gt(ProvinceEntity::getSortCode, upSortCode)
                .eq(ProvinceEntity::getParentId, downEntity.getParentId())
                .orderByAsc(ProvinceEntity::getSortCode);
        List<ProvinceEntity> upEntity = this.list(queryWrapper);
        if (upEntity.size() > 0) {
            //交换两条记录的sort值
            Long temp = downEntity.getSortCode();
            downEntity.setSortCode(upEntity.get(0).getSortCode());
            upEntity.get(0).setSortCode(temp);
            updateById(upEntity.get(0));
            updateById(downEntity);
            isOk = true;
        }
        return isOk;
    }

    @Override
    public List<ProvinceEntity> infoList(List<String> lists) {
        List<ProvinceEntity> list = new ArrayList<>();
        if (!ObjectUtils.isEmpty(lists)) {
            QueryWrapper<ProvinceEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().in(ProvinceEntity::getId, lists);
            list = this.list(queryWrapper);
        }
        return list;

    }

    @Override
    public String getAreaIds(String strs) {
        QueryWrapper<ProvinceEntity> provinceQueryWrapper = new QueryWrapper<>();
        String[] str = strs.split("/");
        List<String> list1 = new ArrayList<>();
        String id = "";
        String collect = "";
        List<ProvinceEntity> list2 = new ArrayList<>();
        for (int i = 0; i < str.length; i++) {
            if (i == 0) {
                list2 = provinceService.list(Wrappers.<ProvinceEntity>lambdaQuery().eq(ProvinceEntity::getFullName, str[i]));

            } else {
                list2 = provinceService.list(Wrappers.<ProvinceEntity>lambdaQuery().eq(ProvinceEntity::getFullName,
                        str[i]).eq(ProvinceEntity::getParentId, id));
            }
            ProvinceEntity provinceEntity = list2.get(0);
            id = provinceEntity.getId();
            collect = list2.stream().map(ProvinceEntity::getId).collect(Collectors.joining());
            list1.add(collect);
        }
        String result = list1.stream().map((s) -> "\"" + s + "\"").collect(Collectors.joining(", "));
        result = "[" + result + "]";
        return result;
    }
}
