package com.bringspring.system.base.task;

import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.ModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class BaseSystemLogTask {
    private static final Logger logger = LoggerFactory.getLogger(BaseSystemLogTask.class);
    @Autowired
    private LogService logService;

    /**
     * 定时清除30天前的请求日志和登录日志
     */
    @JsbosTask(fullName = "定时清除请求日志和登录日志", description = "定时清除30天前的请求日志和登录日志")
    public void autoDeleteLog() throws Exception {
        logService.autoDeleteLog();
        logger.info("定时清除30天前的请求日志和登录日志");
    }
    @Autowired
    private ModuleService moduleService;
    /**
     * 重置菜单ParentIds
     */
    @JsbosTask(fullName = "重置菜单ParentIds",description = "重置菜单ParentIds" ,cron = "0 0 0 2 * ?")
    public void updateModuleParentIds(){
        List<ModuleEntity> list = moduleService.getList();
        for (ModuleEntity moduleEntity : list) {
            moduleService.update(moduleEntity.getId(), moduleEntity);
        }
        System.out.println("定时任务示例");
    }
}
