package com.bringspring.system.message.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.model.message.SynThirdInfoCrForm;
import com.bringspring.system.message.util.SynThirdTotal;

import java.util.List;
import java.util.Set;

/**
 * 第三方工具的公司-部门-用户同步表模型
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/23 17:29
 */
public interface SynThirdInfoService extends IService<SynThirdInfoEntity> {

    /**
     * 获取指定第三方工具、指定数据类型的数据列表
     *
     * @param synThirdInfoCrForm
     *
     * @return
     */
    List<SynThirdInfoEntity> getList(SynThirdInfoCrForm synThirdInfoCrForm);

    /**
     * 获取指定第三方工具、指定数据类型的数据列表
     *
     * @param thirdType
     * @param dataType
     * @return
     */
    List<SynThirdInfoEntity> getList(String thirdType, String dataType);

    /**
     * 获取指定第三方工具、指定数据类型、指定应用ID的数据列表
     * @param thirdType 第三方工具类型(1:企业微信;2:钉钉)
     * @param dataType 数据类型(1:组织(公司与部门);2:用户)
     * @param crop 第三方工具应用ID
     * @return
     */
    List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop);

    /**
     * 获取指定第三方工具、指定数据类型、指定应用ID、是否过滤已同步成功的数据列表
     * @param thirdType 第三方工具类型(1:企业微信;2:钉钉)
     * @param dataType 数据类型(1:组织(公司与部门);2:用户)
     * @param crop 第三方工具应用ID
     * @param isOkBySynState 是否过滤已同步成功的
     * @return
     */
    List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop, boolean isOkBySynState);

    /**
     * 获取指定第三方工具、指定数据类型、指定应用ID、是否过滤已同步成功的数据列表
     * @param thirdType 第三方工具类型(1:企业微信;2:钉钉)
     * @param dataType 数据类型(1:组织(公司与部门);2:用户)
     * @param crop 第三方工具应用ID
     * @param isOkBySynState 是否过滤已同步成功的
     * @return
     */
    List<SynThirdInfoEntity> getListByCrop(String thirdType, String dataType, String crop, boolean isOkBySynState, boolean isLinkedCorp);

    /**
     * 获取指定第三方工具、指定数据类型的数据列表
     *
     * @param thirdType
     * @param sysObjId  系统业务ID
     * @return
     */
    List<SynThirdInfoEntity> getListByObjId(Integer thirdType, List<String> sysObjId);

    /**
     * 获取同步的详细信息
     *
     * @param id
     * @return
     */
    SynThirdInfoEntity getInfo(String id);

    void create(SynThirdInfoEntity entity);


    boolean update(String id, SynThirdInfoEntity entity);

    void delete(SynThirdInfoEntity entity);

    /**
     * 获取指定第三方工具、指定数据类型、对象ID的同步信息
     *
     * @param thirdType
     * @param dataType
     * @param sysObjId  系统业务数据id
     * @return
     */
    SynThirdInfoEntity getInfoBySysObjId(String thirdType, String dataType, String sysObjId);

    List<SynThirdInfoEntity> getInfoBySysObjIds(String thirdType, String dataType, String sysObjId);

    List<SynThirdInfoEntity> getInfoBySysObjIds(String thirdType, String dataType, String sysObjId, Boolean isLinkedCorp);

    List<SynThirdInfoEntity> getThirdInfoList(String thirdType, String dataType, String corpId, Set<String> userSet);

    List<SynThirdInfoEntity> getThirdInfoList(String thirdType, String dataType, String corpId, Set<String> userSet, Boolean isLinkedCorp);

    /**
     * 获取指定第三方工具、指定数据类型、对象ID的同步信息
     *
     * @param thirdType
     * @param dataType
     * @param thirdObjId 第三方业务数据ID
     * @return
     */
    SynThirdInfoEntity getInfoByThirdObjId(String thirdType, String dataType, String thirdObjId);

    SynThirdInfoEntity getInfoByThirdObjId(String thirdType, String dataType, String thirdObjId, String corpId);


    List<SynThirdInfoEntity> getInfoByThirdObjIds(String thirdType, String dataType, String thirdObjId);


    List<SynThirdInfoEntity> getListByThirdObjIds(String thirdType, String dataType, String corpId, List<String> thirdObjIds);

    /**
     * 获取指定第三方工具、指定数据类型的同步统计信息
     *
     * @param thirdType
     * @param dataType
     * @return
     */
    SynThirdTotal getSynTotal(String thirdType, String dataType);

    /**
     * 获取指定第三方工具、指定数据类型的同步统计信息
     *
     * @param thirdType
     * @param corpId 企业ID
     * @return
     */
    List<SynThirdTotal> getCorpSynTotal(String thirdType, String corpId);

    /**
     * 获取指定第三方工具、指定数据类型的同步统计信息
     *
     * @param thirdType
     * @param corpId 企业ID
     * @return
     */
    List<SynThirdTotal> getCorpSynTotal(String thirdType, String corpId, boolean isLinkedCorp);


    /**
     * 获取指定第三方工具、指定数据类型的同步统计信息
     *
     * @param thirdType
     * @param dataType
     * @param corpId 企业ID
     * @return
     */
    SynThirdTotal getCorpDataTypeSynTotal(String thirdType, String dataType, String corpId);
    /**
     * 获取指定第三方工具、指定数据类型的同步统计信息
     *
     * @param thirdType
     * @param dataType
     * @param corpId 企业ID
     * @return
     */
    SynThirdTotal getCorpDataTypeSynTotal(String thirdType, String dataType, String corpId, boolean isLinkedCorp);
}
