package com.bringspring.system.msgcenter.constant;


/**
 * 消息中心-公共常量
 */
public interface CommonConsts {
    /**
     * 垂直线分割符
     */
    String PART_VERTICAL = "|";
    /**
     * 英文逗号分割符
     */
    String PART_COMMA = ",";

    /**
     * 指定分割字符
     */
    String DELIMETER = "-";
    /**
     * 指定分割字符 . 号需要转义
     */
    String DELIMETER1 = "\\.";
    /**
     * 指定分割字符 | 号需要转义
     */
    String DELIMETER2 = "\\|";

    /**
     * 所有用户
     */
    String ALL_USERS = "@ALL";

    /**
     * 默认消息模板
     */
    String DEFAULT_TEMPLTATE = "default_templtate";

    /**
     * 消息id
     */
    String MSG_ID = "msg_id";


    /**
     * 渠道消息未发出，自动重发最大限制次数
     */
    Integer AUTO_AGAIN_MAX_NUM = 3;

    /**
     * 未读
     */
    Integer NOT_READ = 0;
    /**
     * 已读
     */
    Integer IS_READ = 1;

    /**
     * SSL安全连接 开
     */
    String SSL_LINK_ON = "开";
    /**
     * SSL安全连接 关
     */
    String SSL_LINK_OFF = "关";

    /**
     * 状态 启用
     */
    String ENABLED_MARK_ON = "启用";
    /**
     * 状态 禁用
     */
    String ENABLED_MARK_OFF = "禁用";

    /**
     * 是否唯一的返回标识
     */
    boolean UNIQUE = true;
    boolean NOT_UNIQUE = false;

    String MSG_DATA_FORMAT = "JSON";

    String SMS_OK = "Ok";

    /**
     * 消息接收人黑名单
     */
    String MC_BLACKLIST = "mcBlacklist";
    /**
     * 消息敏感词
     */
    String MC_SENSITIVE = "mcSensitive";
}
