package com.bringspring.system.msgcenter.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.util.Date;


/**
 * 业务场景消息内容表
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2024-06-14
 */
@Data
@TableName("MC_TASK_MSG_CONTENT")
public class McTaskMsgContentEntity {

    @TableId("ID")
    private String id;

    @TableField("MSG_ID")
    private String msgId;

    @TableField("TEMPLATE_ID")
    private String templateId;

    @TableField("MSG_TEMPLATE_ID")
    private String msgTemplateId;

    @TableField("MSG_ACCOUNT_ID")
    private String msgAccountId;

    @TableField("CHANNEL_TYPE")
    private String channelType;

    @TableField("CONTENT_TYPE")
    private String contentType;

    @TableField("TITLE")
    private String title;

    @TableField("DESCRIPTION")
    private String description;

    @TableField("CONTENT")
    private String content;

    @TableField("LINK_URL")
    private String linkUrl;

    @TableField("PIC_URL")
    private String picUrl;

    @TableField(value = "CREATOR_TIME", fill = FieldFill.INSERT)
    private Date creatorTime;

    @TableField(value = "CREATOR_USER_ID", fill = FieldFill.INSERT)
    private String creatorUserId;

}
