package com.bringspring.system.msgcenter.model.message;

import lombok.Data;

/**
 * 钉钉发送信息配置模型
 *
 * @版本： V1.0.0
 * @版权： 荣科科技股份有限公司
 * @作者： RKKJ开发平台组
 * @日期： 2021/4/22 14:12
 */
@Data
public class MyDingTalkModel {
    /**
     * 应用授权配置id
     */
    private String accountConfigId;
    /**
     * 企业名称
     */
    private String name;
    /**
     * CorpId
     */
    private String corpId;
    /**
     * API Token
     */
    private String apiToken;
    /**
     * App ID
     */
    private String appId;
    /**
     * AgentId
     */
    private String agentId;
    /**
     * Client ID (原 AppKey 和 SuiteKey)
     */
    private String clientId;
    /**
     * Client Secret (原 AppSecret 和 SuiteSecret)
     */
    private String clientSecrent;
    /**
     * 电脑端访问URL
     */
    private String dingComputerUrl;
    /**
     * 移动端访问URL
     */
    private String dingMobileUrl;

    private String orgParent;
    /**
     * 开关限制
     * 启用同步组织
     * 新增、删除、修改组织信息触发同步组织事件
     */
    private Integer dingSynIsSynOrg;

    /**
     * 开关限制
     * 启用同步用户
     * 新增、删除、修改用户信息触发同步用户事件
     */
    private Integer dingSynIsSynUser;

}
