package com.bringspring.system.msgcenter.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.*;
import com.bringspring.system.msgcenter.entity.McTaskMsgContentEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgEntity;
import com.bringspring.system.msgcenter.entity.McTaskMsgReceiveEntity;
import com.bringspring.system.msgcenter.enums.ChannelTypeEnum;
import com.bringspring.system.msgcenter.mapper.McTaskMsgReceiveMapper;
import com.bringspring.system.msgcenter.model.SendReceiveParam;
import com.bringspring.system.msgcenter.model.mcmsgsend.McMsgSendInfoVO;
import com.bringspring.system.msgcenter.model.mcmsgsendtemplate.McMsgSendTemplateModel;
import com.bringspring.system.msgcenter.model.mctaskmsg.McTaskMsgPagination;
import com.bringspring.system.msgcenter.model.mctaskmsgcontent.McTaskMsgContentListQuery;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveCrForm;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveListQuery;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceivePagination;
import com.bringspring.system.msgcenter.model.mctaskmsgreceive.McTaskMsgReceiveUpForm;
import com.bringspring.system.msgcenter.service.McMsgSendService;
import com.bringspring.system.msgcenter.service.McTaskMsgContentService;
import com.bringspring.system.msgcenter.service.McTaskMsgReceiveService;
import com.bringspring.system.msgcenter.service.McTaskMsgService;
import com.bringspring.system.msgcenter.service.strategy.SendMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.util.*;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

import static com.bringspring.system.msgcenter.constant.CommonConsts.DELIMETER;
import static com.bringspring.system.msgcenter.constant.CommonConsts.IS_READ;
import static com.bringspring.system.msgcenter.enums.ChannelTypeEnum.SYS_MSG;

/**
 * 业务场景消息接收记录表
 * 版本： V1.0.0
 * 版权： 荣科科技股份有限公司
 * 作者： RKKJ开发平台组
 * 日期： 2024-06-14
 */
@Service
public class McTaskMsgReceiveServiceImpl extends ServiceImpl<McTaskMsgReceiveMapper, McTaskMsgReceiveEntity> implements McTaskMsgReceiveService {


    @Autowired
    private UserProvider userProvider;

    @Autowired
    private SendMessageService sendMessageService;
    @Autowired
    private McMsgSendService mcMsgSendService;
    @Autowired
    private McTaskMsgContentService mcTaskMsgContentService;
    @Autowired
    private McTaskMsgReceiveService mcTaskMsgReceiveService;
    @Autowired
    private McTaskMsgService mcTaskMsgService;
    @Autowired
    private McTaskMsgReceiveMapper mcTaskMsgReceiveMapper;


    /**
     * 取出线程池
     */
    @Autowired
    private Executor threadPoolExecutor;

    @Override
    public List<McTaskMsgReceiveEntity> getList(McTaskMsgReceivePagination pagination) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgReceiveNum = 0;
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getMsgId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgId, pagination.getMsgId());
        }

        if (StringUtils.isNotEmpty(pagination.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getTemplateId, pagination.getTemplateId());
        }

        if (StringUtils.isNotEmpty(pagination.getKeyword())) {
//            QueryWrapper<McTaskMsgContentEntity> contentQueryWrapper = new QueryWrapper<>();
//            contentQueryWrapper.lambda().select(McTaskMsgContentEntity::getId);
//            contentQueryWrapper.lambda().like(McTaskMsgContentEntity::getTitle, pagination.getKeyword());
//            List<String> contentIds = mcTaskMsgContentService.listObjs(contentQueryWrapper, Object::toString);
//            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getContentId, contentIds);
            StringBuffer sql = new StringBuffer("SELECT id FROM mc_task_msg ");
            sql.append("WHERE id LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR task_code LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR send_code LIKE '%" + pagination.getKeyword() + "%' ");
            sql.append("OR business_key LIKE '%" + pagination.getKeyword() + "%' ");
            queryWrapper.lambda().inSql(McTaskMsgReceiveEntity::getMsgId, sql.toString());
        }

        if (StringUtils.isNotEmpty(pagination.getContentId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getContentId, pagination.getContentId());
        }

        if (StringUtils.isNotEmpty(pagination.getChannelType())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, pagination.getChannelType());
        }

        if (StringUtils.isNotEmpty(pagination.getSysUserId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, pagination.getSysUserId());
        }
        if (ObjectUtil.isNotEmpty(pagination.getSysUserIds()) && pagination.getSysUserIds().length > 0) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getSysUserId, pagination.getSysUserIds());
        }

        if (StringUtils.isNotEmpty(pagination.getReceiveUserId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getReceiveUserId, pagination.getReceiveUserId());
        }

        if (StringUtils.isNotEmpty(pagination.getIsRead())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getIsRead, pagination.getIsRead());
        }
        if (StringUtils.isNotEmpty(pagination.getEnabledMark())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, pagination.getEnabledMark());
        }
        if (StringUtils.isNotEmpty(pagination.getDeleteMark())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getDeleteMark, pagination.getDeleteMark());
        }

        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            mcTaskMsgReceiveNum++;
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));

            queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, new Date(fir))
                    .le(McTaskMsgReceiveEntity::getSendTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " " +
                            "23:59:59"));

        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgReceiveEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = new McTaskMsgReceiveEntity();
                Field declaredField = mcTaskMsgReceiveEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ((total > 0 && AllIdList.size() > 0) || total == 0) {
            Page<McTaskMsgReceiveEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
            IPage<McTaskMsgReceiveEntity> userIPage = this.page(page, queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        } else {
            List<McTaskMsgReceiveEntity> list = new ArrayList();
            return pagination.setData(list, list.size());
        }
    }


    @Override
    public List<McTaskMsgReceiveEntity> getList(McTaskMsgReceiveListQuery listQuery) {
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(listQuery.getMsgId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgId, listQuery.getMsgId());
        }

        if (StringUtils.isNotEmpty(listQuery.getChannelType())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, listQuery.getChannelType());
        }

        if (StringUtils.isNotEmpty(listQuery.getTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getTemplateId, listQuery.getTemplateId());
        }

        if (StringUtils.isNotEmpty(listQuery.getMsgTemplateId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgTemplateId, listQuery.getMsgTemplateId());
        }
        if (StringUtils.isNotEmpty(listQuery.getMsgAccountId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgAccountId, listQuery.getMsgAccountId());
        }

        if (StringUtils.isNotEmpty(listQuery.getReceiveUserId())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getReceiveUserId, listQuery.getReceiveUserId());
        }

        if (CollectionUtil.isNotEmpty(listQuery.getReceiveUserIds())) {
            // receiveUserId批量
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getReceiveUserId, listQuery.getReceiveUserIds());
        }

        if (StringUtils.isNotEmpty(listQuery.getEnabledMark())) {
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, listQuery.getEnabledMark());
        }

        if (CollectionUtil.isNotEmpty(listQuery.getEnabledMarks())) {
            // enabledMark批量
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getEnabledMark, listQuery.getEnabledMarks());
        }

        if (CollectionUtil.isNotEmpty(listQuery.getIds())) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, listQuery.getIds());
        }
        //排序
        queryWrapper.lambda().orderByAsc(McTaskMsgReceiveEntity::getCreatorTime);
        return this.list(queryWrapper);
    }

    @Override
    public List<McTaskMsgReceiveEntity> getTypeList(McTaskMsgReceivePagination pagination, String dataType) {
        String userId = userProvider.get().getUserId();
        List<String> AllIdList = new ArrayList();
        int total = 0;
        int mcTaskMsgReceiveNum = 0;
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        if (StringUtils.isNotEmpty(pagination.getMsgId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgId, pagination.getMsgId());
        }

        if (StringUtils.isNotEmpty(pagination.getContentId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getContentId, pagination.getContentId());
        }

        if (StringUtils.isNotEmpty(pagination.getChannelType())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, pagination.getChannelType());
        }

        if (StringUtils.isNotEmpty(pagination.getSysUserId())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, pagination.getSysUserId());
        }

        if (StringUtils.isNotEmpty(pagination.getEnabledMark())) {
            mcTaskMsgReceiveNum++;
            queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getEnabledMark, pagination.getEnabledMark());
        }

        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            mcTaskMsgReceiveNum++;
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));

            queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, new Date(fir))
                    .le(McTaskMsgReceiveEntity::getSendTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " " +
                            "23:59:59"));

        }

        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, AllIdList);
        }
        //排序
        if (StringUtils.isEmpty(pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(McTaskMsgReceiveEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                McTaskMsgReceiveEntity mcTaskMsgReceiveEntity = new McTaskMsgReceiveEntity();
                Field declaredField = mcTaskMsgReceiveEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ?
                        queryWrapper.orderByAsc(value) : queryWrapper.orderByDesc(value);
            } catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if ((total > 0 && AllIdList.size() > 0) || total == 0) {
                Page<McTaskMsgReceiveEntity> page = new Page<>(pagination.getCurrentPage(), pagination.getPageSize());
                IPage<McTaskMsgReceiveEntity> userIPage = this.page(page, queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            } else {
                List<McTaskMsgReceiveEntity> list = new ArrayList();
                return pagination.setData(list, list.size());
            }
        } else {
            return this.list(queryWrapper);
        }
    }

    @Override
    public McTaskMsgReceiveEntity getInfo(String id) {
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getId, id);
        return this.getOne(queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(McTaskMsgReceiveCrForm mcTaskMsgReceiveCrForm) {
        String mainId = RandomUtil.uuId();
        McTaskMsgReceiveEntity entity = JsonUtil.getJsonToBean(mcTaskMsgReceiveCrForm, McTaskMsgReceiveEntity.class);
        entity.setId(mainId);
        this.save(entity);
    }

    @Override
    @DSTransactional
    public boolean update(String id, McTaskMsgReceiveUpForm mcTaskMsgReceiveUpForm) {
        McTaskMsgReceiveEntity entity = JsonUtil.getJsonToBean(mcTaskMsgReceiveUpForm, McTaskMsgReceiveEntity.class);
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(Integer deleteMark, String[] ids) {
        String userId = userProvider.get().getUserId();
        // 删除状态修改
        UpdateWrapper<McTaskMsgReceiveEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().in(McTaskMsgReceiveEntity::getId, ids);

        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteMark, deleteMark); // 是否有效
        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteTime, new Date()); // 操作时间
        updateWrapper.lambda().set(McTaskMsgReceiveEntity::getDeleteUserId, userId); // 操作人
        this.update(updateWrapper);
    }


    /**
     * 根据message_receive数据，渠道消息下发
     *
     * @param sendReceiveParam 线程参数传递
     */
    @Override
    @Transactional(rollbackFor = Exception.class, isolation = Isolation.READ_UNCOMMITTED)
    public void postSendReceive(SendReceiveParam sendReceiveParam) {
        McTaskMsgEntity taskMsg = sendReceiveParam.getTaskMsg();
        List<McMsgSendTemplateModel> sendTemplateList = sendReceiveParam.getSendTemplateList();
        UserInfo currentUserInfo = sendReceiveParam.getCurrentUserInfo();
        Integer enabledMark = sendReceiveParam.getEnabledMark();

        if (ObjectUtil.isEmpty(taskMsg) || CollectionUtil.isEmpty(sendTemplateList)) {
            return;
        }

        // 业务消息主键id
        String taskMsgId = taskMsg.getId();
        // 业务消息内容检索
        McTaskMsgContentListQuery contentListQuery = new McTaskMsgContentListQuery();
        contentListQuery.setMsgId(taskMsgId);
        // 业务消息接收人检索
        McTaskMsgReceiveListQuery receiveListQuery = new McTaskMsgReceiveListQuery();
        receiveListQuery.setMsgId(taskMsgId); // 消息id
        if (ObjectUtil.isNotEmpty(enabledMark)) { // 接收人发送状态
            receiveListQuery.setEnabledMark(enabledMark.toString());
        }

        for (McMsgSendTemplateModel sendTemplate : sendTemplateList) {
            String templateId = sendTemplate.getId(); // 发送配置消息模板
            String channelType = sendTemplate.getMessageType(); // 消息渠道
            String msgTemplateId = sendTemplate.getTemplateId(); // 消息模板
            String msgAccountId = sendTemplate.getAccountConfigId(); // 授权应用配置

            contentListQuery.setChannelType(channelType);
            contentListQuery.setMsgTemplateId(msgTemplateId);
            contentListQuery.setMsgAccountId(msgAccountId);
            contentListQuery.setTemplateId(templateId);
            // 获取消息内容
            List<McTaskMsgContentEntity> contentList = mcTaskMsgContentService.getList(contentListQuery);
            McTaskMsgContentEntity taskMsgContent = contentList.get(0);

            receiveListQuery.setChannelType(channelType);
            receiveListQuery.setMsgTemplateId(msgTemplateId);
            receiveListQuery.setMsgAccountId(msgAccountId);
            receiveListQuery.setTemplateId(templateId);
            // 获取渠道接收人明细
            List<McTaskMsgReceiveEntity> list = mcTaskMsgReceiveService.getList(receiveListQuery);
            // 渠道消息处理
            if (CollectionUtil.isNotEmpty(list)) {
                // false非重发、info消息、channelType渠道、list接收人明细
                sendMessageService.sendMessageByChannel(
                        false, taskMsg.getToType(), sendTemplate, taskMsgContent, list, currentUserInfo
                );
            }
        }
    }

    @Override
    @DSTransactional
    public void againSendMessage(McTaskMsgEntity taskMsgInfo, List<McTaskMsgReceiveEntity> receiveList) {
        if (ObjectUtil.isNull(taskMsgInfo) || CollectionUtil.isEmpty(receiveList)) {
            return;
        }

        // 发送配置
        String sendCode = taskMsgInfo.getSendCode();
        McMsgSendInfoVO sendInfoVO = mcMsgSendService.getInfoByEnCode(sendCode);
        List<McMsgSendTemplateModel> sendTemplateList = sendInfoVO.getSendTemplateList();
        if (CollectionUtil.isNotEmpty(sendTemplateList)) {
            // 业务消息主键id
            String taskMsgId = taskMsgInfo.getId();
            // 业务消息内容检索
            McTaskMsgContentListQuery contentListQuery = new McTaskMsgContentListQuery();
            contentListQuery.setMsgId(taskMsgId);
            // 业务消息接收人检索
//            McTaskMsgReceiveListQuery receiveListQuery = new McTaskMsgReceiveListQuery();
//            receiveListQuery.setMsgId(taskMsgId); // 消息id
//            receiveListQuery.setIds(Arrays.asList(ids));
            // 执行重发, 忽略站内信
            for (McMsgSendTemplateModel sendTemplate : sendTemplateList) {
                contentListQuery.setTemplateId(sendTemplate.getId()); // 发送配置消息模板
                contentListQuery.setChannelType(sendTemplate.getMessageType()); // 消息内容渠道类型
                // 获取消息内容
                McTaskMsgContentEntity taskMsgContent = mcTaskMsgContentService.getList(contentListQuery).get(0);
//                receiveListQuery.setTemplateId(sendTemplate.getId()); // 发送配置消息模板
//                receiveListQuery.setChannelType(sendTemplate.getMessageType()); // 接收人渠道类型
                // 获取渠道接收人明细
//                List<McTaskMsgReceiveEntity> list = mcTaskMsgReceiveService.getList(receiveListQuery);
                List<McTaskMsgReceiveEntity> list =
                        receiveList.stream().filter(t -> t.getTemplateId().equals(sendTemplate.getId()) && t.getChannelType().equals(sendTemplate.getMessageType())).collect(Collectors.toList());
                // 渠道消息处理
                if (CollectionUtil.isNotEmpty(list)) {
                    // false非重发、info消息、channelType渠道、list接收人明细
                    sendMessageService.sendMessageByChannel(
                            true, taskMsgInfo.getToType(), sendTemplate, taskMsgContent, list, userProvider.get()
                    );
                }
            }
        }
    }

    /**
     * 自动重发
     * 未成功发送的渠道消息，自动尝试重发
     */
    @Override
    public void autoAgainSendMessage() {
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().ne(McTaskMsgReceiveEntity::getChannelType, SYS_MSG.getCode()); // 非站内信
        queryWrapper.lambda().ne(McTaskMsgReceiveEntity::getEnabledMark, 1); // 非成功
        queryWrapper.lambda().lt(McTaskMsgReceiveEntity::getAutoAgainNum, 1000); // 重发次数小于1000
        queryWrapper.lambda().apply("auto_again_num < auto_again_max_num"); // 重发次数小于最大限制次数
        queryWrapper.lambda().orderByAsc(McTaskMsgReceiveEntity::getCreatorTime); //排序
        List<McTaskMsgReceiveEntity> list = this.list(queryWrapper);
        if (CollectionUtil.isNotEmpty(list)) {
            threadPoolExecutor.execute(() -> {
                Map<String, List<McTaskMsgReceiveEntity>> taskMsgMap =
                        list.stream().collect(Collectors.groupingBy(McTaskMsgReceiveEntity::getMsgId));
                try {
                    if (CollectionUtil.isNotEmpty(taskMsgMap)) {
                        //遍历map中的键
                        for (String key : taskMsgMap.keySet()) {
                            McTaskMsgEntity taskMsgInfo = mcTaskMsgService.getInfo(key);
                            if (ObjectUtil.isNotEmpty(taskMsgInfo)) {
                                this.againSendMessage(taskMsgInfo, taskMsgMap.get(key));
                            }
                        }
                    }
                } catch (Exception e) {
                    log.error("未成功发送的渠道消息，自动尝试重发，异常：" + e.getMessage());
                }
            });
        }
    }

    /**
     * 持久化 接收人明细表
     *
     * @param isAgain
     * @param list
     * @param enabledMark
     * @param remark
     */
    @Override
    public void updateByList(boolean isAgain, List<McTaskMsgReceiveEntity> list, Integer enabledMark, String remark,
                             UserInfo currentUserInfo) {
        if (!isAgain) {
            list.stream().forEach(s -> {
                s.setEnabledMark(enabledMark); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                s.setSendTime(new Date());
                s.setSendUserId(currentUserInfo.getUserId());
                s.setDescription(remark);
                s.setAutoAgainNum(0);
            });
        } else {
            list.stream().forEach(s -> {
                s.setEnabledMark(enabledMark); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
                s.setAgainTime(new Date());
                s.setAgainUserId(currentUserInfo.getUserId());
                s.setDescription(remark);
                if (ObjectUtil.isEmpty(s.getAutoAgainNum())) {
                    s.setAutoAgainNum(0);
                } else {
                    s.setAutoAgainNum(s.getAutoAgainNum() + 1);
                }
            });
        }
        this.updateBatchById(list);
    }

    /**
     * 黑名单 接收人明细表
     */
    @Override
    public void updateBlacklist(List<McTaskMsgReceiveEntity> receiveBlacklist, UserInfo currentUserInfo) {
        receiveBlacklist.stream().forEach(s -> {
            s.setDescription("未发送：黑名单成员");
            s.setDeleteMark(1); // 忽略失败
            s.setEnabledMark(2); // 渠道消息下发状态，0待下发、1下/重发成功、2下/重发失败
            s.setSendTime(new Date());
            s.setSendUserId(currentUserInfo.getUserId());
        });
        this.updateBatchById(receiveBlacklist);
    }


    /**
     * 已读
     *
     * @param isAll 是否全部已读：0否 1是
     * @param ids   1或多条已读ids
     */
    @Override
    public void isRead(String isAll, String[] ids) {
        String userId = userProvider.get().getUserId();
        // 是否全部已读
        boolean isAllRead = false;
        // 消息渠道默认站内信
        String channelType = SYS_MSG.getCode();
        if (StringUtils.isNotEmpty(isAll)) {
            String[] split = isAll.split(DELIMETER);
            if (ObjectUtil.isNotEmpty(split)) {
                if ("1".equals(split[0])) {
                    isAllRead = true;
                }
                if (split.length > 1) {
                    channelType = split[1];
                }
            }
        }

        if (isAllRead) {
            // 全部已读
            UpdateWrapper<McTaskMsgReceiveEntity> updateWrapper = new UpdateWrapper<>();
            updateWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, userId); // 接收人,当前登录用户
            updateWrapper.lambda().eq(McTaskMsgReceiveEntity::getChannelType, channelType); // 消息渠道
            updateWrapper.lambda().ne(McTaskMsgReceiveEntity::getIsRead, IS_READ); // 否已读全部

            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getIsRead, IS_READ); // 是否已读
            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getReadTime, new Date()); // 阅读时间
            updateWrapper.lambda().set(McTaskMsgReceiveEntity::getReadCount, 1); // 阅读次数
            this.update(updateWrapper);
        } else {
            if (ObjectUtil.isNotEmpty(ids) && ids.length > 0) {
                QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.lambda().in(McTaskMsgReceiveEntity::getId, ids); // 指定ids
                List<McTaskMsgReceiveEntity> list = this.list(queryWrapper);
                list.stream().forEach(item -> {
                    item.setIsRead(IS_READ);  // 是否已读
                    if (ObjectUtil.isNotEmpty(item.getReadCount()) && item.getReadCount() > 0) {
                        item.setReadCount(item.getReadCount() + 1);
                    } else {
                        item.setReadTime(new Date());  // 阅读时间
                        item.setReadCount(1); // 阅读次数
                    }
                });
                this.updateBatchById(list);
            }

        }
    }

    @Override
    public List<Map<String, Object>> isReadCount() {
        UserInfo userInfo = userProvider.get();
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("is_read, count(1) AS total").eq("receive_user_id", userInfo.getUserId()).groupBy(
                "is_read");
        return baseMapper.selectMaps(queryWrapper);
    }

    @Override
    public void updateIsReadByMsgIdAndUserId(String msgId, String userId) {
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getMsgId, msgId);
        queryWrapper.lambda().eq(McTaskMsgReceiveEntity::getSysUserId, userId);
        List<McTaskMsgReceiveEntity> list = this.list(queryWrapper);
        //不等于空
        if (CollectionUtil.isNotEmpty(list)) {
            List<String> ids = list.stream().map(item -> item.getId()).collect(Collectors.toList());
            this.isRead("0", ids.toArray(new String[ids.size()]));
        }
    }

    @Override
    public List<Map<String, Object>> selectGroupByEnabledMark(McTaskMsgReceivePagination pagination) {
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        // 此处根据menuId 开启数据权限
        // 发送时间
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));

            queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, new Date(fir))
                    .le(McTaskMsgReceiveEntity::getSendTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " " +
                            "23:59:59"));
        }

        return mcTaskMsgReceiveMapper.selectGroupByEnabledMark(queryWrapper);
    }

    @Override
    public Map<String, Object> selectDataPanel(McTaskMsgReceivePagination pagination) {
        Map<String, Object> data = new HashMap<>();
        // 业务消息下发状态
        long sendTaskTotal = 0;
        long sendTaskErr = 0;
        McTaskMsgPagination mcTaskMsgPagination = new McTaskMsgPagination();
        mcTaskMsgPagination.setMenuId(pagination.getMenuId());
        mcTaskMsgPagination.setCreatorTime(pagination.getSendTime());
        List<Map<String, Object>> maps1 = mcTaskMsgService.selectGroupByEnabledMark(mcTaskMsgPagination);
        if (CollectionUtil.isNotEmpty(maps1)) {
            for (Map<String, Object> obj : maps1) {
                Object scount = obj.get("scount");
                sendTaskTotal += (long) scount;
                Object enabled_mark = obj.get("enabled_mark");
                if (!"2".equals(String.valueOf(enabled_mark))) {
                    sendTaskErr += (long) scount;
                }
            }
        }
        data.put("sendTaskTotal", sendTaskTotal);
        data.put("sendTaskErr", sendTaskErr);

        // 消息送达状态
        long sendReceiveTotal = 0;
        long sendReceiveErr = 0;
        List<Map<String, Object>> maps = this.selectGroupByEnabledMark(pagination);
        if (CollectionUtil.isNotEmpty(maps)) {
            for (Map<String, Object> obj : maps) {
                Object scount = obj.get("scount");
                sendReceiveTotal += (long) scount;
                Object enabled_mark = obj.get("enabled_mark");
                if (!"1".equals(String.valueOf(enabled_mark))) {
                    sendReceiveErr += (long) scount;
                }
            }
        }
        data.put("sendReceiveTotal", sendReceiveTotal);
        data.put("sendReceiveErr", sendReceiveErr);

        return data;
    }

    @Override
    public List<Map<String, Object>> selectGroupByChannelType(McTaskMsgReceivePagination pagination) {
        List<Map<String, Object>> resultMap = new ArrayList<>();
        Map<String, ChannelTypeEnum> allToMap = ChannelTypeEnum.getAllToMap();
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        // 此处根据menuId 开启数据权限
        // 发送时间
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));

            queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, new Date(fir))
                    .le(McTaskMsgReceiveEntity::getSendTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " " +
                            "23:59:59"));
        }
        List<Map<String, Object>> maps = mcTaskMsgReceiveMapper.selectGroupByChannelType(queryWrapper);
        for (Map.Entry<String, ChannelTypeEnum> entry : allToMap.entrySet()) {
            System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
            Map<String, Object> data = new HashMap<>();
            data.put("code", entry.getValue().getCode());
            data.put("channel", entry.getValue().getChannel());
            Map<String, Object> channelType =
                    maps.stream().filter(t -> entry.getKey().equals(t.get("channel_type"))).findFirst().orElse(null);
            if (CollectionUtil.isNotEmpty(channelType)) {
                data.put("scount", channelType.get("scount"));
            } else {
                data.put("scount", 0);
            }
            resultMap.add(data);
        }
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> selectGroupBySendTime(McTaskMsgReceivePagination pagination, int i) {
        List<Map<String, Object>> resultMap = new ArrayList<>();
        List<String> frontDate = new ArrayList<>();
        QueryWrapper<McTaskMsgReceiveEntity> queryWrapper = new QueryWrapper<>();
        // 此处根据menuId 开启数据权限
        // 发送时间
        if (StringUtils.isNotEmpty(pagination.getSendTime())) {
            List<String> SendTimeList = pagination.getSendTime();
            Long fir = Long.valueOf(SendTimeList.get(0));
            Long sec = Long.valueOf(SendTimeList.get(1));

            queryWrapper.lambda().ge(McTaskMsgReceiveEntity::getSendTime, new Date(fir))
                    .le(McTaskMsgReceiveEntity::getSendTime, DateUtil.stringToDate(DateUtil.daFormatYmd(sec) + " " +
                            "23:59:59"));

            // 获取固定日期范围内的所有日期
            List<Date> allDays = DateUtil.getAllDays(new Date(fir), new Date(sec));
            for (Date date : allDays) {
                frontDate.add(DateUtil.daFormat(date));
            }
        }
        if (CollectionUtil.isEmpty(frontDate)) {
            if (ObjectUtil.isEmpty(i) || i == 0) i = 7;
            frontDate.addAll(DateUtil.getFrontDate(new Date(), i));
        }
        String firstDate = frontDate.get(i - 1);
        queryWrapper.lambda().gt(McTaskMsgReceiveEntity::getSendTime, firstDate);
        List<Map<String, Object>> maps = mcTaskMsgReceiveMapper.selectGroupBySendTime(queryWrapper);
        for (String dateStr : frontDate) {
            Map<String, Object> sendTime =
                    maps.stream().filter(t -> t.get("send_time").equals(dateStr)).findFirst().orElse(null);
            if (CollectionUtil.isEmpty(sendTime)) {
                sendTime = new HashMap<>();
                sendTime.put("send_time", dateStr);
                sendTime.put("scount", 0);
            }
            resultMap.add(sendTime);
        }
        return resultMap;
    }
}